/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.okio;

import com.squareup.okhttp.internal.okio.BufferedSink;
import com.squareup.okhttp.internal.okio.Deadline;
import com.squareup.okhttp.internal.okio.OkBuffer;
import com.squareup.okhttp.internal.okio.Okio;
import com.squareup.okhttp.internal.okio.Segment;
import com.squareup.okhttp.internal.okio.SegmentPool;
import com.squareup.okhttp.internal.okio.Sink;
import com.squareup.okhttp.internal.okio.Util;
import java.io.IOException;
import java.util.zip.Deflater;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public final class DeflaterSink
implements Sink {
    private final BufferedSink sink;
    private final Deflater deflater;
    private boolean closed;

    public DeflaterSink(Sink sink, Deflater deflater) {
        this.sink = Okio.buffer(sink);
        this.deflater = deflater;
    }

    @Override
    public void write(OkBuffer source, long byteCount) throws IOException {
        Util.checkOffsetAndCount(source.size, 0L, byteCount);
        while (byteCount > 0L) {
            Segment head2 = source.head;
            int toDeflate = (int)Math.min(byteCount, (long)(head2.limit - head2.pos));
            this.deflater.setInput(head2.data, head2.pos, toDeflate);
            this.deflate(false);
            source.size -= (long)toDeflate;
            head2.pos += toDeflate;
            if (head2.pos == head2.limit) {
                source.head = head2.pop();
                SegmentPool.INSTANCE.recycle(head2);
            }
            byteCount -= (long)toDeflate;
        }
    }

    @IgnoreJRERequirement
    private void deflate(boolean syncFlush) throws IOException {
        OkBuffer buffer = this.sink.buffer();
        while (true) {
            int deflated;
            Segment s2 = buffer.writableSegment(1);
            int n = deflated = syncFlush ? this.deflater.deflate(s2.data, s2.limit, 2048 - s2.limit, 2) : this.deflater.deflate(s2.data, s2.limit, 2048 - s2.limit);
            if (deflated > 0) {
                s2.limit += deflated;
                buffer.size += (long)deflated;
                this.sink.emitCompleteSegments();
                continue;
            }
            if (this.deflater.needsInput()) break;
        }
    }

    @Override
    public void flush() throws IOException {
        this.deflate(true);
        this.sink.flush();
    }

    @Override
    public void close() throws IOException {
        Throwable thrown;
        block9: {
            block8: {
                if (this.closed) {
                    return;
                }
                thrown = null;
                try {
                    this.deflater.finish();
                    this.deflate(false);
                }
                catch (Throwable e) {
                    thrown = e;
                }
                try {
                    this.deflater.end();
                }
                catch (Throwable e) {
                    if (thrown != null) break block8;
                    thrown = e;
                }
            }
            try {
                this.sink.close();
            }
            catch (Throwable e) {
                if (thrown != null) break block9;
                thrown = e;
            }
        }
        this.closed = true;
        if (thrown != null) {
            Util.sneakyRethrow(thrown);
        }
    }

    @Override
    public Sink deadline(Deadline deadline) {
        this.sink.deadline(deadline);
        return this;
    }

    public String toString() {
        return "DeflaterSink(" + this.sink + ")";
    }
}

