/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.okio;

import com.squareup.okhttp.internal.okio.BufferedSink;
import com.squareup.okhttp.internal.okio.BufferedSource;
import com.squareup.okhttp.internal.okio.ByteString;
import com.squareup.okhttp.internal.okio.Deadline;
import com.squareup.okhttp.internal.okio.Segment;
import com.squareup.okhttp.internal.okio.SegmentPool;
import com.squareup.okhttp.internal.okio.Util;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class OkBuffer
implements BufferedSource,
BufferedSink,
Cloneable {
    Segment head;
    long size;

    public long size() {
        return this.size;
    }

    @Override
    public OkBuffer buffer() {
        return this;
    }

    @Override
    public OutputStream outputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) {
                OkBuffer.this.writeByte((byte)b);
            }

            @Override
            public void write(byte[] data2, int offset, int byteCount) {
                OkBuffer.this.write(data2, offset, byteCount);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }

            public String toString() {
                return this + ".outputStream()";
            }
        };
    }

    @Override
    public OkBuffer emitCompleteSegments() {
        return this;
    }

    @Override
    public boolean exhausted() {
        return this.size == 0L;
    }

    @Override
    public void require(long byteCount) throws EOFException {
        if (this.size < byteCount) {
            throw new EOFException();
        }
    }

    @Override
    public long seek(byte b) throws EOFException {
        long index2 = this.indexOf(b);
        if (index2 == -1L) {
            throw new EOFException();
        }
        return index2;
    }

    @Override
    public InputStream inputStream() {
        return new InputStream(){

            @Override
            public int read() {
                return OkBuffer.this.readByte() & 0xFF;
            }

            @Override
            public int read(byte[] sink, int offset, int byteCount) {
                return OkBuffer.this.read(sink, offset, byteCount);
            }

            @Override
            public int available() {
                return (int)Math.min(OkBuffer.this.size, Integer.MAX_VALUE);
            }

            @Override
            public void close() {
            }

            public String toString() {
                return OkBuffer.this + ".inputStream()";
            }
        };
    }

    public long completeSegmentByteCount() {
        long result2 = this.size;
        if (result2 == 0L) {
            return 0L;
        }
        Segment tail = this.head.prev;
        if (tail.limit < 2048) {
            result2 -= (long)(tail.limit - tail.pos);
        }
        return result2;
    }

    @Override
    public byte readByte() {
        if (this.size == 0L) {
            throw new IllegalStateException("size == 0");
        }
        Segment segment = this.head;
        int pos = segment.pos;
        int limit = segment.limit;
        byte[] data2 = segment.data;
        byte b = data2[pos++];
        --this.size;
        if (pos == limit) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        } else {
            segment.pos = pos;
        }
        return b;
    }

    public byte getByte(long i) {
        Util.checkOffsetAndCount(this.size, i, 1L);
        Segment s2 = this.head;
        int segmentByteCount;
        while (i >= (long)(segmentByteCount = s2.limit - s2.pos)) {
            i -= (long)segmentByteCount;
            s2 = s2.next;
        }
        return s2.data[s2.pos + (int)i];
    }

    @Override
    public short readShort() {
        if (this.size < 2L) {
            throw new IllegalArgumentException("size < 2: " + this.size);
        }
        Segment segment = this.head;
        int limit = segment.limit;
        int pos = segment.pos;
        if (limit - pos < 2) {
            int s2 = (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
            return (short)s2;
        }
        byte[] data2 = segment.data;
        int s3 = (data2[pos++] & 0xFF) << 8 | data2[pos++] & 0xFF;
        this.size -= 2L;
        if (pos == limit) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        } else {
            segment.pos = pos;
        }
        return (short)s3;
    }

    @Override
    public int readInt() {
        if (this.size < 4L) {
            throw new IllegalArgumentException("size < 4: " + this.size);
        }
        Segment segment = this.head;
        int limit = segment.limit;
        int pos = segment.pos;
        if (limit - pos < 4) {
            return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
        }
        byte[] data2 = segment.data;
        int i = (data2[pos++] & 0xFF) << 24 | (data2[pos++] & 0xFF) << 16 | (data2[pos++] & 0xFF) << 8 | data2[pos++] & 0xFF;
        this.size -= 4L;
        if (pos == limit) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        } else {
            segment.pos = pos;
        }
        return i;
    }

    @Override
    public int readShortLe() {
        return Util.reverseBytesShort(this.readShort());
    }

    @Override
    public int readIntLe() {
        return Util.reverseBytesInt(this.readInt());
    }

    @Override
    public ByteString readByteString(long byteCount) {
        return new ByteString(this.readBytes(byteCount));
    }

    @Override
    public String readUtf8(long byteCount) {
        Util.checkOffsetAndCount(this.size, 0L, byteCount);
        if (byteCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + byteCount);
        }
        if (byteCount == 0L) {
            return "";
        }
        Segment head2 = this.head;
        if ((long)head2.pos + byteCount > (long)head2.limit) {
            try {
                return new String(this.readBytes(byteCount), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        try {
            String result2 = new String(head2.data, head2.pos, (int)byteCount, "UTF-8");
            head2.pos = (int)((long)head2.pos + byteCount);
            this.size -= byteCount;
            if (head2.pos == head2.limit) {
                this.head = head2.pop();
                SegmentPool.INSTANCE.recycle(head2);
            }
            return result2;
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public String readUtf8Line(boolean throwOnEof) throws EOFException {
        long newline = this.indexOf((byte)10);
        if (newline == -1L) {
            if (throwOnEof) {
                throw new EOFException();
            }
            return this.size != 0L ? this.readUtf8(this.size) : null;
        }
        if (newline > 0L && this.getByte(newline - 1L) == 13) {
            String result2 = this.readUtf8(newline - 1L);
            this.skip(2L);
            return result2;
        }
        String result3 = this.readUtf8(newline);
        this.skip(1L);
        return result3;
    }

    private byte[] readBytes(long byteCount) {
        Util.checkOffsetAndCount(this.size, 0L, byteCount);
        if (byteCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + byteCount);
        }
        int offset = 0;
        byte[] result2 = new byte[(int)byteCount];
        while ((long)offset < byteCount) {
            int toCopy = (int)Math.min(byteCount - (long)offset, (long)(this.head.limit - this.head.pos));
            System.arraycopy(this.head.data, this.head.pos, result2, offset, toCopy);
            offset += toCopy;
            this.head.pos += toCopy;
            if (this.head.pos != this.head.limit) continue;
            Segment toRecycle = this.head;
            this.head = toRecycle.pop();
            SegmentPool.INSTANCE.recycle(toRecycle);
        }
        this.size -= byteCount;
        return result2;
    }

    int read(byte[] sink, int offset, int byteCount) {
        Segment s2 = this.head;
        if (s2 == null) {
            return -1;
        }
        int toCopy = Math.min(byteCount, s2.limit - s2.pos);
        System.arraycopy(s2.data, s2.pos, sink, offset, toCopy);
        s2.pos += toCopy;
        this.size -= (long)toCopy;
        if (s2.pos == s2.limit) {
            this.head = s2.pop();
            SegmentPool.INSTANCE.recycle(s2);
        }
        return toCopy;
    }

    public void clear() {
        this.skip(this.size);
    }

    @Override
    public void skip(long byteCount) {
        Util.checkOffsetAndCount(this.size, 0L, byteCount);
        this.size -= byteCount;
        while (byteCount > 0L) {
            int toSkip = (int)Math.min(byteCount, (long)(this.head.limit - this.head.pos));
            byteCount -= (long)toSkip;
            this.head.pos += toSkip;
            if (this.head.pos != this.head.limit) continue;
            Segment toRecycle = this.head;
            this.head = toRecycle.pop();
            SegmentPool.INSTANCE.recycle(toRecycle);
        }
    }

    @Override
    public OkBuffer write(ByteString byteString) {
        return this.write(byteString.data, 0, byteString.data.length);
    }

    @Override
    public OkBuffer writeUtf8(String string2) {
        try {
            byte[] data2 = string2.getBytes("UTF-8");
            return this.write(data2, 0, data2.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public OkBuffer write(byte[] source) {
        return this.write(source, 0, source.length);
    }

    @Override
    public OkBuffer write(byte[] source, int offset, int byteCount) {
        int limit = offset + byteCount;
        while (offset < limit) {
            Segment tail = this.writableSegment(1);
            int toCopy = Math.min(limit - offset, 2048 - tail.limit);
            System.arraycopy(source, offset, tail.data, tail.limit, toCopy);
            offset += toCopy;
            tail.limit += toCopy;
        }
        this.size += (long)byteCount;
        return this;
    }

    @Override
    public OkBuffer writeByte(int b) {
        Segment tail = this.writableSegment(1);
        tail.data[tail.limit++] = (byte)b;
        ++this.size;
        return this;
    }

    @Override
    public OkBuffer writeShort(int s2) {
        Segment tail = this.writableSegment(2);
        byte[] data2 = tail.data;
        int limit = tail.limit;
        data2[limit++] = (byte)(s2 >> 8 & 0xFF);
        data2[limit++] = (byte)(s2 & 0xFF);
        tail.limit = limit;
        this.size += 2L;
        return this;
    }

    @Override
    public OkBuffer writeInt(int i) {
        Segment tail = this.writableSegment(4);
        byte[] data2 = tail.data;
        int limit = tail.limit;
        data2[limit++] = (byte)(i >> 24 & 0xFF);
        data2[limit++] = (byte)(i >> 16 & 0xFF);
        data2[limit++] = (byte)(i >> 8 & 0xFF);
        data2[limit++] = (byte)(i & 0xFF);
        tail.limit = limit;
        this.size += 4L;
        return this;
    }

    Segment writableSegment(int minimumCapacity) {
        if (minimumCapacity < 1 || minimumCapacity > 2048) {
            throw new IllegalArgumentException();
        }
        if (this.head == null) {
            this.head.next = this.head.prev = (this.head = SegmentPool.INSTANCE.take());
            return this.head.prev;
        }
        Segment tail = this.head.prev;
        if (tail.limit + minimumCapacity > 2048) {
            tail = tail.push(SegmentPool.INSTANCE.take());
        }
        return tail;
    }

    @Override
    public void write(OkBuffer source, long byteCount) {
        if (source == this) {
            throw new IllegalArgumentException("source == this");
        }
        Util.checkOffsetAndCount(source.size, 0L, byteCount);
        while (byteCount > 0L) {
            if (byteCount < (long)(source.head.limit - source.head.pos)) {
                Segment tail;
                Segment segment = tail = this.head != null ? this.head.prev : null;
                if (tail == null || byteCount + (long)(tail.limit - tail.pos) > 2048L) {
                    source.head = source.head.split((int)byteCount);
                } else {
                    source.head.writeTo(tail, (int)byteCount);
                    source.size -= byteCount;
                    this.size += byteCount;
                    return;
                }
            }
            Segment segmentToMove = source.head;
            long movedByteCount = segmentToMove.limit - segmentToMove.pos;
            source.head = segmentToMove.pop();
            if (this.head == null) {
                this.head.next = this.head.prev = (this.head = segmentToMove);
            } else {
                Segment tail = this.head.prev;
                tail = tail.push(segmentToMove);
                tail.compact();
            }
            source.size -= movedByteCount;
            this.size += movedByteCount;
            byteCount -= movedByteCount;
        }
    }

    @Override
    public long read(OkBuffer sink, long byteCount) {
        if (this.size == 0L) {
            return -1L;
        }
        if (byteCount > this.size) {
            byteCount = this.size;
        }
        sink.write(this, byteCount);
        return byteCount;
    }

    @Override
    public OkBuffer deadline(Deadline deadline) {
        return this;
    }

    public long indexOf(byte b) {
        return this.indexOf(b, 0L);
    }

    public long indexOf(byte b, long fromIndex) {
        Segment s2 = this.head;
        if (s2 == null) {
            return -1L;
        }
        long offset = 0L;
        do {
            int segmentByteCount;
            if (fromIndex > (long)(segmentByteCount = s2.limit - s2.pos)) {
                fromIndex -= (long)segmentByteCount;
            } else {
                byte[] data2 = s2.data;
                long limit = s2.limit;
                for (long pos = (long)s2.pos + fromIndex; pos < limit; ++pos) {
                    if (data2[(int)pos] != b) continue;
                    return offset + pos - (long)s2.pos;
                }
                fromIndex = 0L;
            }
            offset += (long)segmentByteCount;
        } while ((s2 = s2.next) != this.head);
        return -1L;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    List<Integer> segmentSizes() {
        if (this.head == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> result2 = new ArrayList<Integer>();
        result2.add(this.head.limit - this.head.pos);
        Segment s2 = this.head.next;
        while (s2 != this.head) {
            result2.add(s2.limit - s2.pos);
            s2 = s2.next;
        }
        return result2;
    }

    public boolean equals(Object o) {
        long count2;
        if (!(o instanceof OkBuffer)) {
            return false;
        }
        OkBuffer that = (OkBuffer)o;
        if (this.size != that.size) {
            return false;
        }
        if (this.size == 0L) {
            return true;
        }
        Segment sa = this.head;
        Segment sb = that.head;
        int posA = sa.pos;
        int posB = sb.pos;
        for (long pos = 0L; pos < this.size; pos += count2) {
            count2 = Math.min(sa.limit - posA, sb.limit - posB);
            int i = 0;
            while ((long)i < count2) {
                if (sa.data[posA++] != sb.data[posB++]) {
                    return false;
                }
                ++i;
            }
            if (posA == sa.limit) {
                sa = sa.next;
                posA = sa.pos;
            }
            if (posB != sb.limit) continue;
            sb = sb.next;
            posB = sb.pos;
        }
        return true;
    }

    public int hashCode() {
        Segment s2 = this.head;
        if (s2 == null) {
            return 0;
        }
        int result2 = 1;
        do {
            int limit = s2.limit;
            for (int pos = s2.pos; pos < limit; ++pos) {
                result2 = 31 * result2 + s2.data[pos];
            }
        } while ((s2 = s2.next) != this.head);
        return result2;
    }

    public String toString() {
        if (this.size == 0L) {
            return "OkBuffer[size=0]";
        }
        if (this.size <= 16L) {
            ByteString data2 = this.clone().readByteString(this.size);
            return String.format("OkBuffer[size=%s data=%s]", this.size, data2.hex());
        }
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(this.head.data, this.head.pos, this.head.limit - this.head.pos);
            Segment s2 = this.head.next;
            while (s2 != this.head) {
                md5.update(s2.data, s2.pos, s2.limit - s2.pos);
                s2 = s2.next;
            }
            return String.format("OkBuffer[size=%s md5=%s]", this.size, ByteString.of(md5.digest()).hex());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }

    public OkBuffer clone() {
        OkBuffer result2 = new OkBuffer();
        if (this.size() == 0L) {
            return result2;
        }
        result2.write(this.head.data, this.head.pos, this.head.limit - this.head.pos);
        Segment s2 = this.head.next;
        while (s2 != this.head) {
            result2.write(s2.data, s2.pos, s2.limit - s2.pos);
            s2 = s2.next;
        }
        return result2;
    }
}

