/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.okio;

import com.squareup.okhttp.internal.okio.BufferedSink;
import com.squareup.okhttp.internal.okio.ByteString;
import com.squareup.okhttp.internal.okio.Deadline;
import com.squareup.okhttp.internal.okio.OkBuffer;
import com.squareup.okhttp.internal.okio.Sink;
import com.squareup.okhttp.internal.okio.Util;
import java.io.IOException;
import java.io.OutputStream;

final class RealBufferedSink
implements BufferedSink {
    public final OkBuffer buffer;
    public final Sink sink;
    private boolean closed;

    public RealBufferedSink(Sink sink, OkBuffer buffer) {
        if (sink == null) {
            throw new IllegalArgumentException("sink == null");
        }
        this.buffer = buffer;
        this.sink = sink;
    }

    public RealBufferedSink(Sink sink) {
        this(sink, new OkBuffer());
    }

    @Override
    public OkBuffer buffer() {
        return this.buffer;
    }

    @Override
    public void write(OkBuffer source, long byteCount) throws IOException {
        this.checkNotClosed();
        this.buffer.write(source, byteCount);
        this.emitCompleteSegments();
    }

    @Override
    public BufferedSink write(ByteString byteString) throws IOException {
        this.checkNotClosed();
        this.buffer.write(byteString);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeUtf8(String string2) throws IOException {
        this.checkNotClosed();
        this.buffer.writeUtf8(string2);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink write(byte[] source) throws IOException {
        this.checkNotClosed();
        this.buffer.write(source);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink write(byte[] source, int offset, int byteCount) throws IOException {
        this.checkNotClosed();
        this.buffer.write(source, offset, byteCount);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeByte(int b) throws IOException {
        this.checkNotClosed();
        this.buffer.writeByte(b);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeShort(int s2) throws IOException {
        this.checkNotClosed();
        this.buffer.writeShort(s2);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeInt(int i) throws IOException {
        this.checkNotClosed();
        this.buffer.writeInt(i);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink emitCompleteSegments() throws IOException {
        this.checkNotClosed();
        long byteCount = this.buffer.completeSegmentByteCount();
        if (byteCount > 0L) {
            this.sink.write(this.buffer, byteCount);
        }
        return this;
    }

    @Override
    public OutputStream outputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                this.checkNotClosed();
                RealBufferedSink.this.buffer.writeByte((byte)b);
                RealBufferedSink.this.emitCompleteSegments();
            }

            @Override
            public void write(byte[] data2, int offset, int byteCount) throws IOException {
                this.checkNotClosed();
                RealBufferedSink.this.buffer.write(data2, offset, byteCount);
                RealBufferedSink.this.emitCompleteSegments();
            }

            @Override
            public void flush() throws IOException {
                if (!RealBufferedSink.this.closed) {
                    RealBufferedSink.this.flush();
                }
            }

            @Override
            public void close() throws IOException {
                RealBufferedSink.this.close();
            }

            public String toString() {
                return RealBufferedSink.this + ".outputStream()";
            }

            private void checkNotClosed() throws IOException {
                if (RealBufferedSink.this.closed) {
                    throw new IOException("closed");
                }
            }
        };
    }

    @Override
    public void flush() throws IOException {
        this.checkNotClosed();
        if (this.buffer.size > 0L) {
            this.sink.write(this.buffer, this.buffer.size);
        }
        this.sink.flush();
    }

    @Override
    public void close() throws IOException {
        Throwable thrown;
        block7: {
            if (this.closed) {
                return;
            }
            thrown = null;
            try {
                if (this.buffer.size > 0L) {
                    this.sink.write(this.buffer, this.buffer.size);
                }
            }
            catch (Throwable e) {
                thrown = e;
            }
            try {
                this.sink.close();
            }
            catch (Throwable e) {
                if (thrown != null) break block7;
                thrown = e;
            }
        }
        this.closed = true;
        if (thrown != null) {
            Util.sneakyRethrow(thrown);
        }
    }

    @Override
    public Sink deadline(Deadline deadline) {
        this.sink.deadline(deadline);
        return this;
    }

    public String toString() {
        return "buffer(" + this.sink + ")";
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
    }
}

