/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.okio;

import com.squareup.okhttp.internal.okio.BufferedSource;
import com.squareup.okhttp.internal.okio.ByteString;
import com.squareup.okhttp.internal.okio.Deadline;
import com.squareup.okhttp.internal.okio.OkBuffer;
import com.squareup.okhttp.internal.okio.Source;
import com.squareup.okhttp.internal.okio.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class RealBufferedSource
implements BufferedSource {
    public final OkBuffer buffer;
    public final Source source;
    private boolean closed;

    public RealBufferedSource(Source source, OkBuffer buffer) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        this.buffer = buffer;
        this.source = source;
    }

    public RealBufferedSource(Source source) {
        this(source, new OkBuffer());
    }

    @Override
    public OkBuffer buffer() {
        return this.buffer;
    }

    @Override
    public long read(OkBuffer sink, long byteCount) throws IOException {
        long read2;
        if (byteCount < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + byteCount);
        }
        this.checkNotClosed();
        if (this.buffer.size == 0L && (read2 = this.source.read(this.buffer, 2048L)) == -1L) {
            return -1L;
        }
        long toRead = Math.min(byteCount, this.buffer.size);
        return this.buffer.read(sink, toRead);
    }

    @Override
    public boolean exhausted() throws IOException {
        this.checkNotClosed();
        return this.buffer.exhausted() && this.source.read(this.buffer, 2048L) == -1L;
    }

    @Override
    public void require(long byteCount) throws IOException {
        this.checkNotClosed();
        while (this.buffer.size < byteCount) {
            if (this.source.read(this.buffer, 2048L) != -1L) continue;
            throw new EOFException();
        }
    }

    @Override
    public byte readByte() throws IOException {
        this.require(1L);
        return this.buffer.readByte();
    }

    @Override
    public ByteString readByteString(long byteCount) throws IOException {
        this.require(byteCount);
        return this.buffer.readByteString(byteCount);
    }

    @Override
    public String readUtf8(long byteCount) throws IOException {
        this.require(byteCount);
        return this.buffer.readUtf8(byteCount);
    }

    @Override
    public String readUtf8Line(boolean throwOnEof) throws IOException {
        long newline;
        this.checkNotClosed();
        long start = 0L;
        while ((newline = this.buffer.indexOf((byte)10, start)) == -1L) {
            start = this.buffer.size;
            if (this.source.read(this.buffer, 2048L) != -1L) continue;
            if (throwOnEof) {
                throw new EOFException();
            }
            return this.buffer.size != 0L ? this.readUtf8(this.buffer.size) : null;
        }
        if (newline > 0L && this.buffer.getByte(newline - 1L) == 13) {
            String result2 = this.readUtf8(newline - 1L);
            this.skip(2L);
            return result2;
        }
        String result3 = this.readUtf8(newline);
        this.skip(1L);
        return result3;
    }

    @Override
    public short readShort() throws IOException {
        this.require(2L);
        return this.buffer.readShort();
    }

    @Override
    public int readShortLe() throws IOException {
        this.require(2L);
        return this.buffer.readShortLe();
    }

    @Override
    public int readInt() throws IOException {
        this.require(4L);
        return this.buffer.readInt();
    }

    @Override
    public int readIntLe() throws IOException {
        this.require(4L);
        return this.buffer.readIntLe();
    }

    @Override
    public void skip(long byteCount) throws IOException {
        this.checkNotClosed();
        while (byteCount > 0L) {
            if (this.buffer.size == 0L && this.source.read(this.buffer, 2048L) == -1L) {
                throw new EOFException();
            }
            long toSkip = Math.min(byteCount, this.buffer.size());
            this.buffer.skip(toSkip);
            byteCount -= toSkip;
        }
    }

    @Override
    public long seek(byte b) throws IOException {
        long index2;
        this.checkNotClosed();
        long start = 0L;
        while ((index2 = this.buffer.indexOf(b, start)) == -1L) {
            start = this.buffer.size;
            if (this.source.read(this.buffer, 2048L) != -1L) continue;
            throw new EOFException();
        }
        return index2;
    }

    @Override
    public InputStream inputStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                long count2;
                this.checkNotClosed();
                if (RealBufferedSource.this.buffer.size == 0L && (count2 = RealBufferedSource.this.source.read(RealBufferedSource.this.buffer, 2048L)) == -1L) {
                    return -1;
                }
                return RealBufferedSource.this.buffer.readByte() & 0xFF;
            }

            @Override
            public int read(byte[] data2, int offset, int byteCount) throws IOException {
                long count2;
                this.checkNotClosed();
                Util.checkOffsetAndCount(data2.length, offset, byteCount);
                if (RealBufferedSource.this.buffer.size == 0L && (count2 = RealBufferedSource.this.source.read(RealBufferedSource.this.buffer, 2048L)) == -1L) {
                    return -1;
                }
                return RealBufferedSource.this.buffer.read(data2, offset, byteCount);
            }

            @Override
            public int available() throws IOException {
                this.checkNotClosed();
                return (int)Math.min(RealBufferedSource.this.buffer.size, Integer.MAX_VALUE);
            }

            @Override
            public void close() throws IOException {
                RealBufferedSource.this.close();
            }

            public String toString() {
                return RealBufferedSource.this + ".inputStream()";
            }

            private void checkNotClosed() throws IOException {
                if (RealBufferedSource.this.closed) {
                    throw new IOException("closed");
                }
            }
        };
    }

    @Override
    public Source deadline(Deadline deadline) {
        this.source.deadline(deadline);
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.source.close();
        this.buffer.clear();
    }

    public String toString() {
        return "buffer(" + this.source + ")";
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
    }
}

