/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.spdy;

import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.okio.BufferedSink;
import com.squareup.okhttp.internal.okio.BufferedSource;
import com.squareup.okhttp.internal.okio.ByteString;
import com.squareup.okhttp.internal.okio.Deadline;
import com.squareup.okhttp.internal.okio.OkBuffer;
import com.squareup.okhttp.internal.okio.Source;
import com.squareup.okhttp.internal.spdy.ErrorCode;
import com.squareup.okhttp.internal.spdy.FrameReader;
import com.squareup.okhttp.internal.spdy.FrameWriter;
import com.squareup.okhttp.internal.spdy.Header;
import com.squareup.okhttp.internal.spdy.HeadersMode;
import com.squareup.okhttp.internal.spdy.HpackDraft05;
import com.squareup.okhttp.internal.spdy.Settings;
import com.squareup.okhttp.internal.spdy.Variant;
import java.io.IOException;
import java.util.List;

public final class Http20Draft09
implements Variant {
    private static final ByteString CONNECTION_HEADER = ByteString.encodeUtf8("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n");
    static final byte TYPE_DATA = 0;
    static final byte TYPE_HEADERS = 1;
    static final byte TYPE_PRIORITY = 2;
    static final byte TYPE_RST_STREAM = 3;
    static final byte TYPE_SETTINGS = 4;
    static final byte TYPE_PUSH_PROMISE = 5;
    static final byte TYPE_PING = 6;
    static final byte TYPE_GOAWAY = 7;
    static final byte TYPE_WINDOW_UPDATE = 9;
    static final byte TYPE_CONTINUATION = 10;
    static final byte FLAG_NONE = 0;
    static final byte FLAG_ACK = 1;
    static final byte FLAG_END_STREAM = 1;
    static final byte FLAG_END_HEADERS = 4;
    static final byte FLAG_END_PUSH_PROMISE = 4;
    static final byte FLAG_PRIORITY = 8;

    @Override
    public Protocol getProtocol() {
        return Protocol.HTTP_2;
    }

    @Override
    public FrameReader newReader(BufferedSource source, boolean client) {
        return new Reader(source, 4096, client);
    }

    @Override
    public FrameWriter newWriter(BufferedSink sink, boolean client) {
        return new Writer(sink, client);
    }

    @Override
    public int maxFrameSize() {
        return 16383;
    }

    private static IllegalArgumentException illegalArgument(String message, Object ... args) {
        throw new IllegalArgumentException(String.format(message, args));
    }

    private static IOException ioException(String message, Object ... args) throws IOException {
        throw new IOException(String.format(message, args));
    }

    static final class ContinuationSource
    implements Source {
        private final BufferedSource source;
        int length;
        byte flags;
        int streamId;
        int left;

        public ContinuationSource(BufferedSource source) {
            this.source = source;
        }

        @Override
        public long read(OkBuffer sink, long byteCount) throws IOException {
            while (this.left == 0) {
                if ((this.flags & 4) != 0) {
                    return -1L;
                }
                this.readContinuationHeader();
            }
            long read2 = this.source.read(sink, Math.min(byteCount, (long)this.left));
            if (read2 == -1L) {
                return -1L;
            }
            this.left = (int)((long)this.left - read2);
            return read2;
        }

        @Override
        public Source deadline(Deadline deadline) {
            this.source.deadline(deadline);
            return this;
        }

        @Override
        public void close() throws IOException {
        }

        private void readContinuationHeader() throws IOException {
            int previousStreamId = this.streamId;
            int w1 = this.source.readInt();
            int w2 = this.source.readInt();
            short s2 = (short)((w1 & 0x3FFF0000) >> 16);
            this.left = s2;
            this.length = s2;
            byte type = (byte)((w1 & 0xFF00) >> 8);
            this.flags = (byte)(w1 & 0xFF);
            this.streamId = w2 & Integer.MAX_VALUE;
            if (type != 10) {
                throw Http20Draft09.ioException("%s != TYPE_CONTINUATION", new Object[]{type});
            }
            if (this.streamId != previousStreamId) {
                throw Http20Draft09.ioException("TYPE_CONTINUATION streamId changed", new Object[0]);
            }
        }
    }

    static final class Writer
    implements FrameWriter {
        private final BufferedSink sink;
        private final boolean client;
        private final OkBuffer hpackBuffer;
        private final HpackDraft05.Writer hpackWriter;
        private boolean closed;

        Writer(BufferedSink sink, boolean client) {
            this.sink = sink;
            this.client = client;
            this.hpackBuffer = new OkBuffer();
            this.hpackWriter = new HpackDraft05.Writer(this.hpackBuffer);
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            this.sink.flush();
        }

        @Override
        public synchronized void ackSettings() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            int length = 0;
            byte type = 4;
            byte flags = 1;
            int streamId = 0;
            this.frameHeader(length, type, flags, streamId);
            this.sink.flush();
        }

        @Override
        public synchronized void connectionHeader() throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (!this.client) {
                return;
            }
            this.sink.write(CONNECTION_HEADER.toByteArray());
            this.sink.flush();
        }

        @Override
        public synchronized void synStream(boolean outFinished, boolean inFinished, int streamId, int associatedStreamId, int priority, int slot, List<Header> headerBlock) throws IOException {
            if (inFinished) {
                throw new UnsupportedOperationException();
            }
            if (this.closed) {
                throw new IOException("closed");
            }
            this.headers(outFinished, streamId, priority, headerBlock);
        }

        @Override
        public synchronized void synReply(boolean outFinished, int streamId, List<Header> headerBlock) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            this.headers(outFinished, streamId, -1, headerBlock);
        }

        @Override
        public synchronized void headers(int streamId, List<Header> headerBlock) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            this.headers(false, streamId, -1, headerBlock);
        }

        @Override
        public synchronized void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (this.hpackBuffer.size() != 0L) {
                throw new IllegalStateException();
            }
            this.hpackWriter.writeHeaders(requestHeaders);
            int length = (int)(4L + this.hpackBuffer.size());
            byte type = 5;
            byte flags = 4;
            this.frameHeader(length, type, flags, streamId);
            this.sink.writeInt(promisedStreamId & Integer.MAX_VALUE);
            this.sink.write(this.hpackBuffer, this.hpackBuffer.size());
        }

        private void headers(boolean outFinished, int streamId, int priority, List<Header> headerBlock) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (this.hpackBuffer.size() != 0L) {
                throw new IllegalStateException();
            }
            this.hpackWriter.writeHeaders(headerBlock);
            int length = (int)this.hpackBuffer.size();
            byte type = 1;
            byte flags = 4;
            if (outFinished) {
                flags = (byte)(flags | 1);
            }
            if (priority != -1) {
                flags = (byte)(flags | 8);
            }
            if (priority != -1) {
                length += 4;
            }
            this.frameHeader(length, type, flags, streamId);
            if (priority != -1) {
                this.sink.writeInt(priority & Integer.MAX_VALUE);
            }
            this.sink.write(this.hpackBuffer, this.hpackBuffer.size());
        }

        @Override
        public synchronized void rstStream(int streamId, ErrorCode errorCode) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (errorCode.spdyRstCode == -1) {
                throw new IllegalArgumentException();
            }
            int length = 4;
            byte type = 3;
            byte flags = 0;
            this.frameHeader(length, type, flags, streamId);
            this.sink.writeInt(errorCode.httpCode);
            this.sink.flush();
        }

        @Override
        public synchronized void data(boolean outFinished, int streamId, OkBuffer source) throws IOException {
            this.data(outFinished, streamId, source, (int)source.size());
        }

        @Override
        public synchronized void data(boolean outFinished, int streamId, OkBuffer source, int byteCount) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            byte flags = 0;
            if (outFinished) {
                flags = (byte)(flags | 1);
            }
            this.dataFrame(streamId, flags, source, byteCount);
        }

        void dataFrame(int streamId, byte flags, OkBuffer buffer, int byteCount) throws IOException {
            byte type = 0;
            this.frameHeader(byteCount, type, flags, streamId);
            if (byteCount > 0) {
                this.sink.write(buffer, byteCount);
            }
        }

        @Override
        public synchronized void settings(Settings settings) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            int length = settings.size() * 8;
            byte type = 4;
            byte flags = 0;
            int streamId = 0;
            this.frameHeader(length, type, flags, streamId);
            for (int i = 0; i < 10; ++i) {
                if (!settings.isSet(i)) continue;
                this.sink.writeInt(i & 0xFFFFFF);
                this.sink.writeInt(settings.get(i));
            }
            this.sink.flush();
        }

        @Override
        public synchronized void ping(boolean ack, int payload1, int payload2) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            int length = 8;
            byte type = 6;
            byte flags = ack ? (byte)1 : 0;
            int streamId = 0;
            this.frameHeader(length, type, flags, streamId);
            this.sink.writeInt(payload1);
            this.sink.writeInt(payload2);
            this.sink.flush();
        }

        @Override
        public synchronized void goAway(int lastGoodStreamId, ErrorCode errorCode, byte[] debugData) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (errorCode.httpCode == -1) {
                throw Http20Draft09.illegalArgument("errorCode.httpCode == -1", new Object[0]);
            }
            int length = 8 + debugData.length;
            byte type = 7;
            byte flags = 0;
            int streamId = 0;
            this.frameHeader(length, type, flags, streamId);
            this.sink.writeInt(lastGoodStreamId);
            this.sink.writeInt(errorCode.httpCode);
            if (debugData.length > 0) {
                this.sink.write(debugData);
            }
            this.sink.flush();
        }

        @Override
        public synchronized void windowUpdate(int streamId, long windowSizeIncrement) throws IOException {
            if (this.closed) {
                throw new IOException("closed");
            }
            if (windowSizeIncrement == 0L || windowSizeIncrement > Integer.MAX_VALUE) {
                throw Http20Draft09.illegalArgument("windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: %s", new Object[]{windowSizeIncrement});
            }
            int length = 4;
            byte type = 9;
            byte flags = 0;
            this.frameHeader(length, type, flags, streamId);
            this.sink.writeInt((int)windowSizeIncrement);
            this.sink.flush();
        }

        @Override
        public synchronized void close() throws IOException {
            this.closed = true;
            this.sink.close();
        }

        void frameHeader(int length, byte type, byte flags, int streamId) throws IOException {
            if (length > 16383) {
                throw Http20Draft09.illegalArgument("FRAME_SIZE_ERROR length > 16383: %s", new Object[]{length});
            }
            if ((streamId & Integer.MIN_VALUE) != 0) {
                throw Http20Draft09.illegalArgument("reserved bit set: %s", new Object[]{streamId});
            }
            this.sink.writeInt((length & 0x3FFF) << 16 | (type & 0xFF) << 8 | flags & 0xFF);
            this.sink.writeInt(streamId & Integer.MAX_VALUE);
        }
    }

    static final class Reader
    implements FrameReader {
        private final BufferedSource source;
        private final ContinuationSource continuation;
        private final boolean client;
        final HpackDraft05.Reader hpackReader;

        Reader(BufferedSource source, int headerTableSize, boolean client) {
            this.source = source;
            this.client = client;
            this.continuation = new ContinuationSource(this.source);
            this.hpackReader = new HpackDraft05.Reader(client, headerTableSize, this.continuation);
        }

        @Override
        public void readConnectionHeader() throws IOException {
            if (this.client) {
                return;
            }
            ByteString connectionHeader = this.source.readByteString(CONNECTION_HEADER.size());
            if (!CONNECTION_HEADER.equals(connectionHeader)) {
                throw Http20Draft09.ioException("Expected a connection header but was %s", new Object[]{connectionHeader.utf8()});
            }
        }

        @Override
        public boolean nextFrame(FrameReader.Handler handler) throws IOException {
            int w2;
            int w1;
            try {
                w1 = this.source.readInt();
                w2 = this.source.readInt();
            }
            catch (IOException e) {
                return false;
            }
            short length = (short)((w1 & 0x3FFF0000) >> 16);
            byte type = (byte)((w1 & 0xFF00) >> 8);
            byte flags = (byte)(w1 & 0xFF);
            int streamId = w2 & Integer.MAX_VALUE;
            switch (type) {
                case 0: {
                    this.readData(handler, length, flags, streamId);
                    break;
                }
                case 1: {
                    this.readHeaders(handler, length, flags, streamId);
                    break;
                }
                case 2: {
                    this.readPriority(handler, length, flags, streamId);
                    break;
                }
                case 3: {
                    this.readRstStream(handler, length, flags, streamId);
                    break;
                }
                case 4: {
                    this.readSettings(handler, length, flags, streamId);
                    break;
                }
                case 5: {
                    this.readPushPromise(handler, length, flags, streamId);
                    break;
                }
                case 6: {
                    this.readPing(handler, length, flags, streamId);
                    break;
                }
                case 7: {
                    this.readGoAway(handler, length, flags, streamId);
                    break;
                }
                case 9: {
                    this.readWindowUpdate(handler, length, flags, streamId);
                    break;
                }
                default: {
                    this.source.skip(length);
                }
            }
            return true;
        }

        private void readHeaders(FrameReader.Handler handler, short length, byte flags, int streamId) throws IOException {
            if (streamId == 0) {
                throw Http20Draft09.ioException("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0", new Object[0]);
            }
            boolean endStream = (flags & 1) != 0;
            int priority = -1;
            if ((flags & 8) != 0) {
                priority = this.source.readInt() & Integer.MAX_VALUE;
                length = (short)(length - 4);
            }
            List<Header> headerBlock = this.readHeaderBlock(length, flags, streamId);
            handler.headers(false, endStream, streamId, -1, priority, headerBlock, HeadersMode.HTTP_20_HEADERS);
        }

        private List<Header> readHeaderBlock(short length, byte flags, int streamId) throws IOException {
            short s2 = length;
            this.continuation.left = s2;
            this.continuation.length = s2;
            this.continuation.flags = flags;
            this.continuation.streamId = streamId;
            this.hpackReader.readHeaders();
            this.hpackReader.emitReferenceSet();
            return this.hpackReader.getAndReset();
        }

        private void readData(FrameReader.Handler handler, short length, byte flags, int streamId) throws IOException {
            boolean inFinished = (flags & 1) != 0;
            handler.data(inFinished, streamId, this.source, length);
        }

        private void readPriority(FrameReader.Handler handler, short length, byte flags, int streamId) throws IOException {
            if (length != 4) {
                throw Http20Draft09.ioException("TYPE_PRIORITY length: %d != 4", new Object[]{length});
            }
            if (streamId == 0) {
                throw Http20Draft09.ioException("TYPE_PRIORITY streamId == 0", new Object[0]);
            }
            int w1 = this.source.readInt();
            int priority = w1 & Integer.MAX_VALUE;
            handler.priority(streamId, priority);
        }

        private void readRstStream(FrameReader.Handler handler, short length, byte flags, int streamId) throws IOException {
            if (length != 4) {
                throw Http20Draft09.ioException("TYPE_RST_STREAM length: %d != 4", new Object[]{length});
            }
            if (streamId == 0) {
                throw Http20Draft09.ioException("TYPE_RST_STREAM streamId == 0", new Object[0]);
            }
            int errorCodeInt = this.source.readInt();
            ErrorCode errorCode = ErrorCode.fromHttp2(errorCodeInt);
            if (errorCode == null) {
                throw Http20Draft09.ioException("TYPE_RST_STREAM unexpected error code: %d", new Object[]{errorCodeInt});
            }
            handler.rstStream(streamId, errorCode);
        }

        private void readSettings(FrameReader.Handler handler, short length, byte flags, int streamId) throws IOException {
            if (streamId != 0) {
                throw Http20Draft09.ioException("TYPE_SETTINGS streamId != 0", new Object[0]);
            }
            if ((flags & 1) != 0) {
                if (length != 0) {
                    throw Http20Draft09.ioException("FRAME_SIZE_ERROR ack frame should be empty!", new Object[0]);
                }
                handler.ackSettings();
                return;
            }
            if (length % 8 != 0) {
                throw Http20Draft09.ioException("TYPE_SETTINGS length %% 8 != 0: %s", new Object[]{(short)length});
            }
            Settings settings = new Settings();
            for (int i = 0; i < length; i += 8) {
                int w1 = this.source.readInt();
                int value2 = this.source.readInt();
                int id = w1 & 0xFFFFFF;
                settings.set(id, 0, value2);
            }
            handler.settings(false, settings);
            if (settings.getHeaderTableSize() >= 0) {
                this.hpackReader.maxHeaderTableByteCount(settings.getHeaderTableSize());
            }
        }

        private void readPushPromise(FrameReader.Handler handler, short length, byte flags, int streamId) throws IOException {
            if (streamId == 0) {
                throw Http20Draft09.ioException("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0", new Object[0]);
            }
            int promisedStreamId = this.source.readInt() & Integer.MAX_VALUE;
            length = (short)(length - 4);
            List<Header> headerBlock = this.readHeaderBlock(length, flags, streamId);
            handler.pushPromise(streamId, promisedStreamId, headerBlock);
        }

        private void readPing(FrameReader.Handler handler, short length, byte flags, int streamId) throws IOException {
            if (length != 8) {
                throw Http20Draft09.ioException("TYPE_PING length != 8: %s", new Object[]{length});
            }
            if (streamId != 0) {
                throw Http20Draft09.ioException("TYPE_PING streamId != 0", new Object[0]);
            }
            int payload1 = this.source.readInt();
            int payload2 = this.source.readInt();
            boolean ack = (flags & 1) != 0;
            handler.ping(ack, payload1, payload2);
        }

        private void readGoAway(FrameReader.Handler handler, short length, byte flags, int streamId) throws IOException {
            if (length < 8) {
                throw Http20Draft09.ioException("TYPE_GOAWAY length < 8: %s", new Object[]{length});
            }
            if (streamId != 0) {
                throw Http20Draft09.ioException("TYPE_GOAWAY streamId != 0", new Object[0]);
            }
            int lastStreamId = this.source.readInt();
            int errorCodeInt = this.source.readInt();
            int opaqueDataLength = length - 8;
            ErrorCode errorCode = ErrorCode.fromHttp2(errorCodeInt);
            if (errorCode == null) {
                throw Http20Draft09.ioException("TYPE_GOAWAY unexpected error code: %d", new Object[]{errorCodeInt});
            }
            ByteString debugData = ByteString.EMPTY;
            if (opaqueDataLength > 0) {
                debugData = this.source.readByteString(opaqueDataLength);
            }
            handler.goAway(lastStreamId, errorCode, debugData);
        }

        private void readWindowUpdate(FrameReader.Handler handler, short length, byte flags, int streamId) throws IOException {
            if (length != 4) {
                throw Http20Draft09.ioException("TYPE_WINDOW_UPDATE length !=4: %s", new Object[]{length});
            }
            long increment = this.source.readInt() & Integer.MAX_VALUE;
            if (increment == 0L) {
                throw Http20Draft09.ioException("windowSizeIncrement was 0", new Object[]{increment});
            }
            handler.windowUpdate(streamId, increment);
        }

        @Override
        public void close() throws IOException {
            this.source.close();
        }
    }
}

