/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import kafka.api.FetchRequest$;
import kafka.api.RequestKeys$;
import kafka.network.Request;
import kafka.utils.Utils$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011<Q!\u0001\u0002\t\u0006\u001d\tABR3uG\"\u0014V-];fgRT!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1\u0001B\u0003\u0002\u0005\u0002\u0003E)a\u0003\u0002\r\r\u0016$8\r\u001b*fcV,7\u000f^\n\u0004\u00131!\u0002CA\u0007\u0013\u001b\u0005q!BA\b\u0011\u0003\u0011a\u0017M\\4\u000b\u0003E\tAA[1wC&\u00111C\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u00067%!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001dAQAH\u0005\u0005\u0002}\t\u0001B]3bI\u001a\u0013x.\u001c\u000b\u0003A\r\u0004\"\u0001C\u0011\u0007\u0011)\u0011A\u0011!A\u0001\u0002\t\u001a2!I\u0012\u0015!\t!s%D\u0001&\u0015\t1C!A\u0004oKR<xN]6\n\u0005!*#a\u0002*fcV,7\u000f\u001e\u0005\tU\u0005\u0012)\u0019!C\u0001W\u0005)Ao\u001c9jGV\tA\u0006\u0005\u0002.a9\u0011QCL\u0005\u0003_Y\ta\u0001\u0015:fI\u00164\u0017BA\u00193\u0005\u0019\u0019FO]5oO*\u0011qF\u0006\u0005\ti\u0005\u0012\t\u0011)A\u0005Y\u00051Ao\u001c9jG\u0002B\u0001BN\u0011\u0003\u0006\u0004%\taN\u0001\na\u0006\u0014H/\u001b;j_:,\u0012\u0001\u000f\t\u0003+eJ!A\u000f\f\u0003\u0007%sG\u000f\u0003\u0005=C\t\u0005\t\u0015!\u00039\u0003)\u0001\u0018M\u001d;ji&|g\u000e\t\u0005\t}\u0005\u0012)\u0019!C\u0001\u007f\u00051qN\u001a4tKR,\u0012\u0001\u0011\t\u0003+\u0005K!A\u0011\f\u0003\t1{gn\u001a\u0005\t\t\u0006\u0012\t\u0011)A\u0005\u0001\u00069qN\u001a4tKR\u0004\u0003\u0002\u0003$\"\u0005\u000b\u0007I\u0011A\u001c\u0002\u000f5\f\u0007pU5{K\"A\u0001*\tB\u0001B\u0003%\u0001(\u0001\u0005nCb\u001c\u0016N_3!\u0011\u0015Y\u0012\u0005\"\u0001K)\u0015\u00013\nT'O\u0011\u0015Q\u0013\n1\u0001-\u0011\u00151\u0014\n1\u00019\u0011\u0015q\u0014\n1\u0001A\u0011\u00151\u0015\n1\u00019\u0011\u0015\u0001\u0016\u0005\"\u0001R\u0003\u001d9(/\u001b;f)>$\"AU+\u0011\u0005U\u0019\u0016B\u0001+\u0017\u0005\u0011)f.\u001b;\t\u000bY{\u0005\u0019A,\u0002\r\t,hMZ3s!\tA6,D\u0001Z\u0015\tQ\u0006#A\u0002oS>L!\u0001X-\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0003_C\u0011\u0005q,A\u0006tSj,\u0017J\u001c\"zi\u0016\u001cH#\u0001\u001d\t\u000b\u0005\fC\u0011\t2\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001\f\u0005\u0006-v\u0001\ra\u0016")
public class FetchRequest
extends Request
implements ScalaObject {
    private final String topic;
    private final int partition;
    private final long offset;
    private final int maxSize;

    public static final FetchRequest readFrom(ByteBuffer byteBuffer) {
        return FetchRequest$.MODULE$.readFrom(byteBuffer);
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public long offset() {
        return this.offset;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public void writeTo(ByteBuffer buffer) {
        Utils$.MODULE$.writeShortString(buffer, this.topic(), "UTF-8");
        buffer.putInt(this.partition());
        buffer.putLong(this.offset());
        buffer.putInt(this.maxSize());
    }

    public int sizeInBytes() {
        return 2 + this.topic().length() + 4 + 8 + 4;
    }

    public String toString() {
        return new StringBuilder().append((Object)"FetchRequest(topic:").append((Object)this.topic()).append((Object)", part:").append(BoxesRunTime.boxToInteger(this.partition())).append((Object)" offset:").append(BoxesRunTime.boxToLong(this.offset())).append((Object)" maxSize:").append(BoxesRunTime.boxToInteger(this.maxSize())).append((Object)")").toString();
    }

    public FetchRequest(String topic, int partition2, long offset, int maxSize) {
        this.topic = topic;
        this.partition = partition2;
        this.offset = offset;
        this.maxSize = maxSize;
        super(RequestKeys$.MODULE$.Fetch());
    }
}

