/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.util.Properties;
import java.util.Random;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.Blacklist;
import kafka.consumer.ConsoleConsumer;
import kafka.consumer.ConsoleConsumer$;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.KafkaStream;
import kafka.consumer.TopicFilter;
import kafka.consumer.Whitelist;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConsoleConsumer$
implements Logging,
ScalaObject {
    public static final ConsoleConsumer$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ConsoleConsumer$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ConsoleConsumer$ consoleConsumer$ = this;
        synchronized (consoleConsumer$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> topicIdOpt = parser.accepts("topic", "The topic id to consume on.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> whitelistOpt = parser.accepts("whitelist", "Whitelist of topics to include for consumption.").withRequiredArg().describedAs("whitelist").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> blacklistOpt = parser.accepts("blacklist", "Blacklist of topics to exclude from consumption.").withRequiredArg().describedAs("blacklist").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> zkConnectOpt$1 = parser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> groupIdOpt$1 = parser.accepts("group", "The group id to consume on.").withRequiredArg().describedAs("gid").defaultsTo(new StringBuilder().append((Object)"console-consumer-").append(BoxesRunTime.boxToInteger(new Random().nextInt(100000))).toString(), (String[])((Object[])new String[0])).ofType(String.class);
        ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt = parser.accepts("fetch-size", "The amount of data to fetch in a single request.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0x100000), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = parser.accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0x200000), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> consumerTimeoutMsOpt = parser.accepts("consumer-timeout-ms", "consumer throws timeout exception after waiting this much of time without incoming messages").withRequiredArg().describedAs("prop").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(-1), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<String> messageFormatterOpt = parser.accepts("formatter", "The name of a class to use for formatting kafka messages for display.").withRequiredArg().describedAs("class").ofType(String.class).defaultsTo(ConsoleConsumer.NewlineMessageFormatter.class.getName(), (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<String> messageFormatterArgOpt = parser.accepts("property").withRequiredArg().describedAs("prop").ofType(String.class);
        OptionSpecBuilder resetBeginningOpt = parser.accepts("from-beginning", "If the consumer does not already have an established offset to consume from, start with the earliest message present in the log rather than the latest message.");
        ArgumentAcceptingOptionSpec<Integer> autoCommitIntervalOpt = parser.accepts("autocommit.interval.ms", "The time interval at which to save the current offset in ms").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(10000), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> maxMessagesOpt = parser.accepts("max-messages", "The maximum number of messages to consume before exiting. If not set, consumption is continual.").withRequiredArg().describedAs("num_messages").ofType(Integer.class);
        OptionSpecBuilder skipMessageOnErrorOpt = parser.accepts("skip-message-on-error", "If there is an error when processing a message, skip it instead of halt.");
        OptionSet options$1 = this.tryParse(parser, args);
        Utils$.MODULE$.checkRequiredArgs(parser, options$1, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{zkConnectOpt$1}));
        List topicOrFilterOpt = (List)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{topicIdOpt, whitelistOpt, blacklistOpt})).filter(new anonfun.1(options$1));
        if (topicOrFilterOpt.size() != 1) {
            this.error((Function0<String>)new anonfun.main.1());
            parser.printHelpOn(System.err);
            System.exit(1);
        }
        String topicArg = (String)options$1.valueOf((OptionSpec)topicOrFilterOpt.head());
        TopicFilter filterSpec = options$1.has(blacklistOpt) ? new Blacklist(topicArg) : new Whitelist(topicArg);
        Properties props = new Properties();
        props.put("groupid", options$1.valueOf(groupIdOpt$1));
        props.put("socket.buffersize", options$1.valueOf(socketBufferSizeOpt).toString());
        props.put("fetch.size", options$1.valueOf(fetchSizeOpt).toString());
        props.put("auto.commit", "true");
        props.put("autocommit.interval.ms", options$1.valueOf(autoCommitIntervalOpt).toString());
        props.put("autooffset.reset", options$1.has(resetBeginningOpt) ? "smallest" : "largest");
        props.put("zk.connect", options$1.valueOf(zkConnectOpt$1));
        props.put("consumer.timeout.ms", options$1.valueOf(consumerTimeoutMsOpt).toString());
        ConsumerConfig config = new ConsumerConfig(props);
        boolean skipMessageOnError$1 = options$1.has(skipMessageOnErrorOpt);
        Class<?> messageFormatterClass = Class.forName(options$1.valueOf(messageFormatterOpt));
        Properties formatterArgs = this.tryParseFormatterArgs(JavaConversions$.MODULE$.asBuffer(options$1.valuesOf(messageFormatterArgOpt)));
        int maxMessages = options$1.has(maxMessagesOpt) ? options$1.valueOf(maxMessagesOpt) : -1;
        ConsumerConnector connector$1 = Consumer$.MODULE$.create(config);
        if (options$1.has(resetBeginningOpt)) {
            this.tryCleanupZookeeper(options$1.valueOf(zkConnectOpt$1), options$1.valueOf(groupIdOpt$1));
        }
        Runtime.getRuntime().addShutdownHook(new anon.1(zkConnectOpt$1, groupIdOpt$1, options$1, connector$1));
        KafkaStream stream = (KafkaStream)JavaConversions$.MODULE$.asList(connector$1.createMessageStreamsByFilter(filterSpec, connector$1.createMessageStreamsByFilter$default$2(), connector$1.createMessageStreamsByFilter$default$3())).get(0);
        KafkaStream iter2 = maxMessages >= 0 ? (Iterable)stream.slice(0, maxMessages) : stream;
        ConsoleConsumer.MessageFormatter formatter$1 = (ConsoleConsumer.MessageFormatter)messageFormatterClass.newInstance();
        formatter$1.init(formatterArgs);
        try {
            iter2.foreach(new anonfun.main.2(skipMessageOnError$1, connector$1, formatter$1));
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new anonfun.main.3(), (Function0<Throwable>)new anonfun.main.4(throwable));
        }
        System.out.flush();
        formatter$1.close();
        connector$1.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    public OptionSet tryParse(OptionParser parser, String[] args) {
        void var3_3;
        OptionSet exceptionResult1 = null;
        try {
            exceptionResult1 = parser.parse(args);
        }
        catch (OptionException optionException) {
            Utils$.MODULE$.croak(optionException.getMessage());
            exceptionResult1 = null;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties tryParseFormatterArgs(scala.collection.mutable.Iterable<String> args) {
        void var3_3;
        scala.collection.mutable.Iterable splits = (scala.collection.mutable.Iterable)((TraversableLike)((TraversableLike)args.map(new anonfun.2(), Iterable$.MODULE$.canBuildFrom())).filterNot(new anonfun.3())).filterNot(new anonfun.4());
        if (!splits.forall(new anonfun.tryParseFormatterArgs.1())) {
            System.err.println(new StringBuilder().append((Object)"Invalid parser arguments: ").append((Object)args.mkString(" ")).toString());
            System.exit(1);
        }
        Properties props$1 = new Properties();
        splits.foreach(new anonfun.tryParseFormatterArgs.2(props$1));
        return var3_3;
    }

    public void tryCleanupZookeeper(String zkUrl, String groupId) {
        try {
            String dir$1 = new StringBuilder().append((Object)"/consumers/").append((Object)groupId).toString();
            this.info((Function0<String>)new anonfun.tryCleanupZookeeper.1(dir$1));
            ZkClient zk = new ZkClient(zkUrl, 30000, 30000, ZKStringSerializer$.MODULE$);
            zk.deleteRecursive(dir$1);
            zk.close();
        }
        catch (Throwable throwable) {}
    }

    private ConsoleConsumer$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

