/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.consumer.ConsumerIterator$;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.ConsumerTopicStat$;
import kafka.consumer.FetchedDataChunk;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.ZookeeperConsumerConnector$;
import kafka.message.MessageAndMetadata;
import kafka.message.MessageAndOffset;
import kafka.serializer.Decoder;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001\u001d\u0011\u0001cQ8ogVlWM]%uKJ\fGo\u001c:\u000b\u0005\r!\u0011\u0001C2p]N,X.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!\u0006\u0002\t/M!\u0001!C\u0012'!\rQQbD\u0007\u0002\u0017)\u0011A\u0002B\u0001\u0006kRLGn]\u0005\u0003\u001d-\u0011\u0001#\u0013;fe\u0006$xN\u001d+f[Bd\u0017\r^3\u0011\u0007A\u0019R#D\u0001\u0012\u0015\t\u0011B!A\u0004nKN\u001c\u0018mZ3\n\u0005Q\t\"AE'fgN\fw-Z!oI6+G/\u00193bi\u0006\u0004\"AF\f\r\u0001\u0011A\u0001\u0004\u0001C\u0001\u0002\u000b\u0007\u0011DA\u0001U#\tQ\u0002\u0005\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBDA\u0004O_RD\u0017N\\4\u0011\u0005m\t\u0013B\u0001\u0012\u001d\u0005\r\te.\u001f\t\u0003\u0015\u0011J!!J\u0006\u0003\u000f1{wmZ5oOB\u00111dJ\u0005\u0003Qq\u00111bU2bY\u0006|%M[3di\"A!\u0006\u0001BC\u0002\u0013%1&A\u0004dQ\u0006tg.\u001a7\u0016\u00031\u00022!\f\u001b7\u001b\u0005q#BA\u00181\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003cI\nA!\u001e;jY*\t1'\u0001\u0003kCZ\f\u0017BA\u001b/\u00055\u0011En\\2lS:<\u0017+^3vKB\u0011q\u0007O\u0007\u0002\u0005%\u0011\u0011H\u0001\u0002\u0011\r\u0016$8\r[3e\t\u0006$\u0018m\u00115v].D\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\tG\"\fgN\\3mA!AQ\b\u0001B\u0001B\u0003%a(A\td_:\u001cX/\\3s)&lWm\\;u\u001bN\u0004\"aG \n\u0005\u0001c\"aA%oi\"A!\t\u0001BC\u0002\u0013%1)A\u0004eK\u000e|G-\u001a:\u0016\u0003\u0011\u00032!\u0012%\u0016\u001b\u00051%BA$\u0005\u0003)\u0019XM]5bY&TXM]\u0005\u0003\u0013\u001a\u0013q\u0001R3d_\u0012,'\u000f\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003E\u0003!!WmY8eKJ\u0004\u0003\u0002C'\u0001\u0005\u000b\u0007I\u0011\u0001(\u0002+\u0015t\u0017M\u00197f'\"\fG\u000e\\8x\u0013R,'/\u0019;peV\tq\n\u0005\u0002\u001c!&\u0011\u0011\u000b\b\u0002\b\u0005>|G.Z1o\u0011!\u0019\u0006A!A!\u0002\u0013y\u0015AF3oC\ndWm\u00155bY2|w/\u0013;fe\u0006$xN\u001d\u0011\t\u000bU\u0003A\u0011\u0001,\u0002\rqJg.\u001b;?)\u00159\u0006,\u0017.\\!\r9\u0004!\u0006\u0005\u0006UQ\u0003\r\u0001\f\u0005\u0006{Q\u0003\rA\u0010\u0005\u0006\u0005R\u0003\r\u0001\u0012\u0005\u0006\u001bR\u0003\ra\u0014\u0005\b;\u0002\u0001\r\u0011\"\u0003_\u0003\u001d\u0019WO\u001d:f]R,\u0012a\u0018\t\u0004A\u000e,W\"A1\u000b\u0005\tt\u0013AB1u_6L7-\u0003\u0002eC\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\rE\u0002g]Ft!a\u001a7\u000f\u0005!\\W\"A5\u000b\u0005)4\u0011A\u0002\u001fs_>$h(C\u0001\u001e\u0013\tiG$A\u0004qC\u000e\\\u0017mZ3\n\u0005=\u0004(\u0001C%uKJ\fGo\u001c:\u000b\u00055d\u0002C\u0001\ts\u0013\t\u0019\u0018C\u0001\tNKN\u001c\u0018mZ3B]\u0012|eMZ:fi\"9Q\u000f\u0001a\u0001\n\u00131\u0018aC2veJ,g\u000e^0%KF$\"a\u001e>\u0011\u0005mA\u0018BA=\u001d\u0005\u0011)f.\u001b;\t\u000fm$\u0018\u0011!a\u0001?\u0006\u0019\u0001\u0010J\u0019\t\ru\u0004\u0001\u0015)\u0003`\u0003!\u0019WO\u001d:f]R\u0004\u0003\u0002C@\u0001\u0001\u0004%I!!\u0001\u0002!\r,(O]3oiR{\u0007/[2J]\u001a|WCAA\u0002!\r9\u0014QA\u0005\u0004\u0003\u000f\u0011!A\u0005)beRLG/[8o)>\u0004\u0018nY%oM>D\u0011\"a\u0003\u0001\u0001\u0004%I!!\u0004\u0002)\r,(O]3oiR{\u0007/[2J]\u001a|w\fJ3r)\r9\u0018q\u0002\u0005\nw\u0006%\u0011\u0011!a\u0001\u0003\u0007A\u0001\"a\u0005\u0001A\u0003&\u00111A\u0001\u0012GV\u0014(/\u001a8u)>\u0004\u0018nY%oM>\u0004\u0003\"CA\f\u0001\u0001\u0007I\u0011BA\r\u00039\u0019wN\\:v[\u0016$wJ\u001a4tKR,\"!a\u0007\u0011\u0007m\ti\"C\u0002\u0002 q\u0011A\u0001T8oO\"I\u00111\u0005\u0001A\u0002\u0013%\u0011QE\u0001\u0013G>t7/^7fI>3gm]3u?\u0012*\u0017\u000fF\u0002x\u0003OA\u0011b_A\u0011\u0003\u0003\u0005\r!a\u0007\t\u0011\u0005-\u0002\u0001)Q\u0005\u00037\tqbY8ogVlW\rZ(gMN,G\u000f\t\u0005\b\u0003_\u0001A\u0011IA\u0019\u0003\u0011qW\r\u001f;\u0015\u0003=Aq!!\u000e\u0001\t#\t\t$\u0001\u0005nC.,g*\u001a=u\u0011\u001d\tI\u0004\u0001C\u0001\u0003w\t\u0011c\u00197fCJ\u001cUO\u001d:f]R\u001c\u0005.\u001e8l)\u00059\b")
public class ConsumerIterator<T>
extends IteratorTemplate<MessageAndMetadata<T>>
implements Logging,
ScalaObject {
    private final BlockingQueue<FetchedDataChunk> channel;
    private final int consumerTimeoutMs;
    private final Decoder<T> decoder;
    private final boolean enableShallowIterator;
    private AtomicReference<Iterator<MessageAndOffset>> current;
    private PartitionTopicInfo kafka$consumer$ConsumerIterator$$currentTopicInfo;
    private long kafka$consumer$ConsumerIterator$$consumedOffset;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ConsumerIterator consumerIterator = this;
        synchronized (consumerIterator) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    private BlockingQueue<FetchedDataChunk> channel() {
        return this.channel;
    }

    private Decoder<T> decoder() {
        return this.decoder;
    }

    public boolean enableShallowIterator() {
        return this.enableShallowIterator;
    }

    private AtomicReference<Iterator<MessageAndOffset>> current() {
        return this.current;
    }

    private void current_$eq(AtomicReference<Iterator<MessageAndOffset>> atomicReference) {
        this.current = atomicReference;
    }

    public final PartitionTopicInfo kafka$consumer$ConsumerIterator$$currentTopicInfo() {
        return this.kafka$consumer$ConsumerIterator$$currentTopicInfo;
    }

    private void kafka$consumer$ConsumerIterator$$currentTopicInfo_$eq(PartitionTopicInfo partitionTopicInfo) {
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo = partitionTopicInfo;
    }

    public final long kafka$consumer$ConsumerIterator$$consumedOffset() {
        return this.kafka$consumer$ConsumerIterator$$consumedOffset;
    }

    private void kafka$consumer$ConsumerIterator$$consumedOffset_$eq(long l) {
        this.kafka$consumer$ConsumerIterator$$consumedOffset = l;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MessageAndMetadata<T> next() {
        void var1_1;
        MessageAndMetadata item = (MessageAndMetadata)super.next();
        if (this.kafka$consumer$ConsumerIterator$$consumedOffset() < 0L) {
            throw new IllegalStateException(Predef$.MODULE$.augmentString("Offset returned by the message set is invalid %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.kafka$consumer$ConsumerIterator$$consumedOffset())})));
        }
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo().resetConsumeOffset(this.kafka$consumer$ConsumerIterator$$consumedOffset());
        String topic$1 = this.kafka$consumer$ConsumerIterator$$currentTopicInfo().topic();
        this.trace((Function0<String>)new $anonfun$next$1(this, topic$1));
        ConsumerTopicStat$.MODULE$.getConsumerTopicStat(topic$1).recordMessagesPerTopic(1);
        ConsumerTopicStat$.MODULE$.getConsumerAllTopicStat().recordMessagesPerTopic(1);
        return var1_1;
    }

    @Override
    public MessageAndMetadata<T> makeNext() {
        ObjectRef<Object> currentDataChunk$1 = new ObjectRef<Object>(null);
        Iterator<MessageAndOffset> localCurrent = this.current().get();
        if (localCurrent == null || !localCurrent.hasNext()) {
            if (this.consumerTimeoutMs < 0) {
                currentDataChunk$1.elem = this.channel().take();
            } else {
                currentDataChunk$1.elem = this.channel().poll(this.consumerTimeoutMs, TimeUnit.MILLISECONDS);
                if ((FetchedDataChunk)currentDataChunk$1.elem == null) {
                    this.resetState();
                    throw new ConsumerTimeoutException();
                }
            }
            if ((FetchedDataChunk)currentDataChunk$1.elem == ZookeeperConsumerConnector$.MODULE$.shutdownCommand()) {
                this.debug((Function0<String>)new $anonfun$makeNext$1(this));
                this.channel().offer((FetchedDataChunk)currentDataChunk$1.elem);
                return (MessageAndMetadata)this.allDone();
            }
            this.kafka$consumer$ConsumerIterator$$currentTopicInfo_$eq(((FetchedDataChunk)currentDataChunk$1.elem).topicInfo());
            if (this.kafka$consumer$ConsumerIterator$$currentTopicInfo().getConsumeOffset() != ((FetchedDataChunk)currentDataChunk$1.elem).fetchOffset()) {
                this.error((Function0<String>)new $anonfun$makeNext$2(this, currentDataChunk$1));
                this.kafka$consumer$ConsumerIterator$$currentTopicInfo().resetConsumeOffset(((FetchedDataChunk)currentDataChunk$1.elem).fetchOffset());
            }
            localCurrent = this.enableShallowIterator() ? ((FetchedDataChunk)currentDataChunk$1.elem).messages().shallowIterator() : ((FetchedDataChunk)currentDataChunk$1.elem).messages().iterator();
            this.current().set(localCurrent);
        }
        MessageAndOffset item = localCurrent.next();
        this.kafka$consumer$ConsumerIterator$$consumedOffset_$eq(item.offset());
        return new MessageAndMetadata<T>(this.decoder().toEvent(item.message()), this.kafka$consumer$ConsumerIterator$$currentTopicInfo().topic());
    }

    public void clearCurrentChunk() {
        this.info((Function0<String>)new $anonfun$clearCurrentChunk$1(this));
        this.current().set(null);
    }

    public ConsumerIterator(BlockingQueue<FetchedDataChunk> channel, int consumerTimeoutMs, Decoder<T> decoder2, boolean enableShallowIterator) {
        this.channel = channel;
        this.consumerTimeoutMs = consumerTimeoutMs;
        this.decoder = decoder2;
        this.enableShallowIterator = enableShallowIterator;
        Logging$class.$init$(this);
        this.current = new AtomicReference<Object>(null);
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo = null;
        this.kafka$consumer$ConsumerIterator$$consumedOffset = -1L;
    }
}

