/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer.storage;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.consumer.storage.OffsetStorage;
import scala.MatchError;
import scala.ScalaObject;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001m3\u0001\"\u0001\u0002\u0005\u0002\u0003\u0005\t!\u0003\u0002\u0014\u001b\u0016lwN]=PM\u001a\u001cX\r^*u_J\fw-\u001a\u0006\u0003\u0007\u0011\tqa\u001d;pe\u0006<WM\u0003\u0002\u0006\r\u0005A1m\u001c8tk6,'OC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0006\u0013-A\u00111\u0002E\u0007\u0002\u0019)\u0011QBD\u0001\u0005Y\u0006twMC\u0001\u0010\u0003\u0011Q\u0017M^1\n\u0005Ea!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\tiqJ\u001a4tKR\u001cFo\u001c:bO\u0016\u0004\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u00111bU2bY\u0006|%M[3di\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003'\u0001Aq!\t\u0001C\u0002\u0013\u0005!%A\u0007pM\u001a\u001cX\r^!oI2{7m[\u000b\u0002GA!A%K\u00169\u001b\u0005)#B\u0001\u0014(\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003Q9\tA!\u001e;jY&\u0011!&\n\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\b\u0003B\f-]EJ!!\f\r\u0003\rQ+\b\u000f\\33!\t9r&\u0003\u000211\t\u0019\u0011J\u001c;\u0011\u0005I*dBA\f4\u0013\t!\u0004$\u0001\u0004Qe\u0016$WMZ\u0005\u0003m]\u0012aa\u0015;sS:<'B\u0001\u001b\u0019!\u00119B&O \u0011\u0005ijT\"A\u001e\u000b\u0005q*\u0013AB1u_6L7-\u0003\u0002?w\tQ\u0011\t^8nS\u000eduN\\4\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t+\u0013!\u00027pG.\u001c\u0018B\u0001#B\u0005\u0011aunY6\t\r\u0019\u0003\u0001\u0015!\u0003$\u00039ygMZ:fi\u0006sG\rT8dW\u0002BQ\u0001\u0013\u0001\u0005\u0002%\u000bqA]3tKJ4X\rF\u0002K\u001b>\u0003\"aF&\n\u00051C\"\u0001\u0002'p]\u001eDQAT$A\u00029\nAA\\8eK\")\u0001k\u0012a\u0001c\u0005)Ao\u001c9jG\")!\u000b\u0001C\u0001'\u000611m\\7nSR$B\u0001V,Y3B\u0011q#V\u0005\u0003-b\u0011A!\u00168ji\")a*\u0015a\u0001]!)\u0001+\u0015a\u0001c!)!,\u0015a\u0001\u0015\u00061qN\u001a4tKR\u0004")
public class MemoryOffsetStorage
implements OffsetStorage,
ScalaObject {
    private final ConcurrentHashMap<Tuple2<Integer, String>, Tuple2<AtomicLong, Lock>> offsetAndLock = new ConcurrentHashMap();

    public ConcurrentHashMap<Tuple2<Integer, String>, Tuple2<AtomicLong, Lock>> offsetAndLock() {
        return this.offsetAndLock;
    }

    @Override
    public long reserve(int node, String topic) {
        Tuple2<Integer, String> key = new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(node), topic);
        Serializable serializable2 = this.offsetAndLock().containsKey(key) ? BoxedUnit.UNIT : this.offsetAndLock().putIfAbsent(key, new Tuple2<AtomicLong, ReentrantLock>(new AtomicLong(0L), new ReentrantLock()));
        Tuple2<AtomicLong, Lock> tuple2 = this.offsetAndLock().get(key);
        if (tuple2 != null) {
            Tuple2<AtomicLong, Lock> tuple22 = new Tuple2<AtomicLong, Lock>(tuple2._1(), tuple2._2());
            AtomicLong offset = tuple22._1();
            Lock lock = tuple22._2();
            lock.lock();
            return offset.get();
        }
        throw new MatchError(tuple2);
    }

    @Override
    public void commit(int node, String topic, long offset) {
        Tuple2<AtomicLong, Lock> tuple2 = this.offsetAndLock().get(new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(node), topic));
        if (tuple2 != null) {
            Tuple2<AtomicLong, Lock> tuple22 = new Tuple2<AtomicLong, Lock>(tuple2._1(), tuple2._2());
            AtomicLong highwater = tuple22._1();
            Lock lock = tuple22._2();
            highwater.set(offset);
            lock.unlock();
            return;
        }
        throw new MatchError(tuple2);
    }
}

