/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer.storage.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import kafka.consumer.storage.OffsetStorage;
import kafka.consumer.storage.sql.OracleOffsetStorage$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0006\u0003'=\u0013\u0018m\u00197f\u001f\u001a47/\u001a;Ti>\u0014\u0018mZ3\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\bgR|'/Y4f\u0015\t9\u0001\"\u0001\u0005d_:\u001cX/\\3s\u0015\u0005I\u0011!B6bM.\f7\u0001A\n\u0006\u00011!\u0002D\b\t\u0003\u001bIi\u0011A\u0004\u0006\u0003\u001fA\tA\u0001\\1oO*\t\u0011#\u0001\u0003kCZ\f\u0017BA\n\u000f\u0005\u0019y%M[3diB\u0011QCF\u0007\u0002\t%\u0011q\u0003\u0002\u0002\u000e\u001f\u001a47/\u001a;Ti>\u0014\u0018mZ3\u0011\u0005eaR\"\u0001\u000e\u000b\u0005mA\u0011!B;uS2\u001c\u0018BA\u000f\u001b\u0005\u001daunZ4j]\u001e\u0004\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u00121bU2bY\u0006|%M[3di\"AQ\u0005\u0001BC\u0002\u0013\u0005a%\u0001\u0006d_:tWm\u0019;j_:,\u0012a\n\t\u0003Q)j\u0011!\u000b\u0006\u0003\u0007AI!aK\u0015\u0003\u0015\r{gN\\3di&|g\u000e\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003(\u0003-\u0019wN\u001c8fGRLwN\u001c\u0011\t\u000b=\u0002A\u0011\u0001\u0019\u0002\rqJg.\u001b;?)\t\t4\u0007\u0005\u00023\u00015\t!\u0001C\u0003&]\u0001\u0007q\u0005C\u00046\u0001\t\u0007I\u0011\u0002\u001c\u0002\t1|7m[\u000b\u0002\u0019!1\u0001\b\u0001Q\u0001\n1\tQ\u0001\\8dW\u0002BQA\u000f\u0001\u0005\u0002m\nqA]3tKJ4X\rF\u0002=\u007f\u0011\u0003\"aH\u001f\n\u0005y\u0002#\u0001\u0002'p]\u001eDQ\u0001Q\u001dA\u0002\u0005\u000bAA\\8eKB\u0011qDQ\u0005\u0003\u0007\u0002\u00121!\u00138u\u0011\u0015)\u0015\b1\u0001G\u0003\u0015!x\u000e]5d!\t9%J\u0004\u0002 \u0011&\u0011\u0011\nI\u0001\u0007!J,G-\u001a4\n\u0005-c%AB*ue&twM\u0003\u0002JA!)a\n\u0001C\u0001\u001f\u000611m\\7nSR$B\u0001U*U+B\u0011q$U\u0005\u0003%\u0002\u0012A!\u00168ji\")\u0001)\u0014a\u0001\u0003\")Q)\u0014a\u0001\r\")a+\u0014a\u0001y\u00051qN\u001a4tKRDQ\u0001\u0017\u0001\u0005\u0002e\u000bQa\u00197pg\u0016$\u0012\u0001\u0015\u0005\u00067\u0002!I\u0001X\u0001\u0016[\u0006L(-Z%og\u0016\u0014HOW3s_>3gm]3u)\u0011i\u0006-\u00192\u0011\u0005}q\u0016BA0!\u0005\u001d\u0011un\u001c7fC:DQ!\n.A\u0002\u001dBQ\u0001\u0011.A\u0002\u0005CQ!\u0012.A\u0002\u0019CQ\u0001\u001a\u0001\u0005\n\u0015\fAc]3mK\u000e$X\t_5ti&twm\u00144gg\u0016$H\u0003\u00024jU.\u00042aH4=\u0013\tA\u0007E\u0001\u0004PaRLwN\u001c\u0005\u0006K\r\u0004\ra\n\u0005\u0006\u0001\u000e\u0004\r!\u0011\u0005\u0006\u000b\u000e\u0004\rA\u0012\u0005\u0006[\u0002!IA\\\u0001\rkB$\u0017\r^3PM\u001a\u001cX\r\u001e\u000b\u0006!>\u0004\u0018O\u001d\u0005\u0006K1\u0004\ra\n\u0005\u0006\u00012\u0004\r!\u0011\u0005\u0006\u000b2\u0004\rA\u0012\u0005\u0006g2\u0004\r\u0001P\u0001\n]\u0016<xJ\u001a4tKRDQ!\u001e\u0001\u0005\nY\f\u0001cY8n[&$xJ\u001d*pY2\u0014\u0017mY6\u0015\u0007A;\b\u0010C\u0003&i\u0002\u0007q\u0005C\u0003Oi\u0002\u0007Q\fC\u0003Y\u0001\u0011%!\u0010\u0006\u0002Qw\")A0\u001fa\u0001{\u0006\u0011!o\u001d\t\u0003QyL!a`\u0015\u0003\u0013I+7/\u001e7u'\u0016$\bB\u0002-\u0001\t\u0013\t\u0019\u0001F\u0002Q\u0003\u000bA\u0001\"a\u0002\u0002\u0002\u0001\u0007\u0011\u0011B\u0001\u0005gRlG\u000fE\u0002)\u0003\u0017I1!!\u0004*\u0005E\u0001&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e\u0005\u00071\u0002!I!!\u0005\u0015\u0007A\u000b\u0019\u0002\u0003\u0004&\u0003\u001f\u0001\ra\n\u0015\u0004\u0001\u0005]\u0001cA\r\u0002\u001a%\u0019\u00111\u0004\u000e\u0003\u001b9|g\u000e\u001e5sK\u0006$7/\u00194f\u0001")
public class OracleOffsetStorage
implements OffsetStorage,
Logging,
ScalaObject {
    private final Connection connection;
    private final Object lock;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        OracleOffsetStorage oracleOffsetStorage = this;
        synchronized (oracleOffsetStorage) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public Connection connection() {
        return this.connection;
    }

    private Object lock() {
        return this.lock;
    }

    @Override
    public long reserve(int node$1, String topic$1) {
        Option<Long> option;
        block4: {
            long l;
            block3: {
                block2: {
                    Option<Long> maybeOffset = this.selectExistingOffset(this.connection(), node$1, topic$1);
                    option = maybeOffset;
                    if (!(option instanceof Some)) break block2;
                    l = BoxesRunTime.unboxToLong(((Some)option).x());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Long> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                this.maybeInsertZeroOffset(this.connection(), node$1, topic$1);
                l = BoxesRunTime.unboxToLong(this.selectExistingOffset(this.connection(), node$1, topic$1).get());
            }
            long offset$1 = l;
            this.debug((Function0<String>)new $anonfun$reserve$1(this, node$1, topic$1, offset$1));
            return offset$1;
        }
        throw new MatchError(option);
    }

    @Override
    public void commit(int node, String topic, long offset) {
        boolean success2;
        block3: {
            success2 = false;
            this.updateOffset(this.connection(), node, topic, offset);
            success2 = true;
            if (!this.logger().isDebugEnabled()) break block3;
            this.logger().debug(new StringBuilder().append((Object)"Updated node ").append(BoxesRunTime.boxToInteger(node)).append((Object)" for topic '").append((Object)topic).append((Object)"' to ").append(BoxesRunTime.boxToLong(offset)).toString());
        }
        return;
        finally {
            this.commitOrRollback(this.connection(), success2);
        }
    }

    public void close() {
        Utils$.MODULE$.swallow(new $anonfun$close$5(this), new $anonfun$close$1(this));
    }

    private boolean maybeInsertZeroOffset(Connection connection, int node, String topic) {
        PreparedStatement stmt = connection.prepareStatement("insert into kafka_offsets (node, topic, offset) \n         select ?, ?, 0 from dual where not exists \n         (select null from kafka_offsets where node = ? and topic = ?)");
        stmt.setInt(1, node);
        stmt.setString(2, topic);
        stmt.setInt(3, node);
        stmt.setString(4, topic);
        int updated2 = stmt.executeUpdate();
        if (updated2 > 1) {
            throw new IllegalStateException("More than one key updated by primary key!");
        }
        return updated2 == 1;
    }

    private Option<Long> selectExistingOffset(Connection connection, int node, String topic) {
        PreparedStatement stmt = connection.prepareStatement("select offset from kafka_offsets\n           where node = ? and topic = ?\n           for update");
        ResultSet results = null;
        None$ exceptionResult1 = null;
        try {
            Option option;
            stmt.setInt(1, node);
            stmt.setString(2, topic);
            results = stmt.executeQuery();
            if (results.next()) {
                long offset = results.getLong("offset");
                if (results.next()) {
                    throw new IllegalStateException("More than one entry for primary key!");
                }
                option = new Some<Long>(BoxesRunTime.boxToLong(offset));
            } else {
                option = None$.MODULE$;
            }
            exceptionResult1 = option;
            this.close(stmt);
            this.close(results);
            return exceptionResult1;
        }
        catch (Throwable throwable) {
            this.close(stmt);
            this.close(results);
            throw throwable;
        }
    }

    private void updateOffset(Connection connection, int node, String topic, long newOffset) {
        PreparedStatement stmt = connection.prepareStatement("update kafka_offsets set offset = ? where node = ? and topic = ?");
        try {
            stmt.setLong(1, newOffset);
            stmt.setInt(2, node);
            stmt.setString(3, topic);
            int updated2 = stmt.executeUpdate();
            if (updated2 != 1) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Unexpected number of keys updated: ").append(BoxesRunTime.boxToInteger(updated2)).toString());
            }
            return;
        }
        finally {
            this.close(stmt);
        }
    }

    private void commitOrRollback(Connection connection$1, boolean commit2) {
        if (connection$1 != null) {
            if (commit2) {
                Utils$.MODULE$.swallow(new $anonfun$commitOrRollback$3(this), new $anonfun$commitOrRollback$1(this, connection$1));
            } else {
                Utils$.MODULE$.swallow(new $anonfun$commitOrRollback$4(this), new $anonfun$commitOrRollback$2(this, connection$1));
            }
        }
    }

    private void close(ResultSet rs$1) {
        if (rs$1 != null) {
            Utils$.MODULE$.swallow(new $anonfun$close$6(this), new $anonfun$close$2(this, rs$1));
        }
    }

    private void close(PreparedStatement stmt$1) {
        if (stmt$1 != null) {
            Utils$.MODULE$.swallow(new $anonfun$close$7(this), new $anonfun$close$3(this, stmt$1));
        }
    }

    private void close(Connection connection$2) {
        if (connection$2 != null) {
            Utils$.MODULE$.swallow(new $anonfun$close$8(this), new $anonfun$close$4(this, connection$2));
        }
    }

    public OracleOffsetStorage(Connection connection) {
        this.connection = connection;
        Logging$class.$init$(this);
        this.lock = new Object();
        connection.setAutoCommit(false);
    }
}

