/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.text.NumberFormat;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.common.OffsetOutOfRangeException;
import kafka.utils.Range;
import scala.Array$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Log$
implements ScalaObject {
    public static final Log$ MODULE$;
    private final String FileSuffix;

    static {
        new Log$();
    }

    public String FileSuffix() {
        return this.FileSuffix;
    }

    public <T extends Range> Option<T> findRange(T[] ranges, long value2, int arraySize) {
        if (Predef$.MODULE$.refArrayOps(ranges).size() < 1) {
            return None$.MODULE$;
        }
        if (value2 < ranges[0].start() || value2 > ranges[arraySize - 1].start() + ranges[arraySize - 1].size()) {
            throw new OffsetOutOfRangeException(new StringBuilder().append((Object)"offset ").append(BoxesRunTime.boxToLong(value2)).append((Object)" is out of range").toString());
        }
        if (value2 == ranges[arraySize - 1].start() + ranges[arraySize - 1].size()) {
            return None$.MODULE$;
        }
        int low = 0;
        int high = arraySize - 1;
        while (low <= high) {
            int mid = (high + low) / 2;
            T found = ranges[mid];
            if (found.contains(value2)) {
                return new Some<T>(found);
            }
            if (value2 < found.start()) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return None$.MODULE$;
    }

    public <T extends Range> Option<T> findRange(T[] ranges, long value2) {
        return this.findRange((Range[])ranges, value2, ranges.length);
    }

    public String nameFromOffset(long offset) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return new StringBuilder().append((Object)nf.format(offset)).append((Object)this.FileSuffix()).toString();
    }

    public long[] getEmptyOffsets(OffsetRequest request) {
        if (request.time() == OffsetRequest$.MODULE$.LatestTime() || request.time() == OffsetRequest$.MODULE$.EarliestTime()) {
            return Array$.MODULE$.apply(0L, (Seq<Object>)Predef$.MODULE$.wrapLongArray(new long[0]));
        }
        return (long[])Array$.MODULE$.apply(Predef$.MODULE$.wrapLongArray(new long[0]), (ClassManifest)Manifest$.MODULE$.Long());
    }

    private Log$() {
        MODULE$ = this;
        this.FileSuffix = ".kafka";
    }
}

