/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.common.InvalidMessageSizeException;
import kafka.log.Log$;
import kafka.log.LogSegment;
import kafka.log.LogStats;
import kafka.log.SegmentList;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.FileMessageSet;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.server.BrokerTopicStat$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Range;
import kafka.utils.SystemTime$;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t-tAB\u0001\u0003\u0011\u000b\u0011a!A\u0002M_\u001eT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b!\t9\u0001\"D\u0001\u0003\r%I!\u0001\"A\u0001\u0012\u000b\u0011!BA\u0002M_\u001e\u001c2\u0001C\u0006\u0014!\ta\u0011#D\u0001\u000e\u0015\tqq\"\u0001\u0003mC:<'\"\u0001\t\u0002\t)\fg/Y\u0005\u0003%5\u0011aa\u00142kK\u000e$\bC\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"aC*dC2\fwJ\u00196fGRDQA\u0007\u0005\u0005\u0002q\ta\u0001P5oSRt4\u0001\u0001\u000b\u0002\r!9a\u0004\u0003b\u0001\n\u0003y\u0012A\u0003$jY\u0016\u001cVO\u001a4jqV\t\u0001\u0005\u0005\u0002\rC%\u0011!%\u0004\u0002\u0007'R\u0014\u0018N\\4\t\r\u0011B\u0001\u0015!\u0003!\u0003-1\u0015\u000e\\3Tk\u001a4\u0017\u000e\u001f\u0011\t\u000b\u0019BA\u0011A\u0014\u0002\u0013\u0019Lg\u000e\u001a*b]\u001e,WC\u0001\u0015/)\u0011I#h\u0010#\u0011\u0007QQC&\u0003\u0002,+\t1q\n\u001d;j_:\u0004\"!\f\u0018\r\u0001\u0011Aq&\nC\u0001\u0002\u000b\u0007\u0001GA\u0001U#\t\tD\u0007\u0005\u0002\u0015e%\u00111'\u0006\u0002\b\u001d>$\b.\u001b8h!\t)\u0004(D\u00017\u0015\t9D!A\u0003vi&d7/\u0003\u0002:m\t)!+\u00198hK\")1(\na\u0001y\u00051!/\u00198hKN\u00042\u0001F\u001f-\u0013\tqTCA\u0003BeJ\f\u0017\u0010C\u0003AK\u0001\u0007\u0011)A\u0003wC2,X\r\u0005\u0002\u0015\u0005&\u00111)\u0006\u0002\u0005\u0019>tw\rC\u0003FK\u0001\u0007a)A\u0005beJ\f\u0017pU5{KB\u0011AcR\u0005\u0003\u0011V\u00111!\u00138u\u0011\u00151\u0003\u0002\"\u0001K+\tYe\nF\u0002M\u001fF\u00032\u0001\u0006\u0016N!\tic\n\u0002\u00050\u0013\u0012\u0005\tQ1\u00011\u0011\u0015Y\u0014\n1\u0001Q!\r!R(\u0014\u0005\u0006\u0001&\u0003\r!\u0011\u0005\u0006'\"!\t\u0001V\u0001\u000f]\u0006lWM\u0012:p[>3gm]3u)\t)6\f\u0005\u0002W3:\u0011AcV\u0005\u00031V\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0012[\u0015\tAV\u0003C\u0003]%\u0002\u0007\u0011)\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\u0006=\"!\taX\u0001\u0010O\u0016$X)\u001c9us>3gm]3ugR\u0011\u0001-\u0019\t\u0004)u\n\u0005\"\u00022^\u0001\u0004\u0019\u0017a\u0002:fcV,7\u000f\u001e\t\u0003I\u001el\u0011!\u001a\u0006\u0003M\u0012\t1!\u00199j\u0013\tAWMA\u0007PM\u001a\u001cX\r\u001e*fcV,7\u000f\u001e\u0004\n\u0013\t!\t\u0011!A\u0001\u0005)\u001cB![\u0006l'A\u0011Q\u0007\\\u0005\u0003[Z\u0012q\u0001T8hO&tw\r\u0003\u0005pS\n\u0015\r\u0011\"\u0001q\u0003\r!\u0017N]\u000b\u0002cB\u0011!/^\u0007\u0002g*\u0011AoD\u0001\u0003S>L!A^:\u0003\t\u0019KG.\u001a\u0005\tq&\u0014\t\u0011)A\u0005c\u0006!A-\u001b:!\u0011!Q\u0018N!b\u0001\n\u0003Y\u0018\u0001\u0002;j[\u0016,\u0012\u0001 \t\u0003kuL!A \u001c\u0003\tQKW.\u001a\u0005\n\u0003\u0003I'\u0011!Q\u0001\nq\fQ\u0001^5nK\u0002B!\"!\u0002j\u0005\u000b\u0007I\u0011AA\u0004\u0003\u001di\u0017\r_*ju\u0016,\u0012!\u0011\u0005\n\u0003\u0017I'\u0011!Q\u0001\n\u0005\u000b\u0001\"\\1y'&TX\r\t\u0005\u000b\u0003\u001fI'Q1A\u0005\u0002\u0005E\u0011AD7bq6+7o]1hKNK'0Z\u000b\u0002\r\"I\u0011QC5\u0003\u0002\u0003\u0006IAR\u0001\u0010[\u0006DX*Z:tC\u001e,7+\u001b>fA!Q\u0011\u0011D5\u0003\u0006\u0004%\t!!\u0005\u0002\u001b\u0019dWo\u001d5J]R,'O^1m\u0011%\ti\"\u001bB\u0001B\u0003%a)\u0001\bgYV\u001c\b.\u00138uKJ4\u0018\r\u001c\u0011\t\u0015\u0005\u0005\u0012N!b\u0001\n\u0003\t9!\u0001\bs_2d\u0017J\u001c;feZ\fG.T:\t\u0013\u0005\u0015\u0012N!A!\u0002\u0013\t\u0015a\u0004:pY2Le\u000e^3sm\u0006dWj\u001d\u0011\t\u0015\u0005%\u0012N!b\u0001\n\u0003\tY#\u0001\u0007oK\u0016$'+Z2pm\u0016\u0014\u00180\u0006\u0002\u0002.A\u0019A#a\f\n\u0007\u0005ERCA\u0004C_>dW-\u00198\t\u0015\u0005U\u0012N!A!\u0002\u0013\ti#A\u0007oK\u0016$'+Z2pm\u0016\u0014\u0018\u0010\t\u0005\u00075%$\t!!\u000f\u0015!\u0005m\u0012QHA \u0003\u0003\n\u0019%!\u0012\u0002H\u0005%\u0003CA\u0004j\u0011\u0019y\u0017q\u0007a\u0001c\"1!0a\u000eA\u0002qDq!!\u0002\u00028\u0001\u0007\u0011\tC\u0004\u0002\u0010\u0005]\u0002\u0019\u0001$\t\u000f\u0005e\u0011q\u0007a\u0001\r\"9\u0011\u0011EA\u001c\u0001\u0004\t\u0005\u0002CA\u0015\u0003o\u0001\r!!\f\t\u0013\u00055\u0013N1A\u0005\n\u0005=\u0013\u0001\u00027pG.,\u0012a\u0003\u0005\b\u0003'J\u0007\u0015!\u0003\f\u0003\u0015awnY6!\u0011%\t9&\u001bb\u0001\n\u0013\tI&A\u0005v]\u001adWo\u001d5fIV\u0011\u00111\f\t\u0005\u0003;\nY'\u0004\u0002\u0002`)!\u0011\u0011MA2\u0003\u0019\tGo\\7jG*!\u0011QMA4\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003Sz\u0011\u0001B;uS2LA!!\u001c\u0002`\ti\u0011\t^8nS\u000eLe\u000e^3hKJD\u0001\"!\u001djA\u0003%\u00111L\u0001\u000bk:4G.^:iK\u0012\u0004\u0003\"CA;S\n\u0007I\u0011BA<\u0003=a\u0017m\u001d;gYV\u001c\b.\u001a3US6,WCAA=!\u0011\ti&a\u001f\n\t\u0005u\u0014q\f\u0002\u000b\u0003R|W.[2M_:<\u0007\u0002CAAS\u0002\u0006I!!\u001f\u0002!1\f7\u000f\u001e4mkNDW\r\u001a+j[\u0016\u0004\u0003BCACS\n\u0007I\u0011\u0001\u0002\u0002\b\u0006A1/Z4nK:$8/\u0006\u0002\u0002\nB)q!a#\u0002\u0010&\u0019\u0011Q\u0012\u0002\u0003\u0017M+w-\\3oi2K7\u000f\u001e\t\u0004\u000f\u0005E\u0015bAAJ\u0005\tQAj\\4TK\u001elWM\u001c;\t\u0011\u0005]\u0015\u000e)A\u0005\u0003\u0013\u000b\u0011b]3h[\u0016tGo\u001d\u0011\t\u0011\u0005m\u0015N1A\u0005\u0002}\tAA\\1nK\"9\u0011qT5!\u0002\u0013\u0001\u0013!\u00028b[\u0016\u0004\u0003\"CARS\n\u0007I\u0011BAS\u0003!awnZ*uCR\u001cXCAAT!\r9\u0011\u0011V\u0005\u0004\u0003W\u0013!\u0001\u0003'pON#\u0018\r^:\t\u0011\u0005=\u0016\u000e)A\u0005\u0003O\u000b\u0011\u0002\\8h'R\fGo\u001d\u0011\t\u000f\u0005M\u0016\u000e\"\u0003\u00026\u0006aAn\\1e'\u0016<W.\u001a8ugR\u0011\u0011\u0011\u0012\u0005\b\u0003sKG\u0011BA^\u0003A1\u0018\r\\5eCR,7+Z4nK:$8\u000f\u0006\u0003\u0002>\u0006\r\u0007c\u0001\u000b\u0002@&\u0019\u0011\u0011Y\u000b\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u000b\u000b9\f1\u0001\u0002FB1\u0011qYAe\u0003\u001fk!!a\u001a\n\t\u0005-\u0017q\r\u0002\n\u0003J\u0014\u0018-\u001f'jgRDq!a4j\t\u0003\t\t\"\u0001\tok6\u0014WM](g'\u0016<W.\u001a8ug\"9\u00111[5\u0005\u0002\u0005U\u0017!B2m_N,GCAA_\u0011\u001d\tI.\u001bC\u0001\u00037\fa!\u00199qK:$G\u0003BA_\u0003;D\u0001\"a8\u0002X\u0002\u0007\u0011\u0011]\u0001\t[\u0016\u001c8/Y4fgB!\u00111]Au\u001b\t\t)OC\u0002\u0002h\u0012\tq!\\3tg\u0006<W-\u0003\u0003\u0002l\u0006\u0015(\u0001\u0006\"zi\u0016\u0014UO\u001a4fe6+7o]1hKN+G\u000fC\u0004\u0002p&$\t!!=\u0002\tI,\u0017\r\u001a\u000b\u0007\u0003g\fI0a?\u0011\t\u0005\r\u0018Q_\u0005\u0005\u0003o\f)O\u0001\u0006NKN\u001c\u0018mZ3TKRDa\u0001XAw\u0001\u0004\t\u0005bBA\u007f\u0003[\u0004\rAR\u0001\u0007Y\u0016tw\r\u001e5\t\u000f\t\u0005\u0011\u000e\"\u0001\u0003\u0004\u0005\u0001R.\u0019:l\t\u0016dW\r^3e/\"LG.\u001a\u000b\u0005\u0005\u000b\u0011i\u0002\u0005\u0004\u0003\b\t]\u0011q\u0012\b\u0005\u0005\u0013\u0011\u0019B\u0004\u0003\u0003\f\tEQB\u0001B\u0007\u0015\r\u0011yaG\u0001\u0007yI|w\u000e\u001e \n\u0003YI1A!\u0006\u0016\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u0007\u0003\u001c\t\u00191+Z9\u000b\u0007\tUQ\u0003\u0003\u0005\u0003 \u0005}\b\u0019\u0001B\u0011\u0003%\u0001(/\u001a3jG\u0006$X\rE\u0004\u0015\u0005G\ty)!\f\n\u0007\t\u0015RCA\u0005Gk:\u001cG/[8oc!9!\u0011F5\u0005\u0002\u0005\u001d\u0011\u0001B:ju\u0016DqA!\fj\t\u0003\t9!\u0001\toKb$\u0018\t\u001d9f]\u0012|eMZ:fi\"9!\u0011G5\u0005\u0002\u0005\u001d\u0011\u0001E4fi\"Kw\r[<bi\u0016\u0014X*\u0019:l\u0011\u001d\u0011)$\u001bC\u0005\u0005o\t\u0011\"\\1zE\u0016\u0014v\u000e\u001c7\u0015\t\u0005u&\u0011\b\u0005\t\u0005w\u0011\u0019\u00041\u0001\u0002\u0010\u000691/Z4nK:$\bb\u0002B S\u0012\u0005\u0011Q[\u0001\u0005e>dG\u000eC\u0004\u0003D%$IA!\u0012\u0002\u00155\f\u0017PY3GYV\u001c\b\u000e\u0006\u0003\u0002>\n\u001d\u0003b\u0002B%\u0005\u0003\u0002\rAR\u0001\u0011]Vl'-\u001a:PM6+7o]1hKNDqA!\u0014j\t\u0003\t).A\u0003gYV\u001c\b\u000eC\u0004\u0003R%$\tAa\u0015\u0002!\u001d,Go\u00144gg\u0016$8OQ3g_J,Gc\u00011\u0003V!1!Ma\u0014A\u0002\rDqA!\u0017j\t\u0003\u0011Y&\u0001\u0007hKR$v\u000e]5d\u001d\u0006lW\rF\u0001V\u0011\u001d\u0011y&\u001bC\u0001\u0005C\n!cZ3u\u0019\u0006\u001cHO\u00127vg\",G\rV5nKR\t\u0011\tK\u0002j\u0005K\u00022!\u000eB4\u0013\r\u0011IG\u000e\u0002\u000bi\"\u0014X-\u00193tC\u001a,\u0007")
public class Log
implements Logging,
ScalaObject {
    private final File dir;
    private final Time time;
    private final long maxSize;
    private final int maxMessageSize;
    private final int flushInterval;
    private final long rollIntervalMs;
    private final boolean needRecovery;
    private final Object lock;
    private final AtomicInteger unflushed;
    private final AtomicLong lastflushedTime;
    private final SegmentList<LogSegment> segments;
    private final String name;
    private final LogStats logStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final long[] getEmptyOffsets(OffsetRequest offsetRequest) {
        return Log$.MODULE$.getEmptyOffsets(offsetRequest);
    }

    public static final String nameFromOffset(long l) {
        return Log$.MODULE$.nameFromOffset(l);
    }

    public static final <T extends Range> Option<T> findRange(T[] TArray, long l) {
        return Log$.MODULE$.findRange((Range[])TArray, l);
    }

    public static final <T extends Range> Option<T> findRange(T[] TArray, long l, int n) {
        return Log$.MODULE$.findRange((Range[])TArray, l, n);
    }

    public static final String FileSuffix() {
        return Log$.MODULE$.FileSuffix();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Log log2 = this;
        synchronized (log2) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public File dir() {
        return this.dir;
    }

    public Time time() {
        return this.time;
    }

    public long maxSize() {
        return this.maxSize;
    }

    public int maxMessageSize() {
        return this.maxMessageSize;
    }

    public int flushInterval() {
        return this.flushInterval;
    }

    public long rollIntervalMs() {
        return this.rollIntervalMs;
    }

    public boolean needRecovery() {
        return this.needRecovery;
    }

    private Object lock() {
        return this.lock;
    }

    private AtomicInteger unflushed() {
        return this.unflushed;
    }

    private AtomicLong lastflushedTime() {
        return this.lastflushedTime;
    }

    public SegmentList<LogSegment> segments() {
        return this.segments;
    }

    public String name() {
        return this.name;
    }

    private LogStats logStats() {
        return this.logStats;
    }

    private SegmentList<LogSegment> loadSegments() {
        boolean bl;
        ArrayList<LogSegment> accum$1 = new ArrayList<LogSegment>();
        File[] ls = this.dir().listFiles();
        if (ls != null) {
            Predef$.MODULE$.refArrayOps((Object[])ls).withFilter(new $anonfun$loadSegments$1(this)).foreach(new $anonfun$loadSegments$2(this, accum$1));
        }
        if (accum$1.size() == 0) {
            File newFile = new File(this.dir(), Log$.MODULE$.nameFromOffset(0L));
            FileMessageSet set = new FileMessageSet(newFile, true);
            bl = accum$1.add(new LogSegment(newFile, this.time(), set, 0L));
        } else {
            Collections.sort(accum$1, new $anon$1(this));
            this.validateSegments(accum$1);
            LogSegment last$1 = accum$1.remove(accum$1.size() - 1);
            last$1.messageSet().close();
            this.info((Function0<String>)new $anonfun$loadSegments$3(this, last$1));
            LogSegment mutable = new LogSegment(last$1.file(), this.time(), new FileMessageSet(last$1.file(), true, new AtomicBoolean(this.needRecovery())), last$1.start());
            bl = accum$1.add(mutable);
        }
        return new SegmentList<Object>(Predef$.MODULE$.wrapRefArray(accum$1.toArray((Object[])new LogSegment[accum$1.size()])), ClassManifest$.MODULE$.classType(LogSegment.class));
    }

    private void validateSegments(ArrayList<LogSegment> segments$1) {
        Object object = this.lock();
        synchronized (object) {
            Predef$.MODULE$.intWrapper(0).until(segments$1.size() - 1).foreach$mVc$sp((Function1)new $anonfun$validateSegments$1(this, segments$1));
            return;
        }
    }

    public int numberOfSegments() {
        return ((LogSegment[])this.segments().view()).length;
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).foreach(new $anonfun$close$1(this));
            return;
        }
    }

    public void append(ByteBufferMessageSet messages) {
        messages.verifyMessageSize(this.maxMessageSize());
        IntRef numberOfMessages$1 = new IntRef(0);
        messages.foreach(new $anonfun$append$1(this, numberOfMessages$1));
        BrokerTopicStat$.MODULE$.getBrokerTopicStat(this.getTopicName()).recordMessagesIn(numberOfMessages$1.elem);
        BrokerTopicStat$.MODULE$.getBrokerAllTopicStat().recordMessagesIn(numberOfMessages$1.elem);
        this.logStats().recordAppendedMessages(numberOfMessages$1.elem);
        ByteBuffer validByteBuffer = messages.getBuffer().duplicate();
        long messageSetValidBytes = messages.validBytes();
        if (messageSetValidBytes > Integer.MAX_VALUE || messageSetValidBytes < 0L) {
            throw new InvalidMessageSizeException(new StringBuilder().append((Object)"Illegal length of message set ").append(BoxesRunTime.boxToLong(messageSetValidBytes)).append((Object)" Message set cannot be appended to log. Possible causes are corrupted produce requests").toString());
        }
        validByteBuffer.limit((int)messageSetValidBytes);
        ByteBufferMessageSet validMessages$1 = new ByteBufferMessageSet(validByteBuffer, ByteBufferMessageSet$.MODULE$.init$default$2(), ByteBufferMessageSet$.MODULE$.init$default$3());
        Object object = this.lock();
        synchronized (object) {
            this.liftedTree1$1(numberOfMessages$1, validMessages$1);
            return;
        }
    }

    public MessageSet read(long offset, int length) {
        MessageSet messageSet;
        LogSegment[] view = (LogSegment[])this.segments().view();
        Option option = Log$.MODULE$.findRange(view, offset, view.length);
        if (option instanceof Some) {
            LogSegment logSegment;
            Some some = (Some)option;
            LogSegment segment = logSegment = (LogSegment)some.x();
            messageSet = segment.messageSet().read(offset - segment.start(), length);
        } else {
            messageSet = MessageSet$.MODULE$.Empty();
        }
        return messageSet;
    }

    public Seq<LogSegment> markDeletedWhile(Function1<LogSegment, Boolean> predicate) {
        Object object = this.lock();
        synchronized (object) {
            LogSegment[] view = (LogSegment[])this.segments().view();
            LogSegment[] deletable = (LogSegment[])Predef$.MODULE$.refArrayOps((Object[])view).takeWhile(predicate);
            Predef$.MODULE$.refArrayOps((Object[])deletable).foreach(new $anonfun$markDeletedWhile$1(this));
            int numToDelete = Predef$.MODULE$.refArrayOps((Object[])deletable).size();
            if (numToDelete == Predef$.MODULE$.refArrayOps((Object[])view).size()) {
                if (view[numToDelete - 1].size() > 0L) {
                    this.roll();
                } else {
                    view[numToDelete - 1].file().setLastModified(SystemTime$.MODULE$.milliseconds());
                    --numToDelete;
                }
            }
            Seq<LogSegment> seq = this.segments().trunc(numToDelete);
            return seq;
        }
    }

    public long size() {
        return BoxesRunTime.unboxToLong(Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).foldLeft(BoxesRunTime.boxToLong(0L), new $anonfun$size$1(this)));
    }

    public long nextAppendOffset() {
        this.flush();
        LogSegment last2 = (LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last();
        return last2.start() + last2.size();
    }

    public long getHighwaterMark() {
        return ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last()).messageSet().highWaterMark();
    }

    private void maybeRoll(LogSegment segment) {
        if (segment.messageSet().sizeInBytes() > this.maxSize() || segment.firstAppendTime().isDefined() && this.time().milliseconds() - BoxesRunTime.unboxToLong(segment.firstAppendTime().get()) > this.rollIntervalMs()) {
            this.roll();
        }
    }

    public void roll() {
        Object object = this.lock();
        synchronized (object) {
            Serializable serializable2;
            long newOffset = this.nextAppendOffset();
            File newFile$1 = new File(this.dir(), Log$.MODULE$.nameFromOffset(newOffset));
            if (newFile$1.exists()) {
                this.warn((Function0<String>)new $anonfun$roll$1(this, newFile$1));
                serializable2 = BoxesRunTime.boxToBoolean(newFile$1.delete());
            } else {
                serializable2 = BoxedUnit.UNIT;
            }
            this.debug((Function0<String>)new $anonfun$roll$2(this, newFile$1));
            this.segments().append(Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{new LogSegment(newFile$1, this.time(), new FileMessageSet(newFile$1, true), newOffset)}), (ClassManifest<LogSegment>)ClassManifest$.MODULE$.classType(LogSegment.class));
            return;
        }
    }

    private void maybeFlush(int numberOfMessages) {
        if (this.unflushed().addAndGet(numberOfMessages) >= this.flushInterval()) {
            this.flush();
        }
    }

    public void flush() {
        if (this.unflushed().get() == 0) {
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            this.debug((Function0<String>)new $anonfun$flush$1(this));
            ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last()).messageSet().flush();
            this.unflushed().set(0);
            this.lastflushedTime().set(System.currentTimeMillis());
            return;
        }
    }

    public long[] getOffsetsBefore(OffsetRequest request) {
        LogSegment[] segsArray$1 = (LogSegment[])this.segments().view();
        ObjectRef<Object> offsetTimeArray$1 = new ObjectRef<Object>(null);
        offsetTimeArray$1.elem = ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray$1).last()).size() > 0L ? new Tuple2[segsArray$1.length + 1] : new Tuple2[segsArray$1.length];
        Predef$.MODULE$.intWrapper(0).until(segsArray$1.length).foreach$mVc$sp((Function1)new $anonfun$getOffsetsBefore$1(this, segsArray$1, offsetTimeArray$1));
        if (((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray$1).last()).size() > 0L) {
            ((Tuple2[])offsetTimeArray$1.elem)[segsArray$1.length] = new Tuple2.mcLL.sp(((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray$1).last()).start() + ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray$1).last()).messageSet().highWaterMark(), SystemTime$.MODULE$.milliseconds());
        }
        IntRef startIndex$1 = new IntRef(-1);
        long l = request.time();
        if (l == OffsetRequest$.MODULE$.LatestTime()) {
            startIndex$1.elem = ((Tuple2[])offsetTimeArray$1.elem).length - 1;
        } else if (l == OffsetRequest$.MODULE$.EarliestTime()) {
            startIndex$1.elem = 0;
        } else {
            boolean isFound = false;
            this.debug((Function0<String>)new $anonfun$getOffsetsBefore$3(this, offsetTimeArray$1));
            startIndex$1.elem = ((Tuple2[])offsetTimeArray$1.elem).length - 1;
            while (startIndex$1.elem >= 0 && !isFound) {
                if (((Tuple2[])offsetTimeArray$1.elem)[startIndex$1.elem]._2$mcL$sp() <= request.time()) {
                    isFound = true;
                    continue;
                }
                --startIndex$1.elem;
            }
        }
        int retSize = Predef$.MODULE$.intWrapper(request.maxNumOffsets()).min(startIndex$1.elem + 1);
        long[] ret$1 = new long[retSize];
        Predef$.MODULE$.intWrapper(0).until(retSize).foreach$mVc$sp((Function1)new $anonfun$getOffsetsBefore$2(this, offsetTimeArray$1, startIndex$1, ret$1));
        return ret$1;
    }

    public String getTopicName() {
        return this.name().substring(0, this.name().lastIndexOf("-"));
    }

    public long getLastFlushedTime() {
        return this.lastflushedTime().get();
    }

    private final void liftedTree1$1(IntRef intRef, ByteBufferMessageSet byteBufferMessageSet) {
        try {
            LogSegment segment = (LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last();
            this.maybeRoll(segment);
            segment = (LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last();
            segment.append(byteBufferMessageSet);
            this.maybeFlush(intRef.elem);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            this.fatal((Function0<String>)new $anonfun$liftedTree1$1$1(this), (Function0<Throwable>)new $anonfun$liftedTree1$1$2(this, iOException));
            Runtime.getRuntime().halt(1);
        }
    }

    public Log(File dir, Time time, long maxSize, int maxMessageSize, int flushInterval, long rollIntervalMs, boolean needRecovery) {
        this.dir = dir;
        this.time = time;
        this.maxSize = maxSize;
        this.maxMessageSize = maxMessageSize;
        this.flushInterval = flushInterval;
        this.rollIntervalMs = rollIntervalMs;
        this.needRecovery = needRecovery;
        Logging$class.$init$(this);
        this.lock = new Object();
        this.unflushed = new AtomicInteger(0);
        this.lastflushedTime = new AtomicLong(System.currentTimeMillis());
        this.segments = this.loadSegments();
        this.name = dir.getName();
        this.logStats = new LogStats(this);
        Utils$.MODULE$.registerMBean(this.logStats(), new StringBuilder().append((Object)"kafka:type=kafka.logs.").append((Object)dir.getName()).toString());
    }
}

