/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import kafka.api.OffsetRequest;
import kafka.common.InvalidPartitionException;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogManager$;
import kafka.log.LogManager$$anonfun$kafka$log$LogManager$;
import kafka.log.LogManager$StopActor$;
import kafka.log.LogSegment;
import kafka.server.KafkaConfig;
import kafka.server.KafkaZooKeeper;
import kafka.utils.KafkaScheduler;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Time;
import kafka.utils.TopicNameValidator;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.actors.Actor;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tEh!C\u0001\u0003\t\u0003\u0005\t\u0011\u0001\u0003\u0007\u0005)aunZ'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7\u0003\u0002\u0001\b\u001fU\u0001\"\u0001C\u0007\u000e\u0003%Q!AC\u0006\u0002\t1\fgn\u001a\u0006\u0002\u0019\u0005!!.\u0019<b\u0013\tq\u0011B\u0001\u0004PE*,7\r\u001e\t\u0003!Mi\u0011!\u0005\u0006\u0003%\u0011\tQ!\u001e;jYNL!\u0001F\t\u0003\u000f1{wmZ5oOB\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\tY1kY1mC>\u0013'.Z2u\u0011!a\u0002A!b\u0001\n\u0003q\u0012AB2p]\u001aLwm\u0001\u0001\u0016\u0003}\u0001\"\u0001I\u0012\u000e\u0003\u0005R!A\t\u0003\u0002\rM,'O^3s\u0013\t!\u0013EA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u000f\r|gNZ5hA!A\u0001\u0006\u0001BC\u0002\u0013%\u0011&A\u0005tG\",G-\u001e7feV\t!\u0006\u0005\u0002\u0011W%\u0011A&\u0005\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0011!q\u0003A!A!\u0002\u0013Q\u0013AC:dQ\u0016$W\u000f\\3sA!A\u0001\u0007\u0001BC\u0002\u0013%\u0011'\u0001\u0003uS6,W#\u0001\u001a\u0011\u0005A\u0019\u0014B\u0001\u001b\u0012\u0005\u0011!\u0016.\\3\t\u0011Y\u0002!\u0011!Q\u0001\nI\nQ\u0001^5nK\u0002B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!O\u0001\u0019Y><'k\u001c7m\t\u00164\u0017-\u001e7u\u0013:$XM\u001d<bY6\u001bX#\u0001\u001e\u0011\u0005YY\u0014B\u0001\u001f\u0018\u0005\u0011auN\\4\t\u0011y\u0002!\u0011!Q\u0001\ni\n\u0011\u0004\\8h%>dG\u000eR3gCVdG/\u00138uKJ4\u0018\r\\'tA!A\u0001\t\u0001BC\u0002\u0013\u0005\u0011(\u0001\u000bm_\u001e\u001cE.Z1okBLe\u000e^3sm\u0006dWj\u001d\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005u\u0005)Bn\\4DY\u0016\fg.\u001e9J]R,'O^1m\u001bN\u0004\u0003\u0002\u0003#\u0001\u0005\u000b\u0007I\u0011A\u001d\u0002-1|wm\u00117fC:,\b\u000fR3gCVdG/Q4f\u001bND\u0001B\u0012\u0001\u0003\u0002\u0003\u0006IAO\u0001\u0018Y><7\t\\3b]V\u0004H)\u001a4bk2$\u0018iZ3Ng\u0002B\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!S\u0001\r]\u0016,GMU3d_Z,'/\u001f\t\u0003-)K!aS\f\u0003\u000f\t{w\u000e\\3b]\")Q\n\u0001C\u0001\u001d\u00061A(\u001b8jiz\"\u0002bT)S'R+fk\u0016\t\u0003!\u0002i\u0011A\u0001\u0005\u000691\u0003\ra\b\u0005\u0006Q1\u0003\rA\u000b\u0005\u0006a1\u0003\rA\r\u0005\u0006q1\u0003\rA\u000f\u0005\u0006\u00012\u0003\rA\u000f\u0005\u0006\t2\u0003\rA\u000f\u0005\u0006\u00112\u0003\r!\u0013\u0005\b3\u0002\u0011\r\u0011\"\u0001[\u0003\u0019awn\u001a#jeV\t1\f\u0005\u0002]?6\tQL\u0003\u0002_\u0017\u0005\u0011\u0011n\\\u0005\u0003Av\u0013AAR5mK\"1!\r\u0001Q\u0001\nm\u000bq\u0001\\8h\t&\u0014\b\u0005C\u0004e\u0001\t\u0007I\u0011B3\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t+\u00051\u0007C\u0001\fh\u0013\tAwCA\u0002J]RDaA\u001b\u0001!\u0002\u00131\u0017A\u00048v[B\u000b'\u000f^5uS>t7\u000f\t\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u00039awn\u001a$jY\u0016\u001c\u0016N_3NCB,\u0012A\u001c\t\u0005_J$h-D\u0001q\u0015\t\tx#\u0001\u0006d_2dWm\u0019;j_:L!a\u001d9\u0003\u00075\u000b\u0007\u000f\u0005\u0002vq:\u0011aC^\u0005\u0003o^\ta\u0001\u0015:fI\u00164\u0017BA={\u0005\u0019\u0019FO]5oO*\u0011qo\u0006\u0005\u0007y\u0002\u0001\u000b\u0011\u00028\u0002\u001f1|wMR5mKNK'0Z'ba\u0002BqA \u0001C\u0002\u0013%Q-A\u0007gYV\u001c\b.\u00138uKJ4\u0018\r\u001c\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003g\u000391G.^:i\u0013:$XM\u001d<bY\u0002B\u0001\"!\u0002\u0001\u0005\u0004%I!\\\u0001\u0013i>\u0004\u0018n\u0019)beRLG/[8og6\u000b\u0007\u000fC\u0004\u0002\n\u0001\u0001\u000b\u0011\u00028\u0002'Q|\u0007/[2QCJ$\u0018\u000e^5p]Nl\u0015\r\u001d\u0011\t\u0013\u00055\u0001A1A\u0005\n\u0005=\u0011a\u00047pO\u000e\u0013X-\u0019;j_:dunY6\u0016\u0003\u001dAq!a\u0005\u0001A\u0003%q!\u0001\tm_\u001e\u001c%/Z1uS>tGj\\2lA!I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011D\u0001\u0007e\u0006tGm\\7\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u00052\"\u0001\u0003vi&d\u0017\u0002BA\u0013\u0003?\u0011aAU1oI>l\u0007\u0002CA\u0015\u0001\u0001\u0006I!a\u0007\u0002\u000fI\fg\u000eZ8nA!I\u0011Q\u0006\u0001A\u0002\u0013%\u0011qF\u0001\u000fW\u000647.\u0019.p_.,W\r]3s+\t\t\t\u0004E\u0002!\u0003gI1!!\u000e\"\u00059Y\u0015MZ6b5>|7*Z3qKJD\u0011\"!\u000f\u0001\u0001\u0004%I!a\u000f\u0002%-\fgm[1[_>\\W-\u001a9fe~#S-\u001d\u000b\u0005\u0003{\t\u0019\u0005E\u0002\u0017\u0003\u007fI1!!\u0011\u0018\u0005\u0011)f.\u001b;\t\u0015\u0005\u0015\u0013qGA\u0001\u0002\u0004\t\t$A\u0002yIEB\u0001\"!\u0013\u0001A\u0003&\u0011\u0011G\u0001\u0010W\u000647.\u0019.p_.,W\r]3sA!I\u0011Q\n\u0001A\u0002\u0013%\u0011qJ\u0001\bu.\f5\r^8s+\t\t\t\u0006\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9fF\u0001\u0007C\u000e$xN]:\n\t\u0005m\u0013Q\u000b\u0002\u0006\u0003\u000e$xN\u001d\u0005\n\u0003?\u0002\u0001\u0019!C\u0005\u0003C\n1B_6BGR|'o\u0018\u0013fcR!\u0011QHA2\u0011)\t)%!\u0018\u0002\u0002\u0003\u0007\u0011\u0011\u000b\u0005\t\u0003O\u0002\u0001\u0015)\u0003\u0002R\u0005A!p[!di>\u0014\b\u0005C\u0005\u0002l\u0001\u0011\r\u0011\"\u0003\u0002n\u0005a1\u000f^1siV\u0004H*\u0019;dQV\u0011\u0011q\u000e\t\u0005\u0003c\n9(\u0004\u0002\u0002t)!\u0011QOA\u0010\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003s\n\u0019H\u0001\bD_VtG\u000fR8x]2\u000bGo\u00195\t\u0011\u0005u\u0004\u0001)A\u0005\u0003_\nQb\u001d;beR,\b\u000fT1uG\"\u0004\u0003\u0002CAA\u0001\t\u0007I\u0011B\u0015\u0002'1|wM\u00127vg\",'oU2iK\u0012,H.\u001a:\t\u000f\u0005\u0015\u0005\u0001)A\u0005U\u0005!Bn\\4GYV\u001c\b.\u001a:TG\",G-\u001e7fe\u0002B\u0011\"!#\u0001\u0005\u0004%I!a#\u0002%Q|\u0007/[2OC6,g+\u00197jI\u0006$xN]\u000b\u0003\u0003\u001b\u00032\u0001EAH\u0013\r\t\t*\u0005\u0002\u0013)>\u0004\u0018n\u0019(b[\u00164\u0016\r\\5eCR|'\u000f\u0003\u0005\u0002\u0016\u0002\u0001\u000b\u0011BAG\u0003M!x\u000e]5d\u001d\u0006lWMV1mS\u0012\fGo\u001c:!\u0011!\tI\n\u0001b\u0001\n\u0013i\u0017a\u00057pO\u001acWo\u001d5J]R,'O^1m\u001b\u0006\u0004\bbBAO\u0001\u0001\u0006IA\\\u0001\u0015Y><g\t\\;tQ&sG/\u001a:wC2l\u0015\r\u001d\u0011\t\u0013\u0005\u0005\u0006A1A\u0005\n\u0005\r\u0016a\u00057pOJ+G/\u001a8uS>t7+\u001b>f\u001b\u0006\u0004XCAAS!\u0011y'\u000f\u001e\u001e\t\u0011\u0005%\u0006\u0001)A\u0005\u0003K\u000bA\u0003\\8h%\u0016$XM\u001c;j_:\u001c\u0016N_3NCB\u0004\u0003\"CAW\u0001\t\u0007I\u0011BAR\u0003Eawn\u001a*fi\u0016tG/[8o\u001bNl\u0015\r\u001d\u0005\t\u0003c\u0003\u0001\u0015!\u0003\u0002&\u0006\u0011Bn\\4SKR,g\u000e^5p]6\u001bX*\u00199!\u0011%\t)\f\u0001b\u0001\n\u0013\t\u0019+\u0001\u0007m_\u001e\u0014v\u000e\u001c7Ng6\u000b\u0007\u000f\u0003\u0005\u0002:\u0002\u0001\u000b\u0011BAS\u00035awn\u001a*pY2l5/T1qA!I\u0011Q\u0018\u0001C\u0002\u0013%\u0011qX\u0001\u0005Y><7/\u0006\u0002\u0002BB1\u0001#a1u\u0003\u000fL1!!2\u0012\u0005\u0011\u0001vn\u001c7\u0011\rA\t\u0019MZAe!\r\u0001\u00161Z\u0005\u0004\u0003\u001b\u0014!a\u0001'pO\"A\u0011\u0011\u001b\u0001!\u0002\u0013\t\t-A\u0003m_\u001e\u001c\b\u0005C\u0005\u0002V\u0002\u0011\r\u0011\"\u0001\u0002X\u000691/\u001e2ESJ\u001cXCAAm!\u00111\u00121\\.\n\u0007\u0005uwCA\u0003BeJ\f\u0017\u0010\u0003\u0005\u0002b\u0002\u0001\u000b\u0011BAm\u0003!\u0019XO\u0019#jeN\u0004saBAs\u0001!\u0015\u0015q]\u0001\n'R|\u0007/Q2u_J\u0004B!!;\u0002l6\t\u0001A\u0002\u0006\u0002n\u0002!\t\u0011!EC\u0003_\u0014\u0011b\u0015;pa\u0006\u001bGo\u001c:\u0014\r\u0005-x!FAy!\r1\u00121_\u0005\u0004\u0003k<\"a\u0002)s_\u0012,8\r\u001e\u0005\b\u001b\u0006-H\u0011AA})\t\t9\u000fC\u0006\u0002~\u0006-H\u0011!A\u0005F\u0005}\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t\u0005\u0001c\u0001\u0005\u0003\u0004%\u0011\u00110\u0003\u0005\f\u0005\u000f\tY\u000f\"A\u0001\n\u0003\u0012I!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u0003A!B!\u0004\u0002l\u0012\u0005\t\u0011\"\u0011f\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011-\u0011\t\"a;\u0005\u0002\u0003%\tEa\u0005\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!Q\u0003B\u000e!\r1\"qC\u0005\u0004\u000539\"aA!os\"I\u0011Q\tB\b\u0003\u0003\u0005\rA\u001a\u0005\f\u0005?\tY\u000f\"A\u0001\n\u0003\u0012\t#\u0001\u0005dC:,\u0015/^1m)\rI%1\u0005\u0005\u000b\u0003\u000b\u0012i\"!AA\u0002\tU\u0001b\u0003B\u0014\u0003W$\t\u0011!C\t\u0005S\t1B]3bIJ+7o\u001c7wKR\tq\u0001\u000b\u0003\u0002l\n5\u0002c\u0001\f\u00030%\u0019!\u0011G\f\u0003\u0019M,'/[1mSj\f'\r\\3\t\u000f\tU\u0002\u0001\"\u0003\u00038\u0005Aq-\u001a;Ng6\u000b\u0007\u000f\u0006\u0003\u0002&\ne\u0002b\u0002B\u001e\u0005g\u0001\rA\\\u0001\tQ>,(o]'ba\"9!q\b\u0001\u0005\u0002\t\u0005\u0013aB:uCJ$X\u000f\u001d\u000b\u0003\u0003{AqA!\u0012\u0001\t\u0013\u0011\t%\u0001\u0007bo\u0006LGo\u0015;beR,\b\u000fC\u0004\u0003J\u0001!IAa\u0013\u0002)I,w-[:uKJtUm\u001e+pa&\u001c\u0017J\u001c.L)\u0011\tiD!\u0014\t\u000f\t=#q\ta\u0001i\u0006)Ao\u001c9jG\"9!1\u000b\u0001\u0005\n\tU\u0013!C2sK\u0006$X\rT8h)\u0019\tIMa\u0016\u0003Z!9!q\nB)\u0001\u0004!\bb\u0002B.\u0005#\u0002\rAZ\u0001\na\u0006\u0014H/\u001b;j_:DqAa\u0018\u0001\t\u0013\u0011\t'\u0001\u0006hKRdun\u001a)p_2$b!a2\u0003d\t\u0015\u0004b\u0002B(\u0005;\u0002\r\u0001\u001e\u0005\b\u00057\u0012i\u00061\u0001g\u0011\u001d\u0011I\u0007\u0001C\u0001\u0005W\nQc\u00195p_N,'+\u00198e_6\u0004\u0016M\u001d;ji&|g\u000eF\u0002g\u0005[BqAa\u0014\u0003h\u0001\u0007A\u000fC\u0004\u0003r\u0001!\tAa\u001d\u0002\u0015\u001d,Go\u00144gg\u0016$8\u000f\u0006\u0003\u0003v\t]\u0004\u0003\u0002\f\u0002\\jB\u0001B!\u001f\u0003p\u0001\u0007!1P\u0001\u000e_\u001a47/\u001a;SKF,Xm\u001d;\u0011\t\tu$1Q\u0007\u0003\u0005\u007fR1A!!\u0005\u0003\r\t\u0007/[\u0005\u0005\u0005\u000b\u0013yHA\u0007PM\u001a\u001cX\r\u001e*fcV,7\u000f\u001e\u0005\b\u0005\u0013\u0003A\u0011\u0001BF\u0003\u00199W\r\u001e'pOR1\u0011\u0011\u001aBG\u0005\u001fCqAa\u0014\u0003\b\u0002\u0007A\u000fC\u0004\u0003\\\t\u001d\u0005\u0019\u00014\t\u000f\tM\u0005\u0001\"\u0001\u0003\u0016\u0006qq-\u001a;Pe\u000e\u0013X-\u0019;f\u0019><GCBAe\u0005/\u0013I\nC\u0004\u0003P\tE\u0005\u0019\u0001;\t\u000f\tm#\u0011\u0013a\u0001M\"9!Q\u0014\u0001\u0005\n\t}\u0015A\u00043fY\u0016$XmU3h[\u0016tGo\u001d\u000b\u0006M\n\u0005&1\u0015\u0005\b\u0007\tm\u0005\u0019AAe\u0011!\u0011)Ka'A\u0002\t\u001d\u0016\u0001C:fO6,g\u000e^:\u0011\u000b=\u0014IK!,\n\u0007\t-\u0006OA\u0002TKF\u00042\u0001\u0015BX\u0013\r\u0011\tL\u0001\u0002\u000b\u0019><7+Z4nK:$\bb\u0002B[\u0001\u0011%!qW\u0001\u0017G2,\u0017M\\;q\u000bb\u0004\u0018N]3e'\u0016<W.\u001a8ugR\u0019aM!/\t\u000f\r\u0011\u0019\f1\u0001\u0002J\"9!Q\u0018\u0001\u0005\n\t}\u0016!H2mK\u0006tW\u000f]*fO6,g\u000e^:U_6\u000b\u0017N\u001c;bS:\u001c\u0016N_3\u0015\u0007\u0019\u0014\t\rC\u0004\u0004\u0005w\u0003\r!!3\t\u000f\t\u0015\u0007\u0001\"\u0001\u0003B\u0005Y1\r\\3b]V\u0004Hj\\4t\u0011\u001d\u0011I\r\u0001C\u0001\u0005\u0003\nQa\u00197pg\u0016DqA!4\u0001\t\u0013\u0011y-\u0001\bhKRdunZ%uKJ\fGo\u001c:\u0015\u0005\tE\u0007#B8\u0003T\u0006%\u0017b\u0001Bka\nA\u0011\n^3sCR|'\u000fC\u0004\u0003Z\u0002!IA!\u0011\u0002\u0019\u0019dWo\u001d5BY2dunZ:\t\u000f\tu\u0007\u0001\"\u0001\u0003`\u0006aq-\u001a;BY2$v\u000e]5dgR\u0011!\u0011\u001d\t\u0005_\nMG\u000fC\u0004\u0003f\u0002!\tAa:\u0002+\u001d,G\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|gn]'baR\ta\u000eK\u0002\u0001\u0005W\u00042\u0001\u0005Bw\u0013\r\u0011y/\u0005\u0002\u000bi\"\u0014X-\u00193tC\u001a,\u0007")
public class LogManager
implements Logging,
ScalaObject {
    private final KafkaConfig config;
    private final KafkaScheduler scheduler;
    private final Time kafka$log$LogManager$$time;
    private final long logRollDefaultIntervalMs;
    private final long logCleanupIntervalMs;
    private final long logCleanupDefaultAgeMs;
    public final boolean kafka$log$LogManager$$needRecovery;
    private final File logDir;
    private final int kafka$log$LogManager$$numPartitions;
    private final Map kafka$log$LogManager$$logFileSizeMap;
    private final int kafka$log$LogManager$$flushInterval;
    private final Map kafka$log$LogManager$$topicPartitionsMap;
    private final Object logCreationLock;
    private final Random random;
    private KafkaZooKeeper kafka$log$LogManager$$kafkaZookeeper;
    private Actor zkActor;
    private final CountDownLatch startupLatch;
    private final KafkaScheduler logFlusherScheduler;
    private final TopicNameValidator topicNameValidator;
    private final Map kafka$log$LogManager$$logFlushIntervalMap;
    private final Map<String, Long> logRetentionSizeMap;
    private final Map<String, Long> logRetentionMsMap;
    private final Map kafka$log$LogManager$$logRollMsMap;
    private final Pool kafka$log$LogManager$$logs;
    private final File[] subDirs;
    private /* synthetic */ LogManager$StopActor$ StopActor$module;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        LogManager logManager = this;
        synchronized (logManager) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public final Time kafka$log$LogManager$$time() {
        return this.kafka$log$LogManager$$time;
    }

    public long logRollDefaultIntervalMs() {
        return this.logRollDefaultIntervalMs;
    }

    public long logCleanupIntervalMs() {
        return this.logCleanupIntervalMs;
    }

    public long logCleanupDefaultAgeMs() {
        return this.logCleanupDefaultAgeMs;
    }

    public File logDir() {
        return this.logDir;
    }

    public final int kafka$log$LogManager$$numPartitions() {
        return this.kafka$log$LogManager$$numPartitions;
    }

    public final Map kafka$log$LogManager$$logFileSizeMap() {
        return this.kafka$log$LogManager$$logFileSizeMap;
    }

    public final int kafka$log$LogManager$$flushInterval() {
        return this.kafka$log$LogManager$$flushInterval;
    }

    public final Map kafka$log$LogManager$$topicPartitionsMap() {
        return this.kafka$log$LogManager$$topicPartitionsMap;
    }

    private Object logCreationLock() {
        return this.logCreationLock;
    }

    private Random random() {
        return this.random;
    }

    public final KafkaZooKeeper kafka$log$LogManager$$kafkaZookeeper() {
        return this.kafka$log$LogManager$$kafkaZookeeper;
    }

    private void kafka$log$LogManager$$kafkaZookeeper_$eq(KafkaZooKeeper kafkaZooKeeper) {
        this.kafka$log$LogManager$$kafkaZookeeper = kafkaZooKeeper;
    }

    private Actor zkActor() {
        return this.zkActor;
    }

    private void zkActor_$eq(Actor actor) {
        this.zkActor = actor;
    }

    private CountDownLatch startupLatch() {
        return this.startupLatch;
    }

    private KafkaScheduler logFlusherScheduler() {
        return this.logFlusherScheduler;
    }

    private TopicNameValidator topicNameValidator() {
        return this.topicNameValidator;
    }

    public final Map kafka$log$LogManager$$logFlushIntervalMap() {
        return this.kafka$log$LogManager$$logFlushIntervalMap;
    }

    private Map<String, Long> logRetentionSizeMap() {
        return this.logRetentionSizeMap;
    }

    private Map<String, Long> logRetentionMsMap() {
        return this.logRetentionMsMap;
    }

    public final Map kafka$log$LogManager$$logRollMsMap() {
        return this.kafka$log$LogManager$$logRollMsMap;
    }

    public final Pool kafka$log$LogManager$$logs() {
        return this.kafka$log$LogManager$$logs;
    }

    public File[] subDirs() {
        return this.subDirs;
    }

    public final LogManager$StopActor$ StopActor() {
        if (this.StopActor$module == null) {
            this.StopActor$module = new LogManager$StopActor$(this);
        }
        return this.StopActor$module;
    }

    private Map<String, Long> getMsMap(Map<String, Integer> hoursMap) {
        ObjectRef ret$1 = new ObjectRef(new HashMap());
        hoursMap.foreach(new $anonfun$getMsMap$1(this, ret$1));
        return (HashMap)ret$1.elem;
    }

    public void startup() {
        if (this.config().enableZookeeper()) {
            this.kafka$log$LogManager$$kafkaZookeeper().registerBrokerInZk();
            this.getAllTopics().foreach(new $anonfun$startup$2(this));
            this.startupLatch().countDown();
        }
        this.info((Function0<String>)new $anonfun$startup$3(this));
        this.logFlusherScheduler().scheduleWithRate(new $anonfun$startup$1(this), this.config().flushSchedulerThreadRate(), this.config().flushSchedulerThreadRate());
    }

    private void awaitStartup() {
        if (this.config().enableZookeeper()) {
            this.startupLatch().await();
        }
    }

    private void registerNewTopicInZK(String topic) {
        if (this.config().enableZookeeper()) {
            this.zkActor().$bang((Object)topic);
        }
    }

    private Log createLog(String topic, int partition2) {
        Object object = this.logCreationLock();
        synchronized (object) {
            File d = new File(this.logDir(), new StringBuilder().append((Object)topic).append((Object)"-").append(BoxesRunTime.boxToInteger(partition2)).toString());
            d.mkdirs();
            long rollIntervalMs = BoxesRunTime.unboxToLong(this.kafka$log$LogManager$$logRollMsMap().get(topic).getOrElse(new $anonfun$4(this)));
            int maxLogFileSize = BoxesRunTime.unboxToInt(this.kafka$log$LogManager$$logFileSizeMap().get(topic).getOrElse(new $anonfun$5(this)));
            Log log2 = new Log(d, this.kafka$log$LogManager$$time(), maxLogFileSize, this.config().maxMessageSize(), this.kafka$log$LogManager$$flushInterval(), rollIntervalMs, false);
            return log2;
        }
    }

    private Pool<Integer, Log> getLogPool(String topic$1, int partition$1) {
        this.awaitStartup();
        this.topicNameValidator().validate(topic$1);
        if (partition$1 < 0 || partition$1 >= BoxesRunTime.unboxToInt(this.kafka$log$LogManager$$topicPartitionsMap().getOrElse(topic$1, new $anonfun$getLogPool$1(this)))) {
            this.warn((Function0<String>)new $anonfun$getLogPool$2(this, topic$1, partition$1));
            throw new InvalidPartitionException(new StringBuilder().append((Object)"wrong partition ").append(BoxesRunTime.boxToInteger(partition$1)).toString());
        }
        return (Pool)this.kafka$log$LogManager$$logs().get(topic$1);
    }

    public int chooseRandomPartition(String topic) {
        return this.random().nextInt(BoxesRunTime.unboxToInt(this.kafka$log$LogManager$$topicPartitionsMap().getOrElse(topic, new $anonfun$chooseRandomPartition$1(this))));
    }

    public long[] getOffsets(OffsetRequest offsetRequest) {
        Log log2 = this.getLog(offsetRequest.topic(), offsetRequest.partition());
        if (log2 == null) {
            return Log$.MODULE$.getEmptyOffsets(offsetRequest);
        }
        return log2.getOffsetsBefore(offsetRequest);
    }

    public Log getLog(String topic, int partition2) {
        Pool<Integer, Log> parts = this.getLogPool(topic, partition2);
        if (parts == null) {
            return null;
        }
        return parts.get(BoxesRunTime.boxToInteger(partition2));
    }

    public Log getOrCreateLog(String topic$2, int partition$2) {
        Log log2;
        boolean hasNewTopic = false;
        Pool parts = this.getLogPool(topic$2, partition$2);
        if (parts == null) {
            Pool found = this.kafka$log$LogManager$$logs().putIfNotExists(topic$2, new Pool());
            if (found == null) {
                hasNewTopic = true;
            }
            parts = (Pool)this.kafka$log$LogManager$$logs().get(topic$2);
        }
        if ((log2 = parts.get((Integer)BoxesRunTime.boxToInteger(partition$2))) == null) {
            log2 = this.createLog(topic$2, partition$2);
            Log found = parts.putIfNotExists(BoxesRunTime.boxToInteger(partition$2), log2);
            if (found == null) {
                this.info((Function0<String>)new $anonfun$getOrCreateLog$1(this, topic$2, partition$2));
            } else {
                log2.close();
                log2 = found;
            }
        }
        if (hasNewTopic) {
            this.registerNewTopicInZK(topic$2);
        }
        return log2;
    }

    private int deleteSegments(Log log$2, Seq<LogSegment> segments) {
        IntRef total$1 = new IntRef(0);
        segments.foreach(new $anonfun$deleteSegments$1(this, log$2, total$1));
        return total$1.elem;
    }

    private int cleanupExpiredSegments(Log log2) {
        long startMs$1 = this.kafka$log$LogManager$$time().milliseconds();
        String topic = Utils$.MODULE$.getTopicPartition(log2.dir().getName())._1();
        long logCleanupThresholdMS$1 = BoxesRunTime.unboxToLong(this.logRetentionMsMap().get(topic).getOrElse(new $anonfun$6(this)));
        Seq<LogSegment> toBeDeleted = log2.markDeletedWhile(new $anonfun$11(this, startMs$1, logCleanupThresholdMS$1));
        int total = this.deleteSegments(log2, toBeDeleted);
        return total;
    }

    private int cleanupSegmentsToMaintainSize(Log log2) {
        String topic = Utils$.MODULE$.getTopicPartition(log2.dir().getName())._1();
        long maxLogRetentionSize = BoxesRunTime.unboxToLong(this.logRetentionSizeMap().get(topic).getOrElse(new $anonfun$7(this)));
        if (maxLogRetentionSize < 0L || log2.size() < maxLogRetentionSize) {
            return 0;
        }
        LongRef diff$1 = new LongRef(log2.size() - maxLogRetentionSize);
        Seq<LogSegment> toBeDeleted = log2.markDeletedWhile(new $anonfun$12(this, diff$1));
        int total = this.deleteSegments(log2, toBeDeleted);
        return total;
    }

    public void cleanupLogs() {
        this.debug((Function0<String>)new $anonfun$cleanupLogs$1(this));
        Iterator<Log> iter2 = this.getLogIterator();
        IntRef total$2 = new IntRef(0);
        long startMs$2 = this.kafka$log$LogManager$$time().milliseconds();
        while (iter2.hasNext()) {
            Log log$3 = iter2.next();
            this.debug((Function0<String>)new $anonfun$cleanupLogs$2(this, log$3));
            total$2.elem += this.cleanupExpiredSegments(log$3) + this.cleanupSegmentsToMaintainSize(log$3);
        }
        this.debug((Function0<String>)new $anonfun$cleanupLogs$3(this, total$2, startMs$2));
    }

    public void close() {
        this.logFlusherScheduler().shutdown();
        Iterator<Log> iter2 = this.getLogIterator();
        while (iter2.hasNext()) {
            iter2.next().close();
        }
        if (this.config().enableZookeeper()) {
            this.zkActor().$bang((Object)this.StopActor());
            this.kafka$log$LogManager$$kafkaZookeeper().close();
        }
    }

    private Iterator<Log> getLogIterator() {
        return new $anon$2(this);
    }

    public final void kafka$log$LogManager$$flushAllLogs() {
        this.debug((Function0<String>)new $anonfun$kafka$log$LogManager$$flushAllLogs$1(this));
        this.getLogIterator().foreach(new $anonfun$kafka$log$LogManager$$flushAllLogs$2(this));
    }

    public Iterator<String> getAllTopics() {
        return this.kafka$log$LogManager$$logs().keys().iterator();
    }

    public Map<String, Integer> getTopicPartitionsMap() {
        return this.kafka$log$LogManager$$topicPartitionsMap();
    }

    public final boolean shouldDelete$1(LogSegment segment, LongRef longRef) {
        boolean bl;
        if (longRef.elem - segment.size() >= 0L) {
            longRef.elem -= segment.size();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public LogManager(KafkaConfig config, KafkaScheduler scheduler, Time time, long logRollDefaultIntervalMs, long logCleanupIntervalMs, long logCleanupDefaultAgeMs, boolean needRecovery) {
        Serializable serializable2;
        this.config = config;
        this.scheduler = scheduler;
        this.kafka$log$LogManager$$time = time;
        this.logRollDefaultIntervalMs = logRollDefaultIntervalMs;
        this.logCleanupIntervalMs = logCleanupIntervalMs;
        this.logCleanupDefaultAgeMs = logCleanupDefaultAgeMs;
        this.kafka$log$LogManager$$needRecovery = needRecovery;
        Logging$class.$init$(this);
        this.logDir = new File(config.logDir());
        this.kafka$log$LogManager$$numPartitions = config.numPartitions();
        this.kafka$log$LogManager$$logFileSizeMap = config.logFileSizeMap();
        this.kafka$log$LogManager$$flushInterval = config.flushInterval();
        this.kafka$log$LogManager$$topicPartitionsMap = config.topicPartitionsMap();
        this.logCreationLock = new Object();
        this.random = new Random();
        this.kafka$log$LogManager$$kafkaZookeeper = null;
        this.zkActor = null;
        this.startupLatch = config.enableZookeeper() ? new CountDownLatch(1) : null;
        this.logFlusherScheduler = new KafkaScheduler(1, "kafka-logflusher-", false);
        this.topicNameValidator = new TopicNameValidator(config);
        this.kafka$log$LogManager$$logFlushIntervalMap = config.flushIntervalMap();
        this.logRetentionSizeMap = config.logRetentionSizeMap();
        this.logRetentionMsMap = this.getMsMap(config.logRetentionHoursMap());
        this.kafka$log$LogManager$$logRollMsMap = this.getMsMap(config.logRollHoursMap());
        this.kafka$log$LogManager$$logs = new Pool();
        if (this.logDir().exists()) {
            serializable2 = BoxedUnit.UNIT;
        } else {
            this.info((Function0<String>)new $anonfun$8(this));
            serializable2 = BoxesRunTime.boxToBoolean(this.logDir().mkdirs());
        }
        if (this.logDir().isDirectory() && this.logDir().canRead()) {
            BoxedUnit boxedUnit;
            Object object;
            this.subDirs = this.logDir().listFiles();
            if (this.subDirs() != null) {
                Predef$.MODULE$.refArrayOps((Object[])this.subDirs()).foreach(new $anonfun$9(this));
            }
            if (scheduler == null) {
                object = BoxedUnit.UNIT;
            } else {
                this.info((Function0<String>)new $anonfun$10(this));
                object = scheduler.scheduleWithRate(new $anonfun$3(this), 60000L, logCleanupIntervalMs);
            }
            if (config.enableZookeeper()) {
                this.kafka$log$LogManager$$kafkaZookeeper_$eq(new KafkaZooKeeper(config, this));
                this.kafka$log$LogManager$$kafkaZookeeper().startup();
                this.zkActor_$eq(new $anon$1(this));
                boxedUnit = this.zkActor().start();
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)this.logDir().getAbsolutePath()).append((Object)" is not a readable log directory.").toString());
    }
}

