/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import kafka.common.ErrorMapping$;
import kafka.common.InvalidMessageSizeException;
import kafka.common.MessageSizeTooLargeException;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.ScalaObject;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003)\tKH/\u001a\"vM\u001a,'/T3tg\u0006<WmU3u\u0015\t\u0019A!A\u0004nKN\u001c\u0018mZ3\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u00111\u0011\u0002CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005)iUm]:bO\u0016\u001cV\r\u001e\t\u0003\u001bAi\u0011A\u0004\u0006\u0003\u001f\u0011\tQ!\u001e;jYNL!!\u0005\b\u0003\u000f1{wmZ5oOB\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\tY1kY1mC>\u0013'.Z2u\u0011!I\u0002A!b\u0001\n\u0013Q\u0012A\u00022vM\u001a,'/F\u0001\u001c!\ta\u0012%D\u0001\u001e\u0015\tqr$A\u0002oS>T\u0011\u0001I\u0001\u0005U\u00064\u0018-\u0003\u0002#;\tQ!)\u001f;f\u0005V4g-\u001a:\t\u0011\u0011\u0002!\u0011!Q\u0001\nm\tqAY;gM\u0016\u0014\b\u0005\u0003\u0005'\u0001\t\u0015\r\u0011\"\u0003(\u00035Ig.\u001b;jC2|eMZ:fiV\t\u0001\u0006\u0005\u0002\u0014S%\u0011!\u0006\u0006\u0002\u0005\u0019>tw\r\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003)\u00039Ig.\u001b;jC2|eMZ:fi\u0002B\u0001B\f\u0001\u0003\u0006\u0004%IaL\u0001\nKJ\u0014xN]\"pI\u0016,\u0012\u0001\r\t\u0003'EJ!A\r\u000b\u0003\u0007%sG\u000f\u0003\u00055\u0001\t\u0005\t\u0015!\u00031\u0003))'O]8s\u0007>$W\r\t\u0005\u0006m\u0001!\taN\u0001\u0007y%t\u0017\u000e\u001e \u0015\taJ$h\u000f\t\u0003\u0013\u0001AQ!G\u001bA\u0002mAqAJ\u001b\u0011\u0002\u0003\u0007\u0001\u0006C\u0004/kA\u0005\t\u0019\u0001\u0019\t\u000fu\u0002\u0001\u0019!C\u0005O\u0005)2\u000f[1mY><h+\u00197jI\nKH/Z\"pk:$\bbB \u0001\u0001\u0004%I\u0001Q\u0001\u001ag\"\fG\u000e\\8x-\u0006d\u0017\u000e\u001a\"zi\u0016\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0002B\tB\u00111CQ\u0005\u0003\u0007R\u0011A!\u00168ji\"9QIPA\u0001\u0002\u0004A\u0013a\u0001=%c!1q\t\u0001Q!\n!\nac\u001d5bY2|wOV1mS\u0012\u0014\u0015\u0010^3D_VtG\u000f\t\u0005\u0006m\u0001!\t!\u0013\u000b\u0004q){\u0005\"B&I\u0001\u0004a\u0015\u0001E2p[B\u0014Xm]:j_:\u001cu\u000eZ3d!\tIQ*\u0003\u0002O\u0005\t\u00012i\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0005\u0006!\"\u0003\r!U\u0001\t[\u0016\u001c8/Y4fgB\u00191C\u0015+\n\u0005M#\"A\u0003\u001fsKB,\u0017\r^3e}A\u0011\u0011\"V\u0005\u0003-\n\u0011q!T3tg\u0006<W\rC\u00037\u0001\u0011\u0005\u0001\f\u0006\u000293\")\u0001k\u0016a\u0001#\")1\f\u0001C\u0001O\u0005\u0001r-\u001a;J]&$\u0018.\u00197PM\u001a\u001cX\r\u001e\u0005\u0006;\u0002!\tAG\u0001\nO\u0016$()\u001e4gKJDQa\u0018\u0001\u0005\u0002=\nAbZ3u\u000bJ\u0014xN]\"pI\u0016DQ!\u0019\u0001\u0005\u0002\t\f!b]3sS\u0006d\u0017N_3e)\u0005Y\u0002\"\u00023\u0001\t\u00039\u0013A\u0003<bY&$')\u001f;fg\")a\r\u0001C\u0005O\u0005\t2\u000f[1mY><h+\u00197jI\nKH/Z:\t\u000b!\u0004A\u0011A5\u0002\u000f]\u0014\u0018\u000e^3U_R!\u0001F\u001b:u\u0011\u0015Yw\r1\u0001m\u0003\u001d\u0019\u0007.\u00198oK2\u0004\"!\u001c9\u000e\u00039T!a\\\u000f\u0002\u0011\rD\u0017M\u001c8fYNL!!\u001d8\u0003)\u001d\u000bG\u000f[3sS:<')\u001f;f\u0007\"\fgN\\3m\u0011\u0015\u0019x\r1\u0001)\u0003\u0019ygMZ:fi\")Qo\u001aa\u0001Q\u0005!1/\u001b>f\u0011\u00159\b\u0001\"\u0011y\u0003!IG/\u001a:bi>\u0014X#A=\u0011\u000bi\f)!a\u0003\u000f\u0007m\f\tA\u0004\u0002}\u007f6\tQP\u0003\u0002\u007f\r\u00051AH]8pizJ\u0011!F\u0005\u0004\u0003\u0007!\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\tIA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\t\u0019\u0001\u0006\t\u0004\u0013\u00055\u0011bAA\b\u0005\t\u0001R*Z:tC\u001e,\u0017I\u001c3PM\u001a\u001cX\r\u001e\u0005\u0007\u0003'\u0001A\u0011\u0001=\u0002\u001fMD\u0017\r\u001c7po&#XM]1u_JDq!a\u0006\u0001\t\u0003\tI\"A\twKJLg-_'fgN\fw-Z*ju\u0016$2!QA\u000e\u0011\u001d\ti\"!\u0006A\u0002A\na\"\\1y\u001b\u0016\u001c8/Y4f'&TX\rC\u0004\u0002\"\u0001!I!a\t\u0002!%tG/\u001a:oC2LE/\u001a:bi>\u0014HcA=\u0002&!Q\u0011qEA\u0010!\u0003\u0005\r!!\u000b\u0002\u0013%\u001c8\u000b[1mY><\bcA\n\u0002,%\u0019\u0011Q\u0006\u000b\u0003\u000f\t{w\u000e\\3b]\"1\u0011\u0011\u0007\u0001\u0005\u0002\u001d\n1b]5{K&s')\u001f;fg\"9\u0011Q\u0007\u0001\u0005B\u0005]\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005e\u0002\u0003BA\u001e\u0003\u0003r1aEA\u001f\u0013\r\ty\u0004F\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0013Q\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}B\u0003C\u0004\u0002J\u0001!\t%a\u0013\u0002\r\u0015\fX/\u00197t)\u0011\tI#!\u0014\t\u0011\u0005=\u0013q\ta\u0001\u0003#\nQa\u001c;iKJ\u00042aEA*\u0013\r\t)\u0006\u0006\u0002\u0004\u0003:L\bbBA-\u0001\u0011\u0005\u00131L\u0001\tG\u0006tW)];bYR!\u0011\u0011FA/\u0011!\ty%a\u0016A\u0002\u0005E\u0003bBA1\u0001\u0011\u0005\u00131M\u0001\tQ\u0006\u001c\bnQ8eKR\t\u0001\u0007C\u0005\u0002h\u0001\t\n\u0011\"\u0003\u0002j\u0005Q\u0012N\u001c;fe:\fG.\u0013;fe\u0006$xN\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u000e\u0016\u0005\u0003S\tig\u000b\u0002\u0002pA!\u0011\u0011OA>\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0014!C;oG\",7m[3e\u0015\r\tI\bF\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA?\u0003g\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000f%\t\tIAA\u0001\u0012\u000b\t\u0019)\u0001\u000bCsR,')\u001e4gKJlUm]:bO\u0016\u001cV\r\u001e\t\u0004\u0013\u0005\u0015e!C\u0001\u0003\t\u0007\u0005\tRAAD'\u0015\t))!#\u0013!\u0011\tY)!%\u000e\u0005\u00055%bAAH?\u0005!A.\u00198h\u0013\u0011\t\u0019*!$\u0003\r=\u0013'.Z2u\u0011\u001d1\u0014Q\u0011C\u0001\u0003/#\"!a!\t\u0015\u0005m\u0015QQI\u0001\n\u0003\ti*\u0001\bj]&$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005}%f\u0001\u0015\u0002n!Q\u00111UAC#\u0003%\t!!*\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0015\u0016\u0004a\u00055\u0004")
public class ByteBufferMessageSet
extends MessageSet
implements Logging,
ScalaObject {
    private final ByteBuffer kafka$message$ByteBufferMessageSet$$buffer;
    private final long kafka$message$ByteBufferMessageSet$$initialOffset;
    private final int errorCode;
    private long shallowValidByteCount;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final int init$default$3() {
        return ByteBufferMessageSet$.MODULE$.init$default$3();
    }

    public static final long init$default$2() {
        return ByteBufferMessageSet$.MODULE$.init$default$2();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ByteBufferMessageSet byteBufferMessageSet = this;
        synchronized (byteBufferMessageSet) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public final /* synthetic */ boolean kafka$message$ByteBufferMessageSet$$internalIterator$default$1() {
        return false;
    }

    public final ByteBuffer kafka$message$ByteBufferMessageSet$$buffer() {
        return this.kafka$message$ByteBufferMessageSet$$buffer;
    }

    public final long kafka$message$ByteBufferMessageSet$$initialOffset() {
        return this.kafka$message$ByteBufferMessageSet$$initialOffset;
    }

    private int errorCode() {
        return this.errorCode;
    }

    private long shallowValidByteCount() {
        return this.shallowValidByteCount;
    }

    private void shallowValidByteCount_$eq(long l) {
        this.shallowValidByteCount = l;
    }

    public ByteBufferMessageSet(CompressionCodec compressionCodec, Seq<Message> messages) {
        this(MessageSet$.MODULE$.createByteBuffer(compressionCodec, messages), 0L, ErrorMapping$.MODULE$.NoError());
    }

    public ByteBufferMessageSet(Seq<Message> messages) {
        this(NoCompressionCodec$.MODULE$, messages);
    }

    public long getInitialOffset() {
        return this.kafka$message$ByteBufferMessageSet$$initialOffset();
    }

    public ByteBuffer getBuffer() {
        return this.kafka$message$ByteBufferMessageSet$$buffer();
    }

    public int getErrorCode() {
        return this.errorCode();
    }

    public ByteBuffer serialized() {
        return this.kafka$message$ByteBufferMessageSet$$buffer();
    }

    public long validBytes() {
        return this.shallowValidBytes();
    }

    private long shallowValidBytes() {
        if (this.shallowValidByteCount() < 0L) {
            Iterator iter2 = this.kafka$message$ByteBufferMessageSet$$internalIterator(true);
            while (iter2.hasNext()) {
                MessageAndOffset messageAndOffset = (MessageAndOffset)iter2.next();
                this.shallowValidByteCount_$eq(messageAndOffset.offset());
            }
        }
        return this.shallowValidByteCount() < this.kafka$message$ByteBufferMessageSet$$initialOffset() ? 0L : this.shallowValidByteCount() - this.kafka$message$ByteBufferMessageSet$$initialOffset();
    }

    @Override
    public long writeTo(GatheringByteChannel channel, long offset, long size2) {
        this.kafka$message$ByteBufferMessageSet$$buffer().mark();
        int written = channel.write(this.kafka$message$ByteBufferMessageSet$$buffer());
        this.kafka$message$ByteBufferMessageSet$$buffer().reset();
        return written;
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return this.kafka$message$ByteBufferMessageSet$$internalIterator(this.kafka$message$ByteBufferMessageSet$$internalIterator$default$1());
    }

    public Iterator<MessageAndOffset> shallowIterator() {
        return this.kafka$message$ByteBufferMessageSet$$internalIterator(true);
    }

    public void verifyMessageSize(int maxMessageSize) {
        Iterator shallowIter = this.kafka$message$ByteBufferMessageSet$$internalIterator(true);
        while (shallowIter.hasNext()) {
            MessageAndOffset messageAndOffset = (MessageAndOffset)shallowIter.next();
            int payloadSize = messageAndOffset.message().payloadSize();
            if (payloadSize <= maxMessageSize) continue;
            throw new MessageSizeTooLargeException(new StringBuilder().append((Object)"payload size of ").append(BoxesRunTime.boxToInteger(payloadSize)).append((Object)" larger than ").append(BoxesRunTime.boxToInteger(maxMessageSize)).toString());
        }
    }

    public final Iterator kafka$message$ByteBufferMessageSet$$internalIterator(boolean isShallow$1) {
        ErrorMapping$.MODULE$.maybeThrowException(this.errorCode());
        return new $anon$1(this, isShallow$1);
    }

    @Override
    public long sizeInBytes() {
        return this.kafka$message$ByteBufferMessageSet$$buffer().limit();
    }

    @Override
    public String toString() {
        StringBuilder builder$1 = new StringBuilder();
        builder$1.append("ByteBufferMessageSet(");
        this.foreach(new $anonfun$toString$1(this, builder$1));
        builder$1.append(")");
        return builder$1.toString();
    }

    @Override
    public boolean equals(Object other) {
        ByteBufferMessageSet byteBufferMessageSet;
        ByteBufferMessageSet that;
        Object object = other;
        return object instanceof ByteBufferMessageSet ? (that = (byteBufferMessageSet = (ByteBufferMessageSet)object)).canEqual(this) && this.errorCode() == that.errorCode() && this.kafka$message$ByteBufferMessageSet$$buffer().equals(that.kafka$message$ByteBufferMessageSet$$buffer()) && this.kafka$message$ByteBufferMessageSet$$initialOffset() == that.kafka$message$ByteBufferMessageSet$$initialOffset() : false;
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof ByteBufferMessageSet;
    }

    public int hashCode() {
        return 31 + 17 * this.errorCode() + this.kafka$message$ByteBufferMessageSet$$buffer().hashCode() + ((Object)BoxesRunTime.boxToLong(this.kafka$message$ByteBufferMessageSet$$initialOffset())).hashCode();
    }

    public ByteBufferMessageSet(ByteBuffer buffer, long initialOffset, int errorCode) {
        this.kafka$message$ByteBufferMessageSet$$buffer = buffer;
        this.kafka$message$ByteBufferMessageSet$$initialOffset = initialOffset;
        this.errorCode = errorCode;
        Logging$class.$init$(this);
        this.shallowValidByteCount = -1L;
        if (this.sizeInBytes() > Integer.MAX_VALUE) {
            throw new InvalidMessageSizeException(new StringBuilder().append((Object)"Message set cannot be larger than ").append(BoxesRunTime.boxToInteger(Integer.MAX_VALUE)).toString());
        }
    }
}

