/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Broker;
import kafka.common.InvalidPartitionException;
import kafka.common.NoBrokersForPartitionException;
import kafka.producer.BrokerPartitionInfo;
import kafka.producer.ConfigBrokerPartitionInfo;
import kafka.producer.DefaultPartitioner;
import kafka.producer.Partitioner;
import kafka.producer.Producer$;
import kafka.producer.Producer$$anonfun$kafka$producer$Producer$;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerData;
import kafka.producer.ProducerPool;
import kafka.producer.ZKBrokerPartitionInfo;
import kafka.producer.async.CallbackHandler;
import kafka.producer.async.EventHandler;
import kafka.serializer.Encoder;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKConfig;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0002\u0015:pIV\u001cWM\u001d\u0006\u0003\u0007\u0011\t\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001Qc\u0001\u0005+sM!\u0001!C\t\u0018!\tQq\"D\u0001\f\u0015\taQ\"\u0001\u0003mC:<'\"\u0001\b\u0002\t)\fg/Y\u0005\u0003!-\u0011aa\u00142kK\u000e$\bC\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t12CA\u0004M_\u001e<\u0017N\\4\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t=\u0001\u0011\t\u0011)A\u0005?\u000511m\u001c8gS\u001e\u0004\"\u0001I\u0011\u000e\u0003\tI!A\t\u0002\u0003\u001dA\u0013x\u000eZ;dKJ\u001cuN\u001c4jO\"AA\u0005\u0001B\u0001B\u0003%Q%A\u0006qCJ$\u0018\u000e^5p]\u0016\u0014\bc\u0001\u0011'Q%\u0011qE\u0001\u0002\f!\u0006\u0014H/\u001b;j_:,'\u000f\u0005\u0002*U1\u0001A\u0001C\u0016\u0001\t\u0003\u0005)\u0019\u0001\u0017\u0003\u0003-\u000b\"!\f\u0019\u0011\u0005aq\u0013BA\u0018\u001a\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001G\u0019\n\u0005IJ\"aA!os\"AA\u0007\u0001B\u0001B\u0003%Q'\u0001\u0007qe>$WoY3s!>|G\u000eE\u0002!maJ!a\u000e\u0002\u0003\u0019A\u0013x\u000eZ;dKJ\u0004vn\u001c7\u0011\u0005%JD\u0001\u0003\u001e\u0001\t\u0003\u0005)\u0019\u0001\u0017\u0003\u0003YC\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!P\u0001\u0015a>\u0004X\u000f\\1uKB\u0013x\u000eZ;dKJ\u0004vn\u001c7\u0011\u0005aq\u0014BA \u001a\u0005\u001d\u0011un\u001c7fC:D\u0001\"\u0011\u0001\u0003\u0002\u0004%IAQ\u0001\u0014EJ|7.\u001a:QCJ$\u0018\u000e^5p]&sgm\\\u000b\u0002\u0007B\u0011\u0001\u0005R\u0005\u0003\u000b\n\u00111C\u0011:pW\u0016\u0014\b+\u0019:uSRLwN\\%oM>D\u0001b\u0012\u0001\u0003\u0002\u0004%I\u0001S\u0001\u0018EJ|7.\u001a:QCJ$\u0018\u000e^5p]&sgm\\0%KF$\"!\u0013'\u0011\u0005aQ\u0015BA&\u001a\u0005\u0011)f.\u001b;\t\u000f53\u0015\u0011!a\u0001\u0007\u0006\u0019\u0001\u0010J\u0019\t\u0011=\u0003!\u0011!Q!\n\r\u000bAC\u0019:pW\u0016\u0014\b+\u0019:uSRLwN\\%oM>\u0004\u0003\"B)\u0001\t\u0003\u0011\u0016A\u0002\u001fj]&$h\b\u0006\u0004T)V3v\u000b\u0017\t\u0005A\u0001A\u0003\bC\u0003\u001f!\u0002\u0007q\u0004C\u0003%!\u0002\u0007Q\u0005C\u00035!\u0002\u0007Q\u0007C\u0003=!\u0002\u0007Q\bC\u0003B!\u0002\u00071\tC\u0004[\u0001\t\u0007I\u0011B.\u0002\u0017!\f7o\u00155vi\u0012|wO\\\u000b\u00029B\u0011Q\fZ\u0007\u0002=*\u0011q\fY\u0001\u0007CR|W.[2\u000b\u0005\u0005\u0014\u0017AC2p]\u000e,(O]3oi*\u00111-D\u0001\u0005kRLG.\u0003\u0002f=\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:Daa\u001a\u0001!\u0002\u0013a\u0016\u0001\u00045bgNCW\u000f\u001e3po:\u0004\u0003bB5\u0001\u0005\u0004%IA[\u0001\u0007e\u0006tGm\\7\u0016\u0003-\u0004\"\u0001\\7\u000e\u0003\tL!A\u001c2\u0003\rI\u000bg\u000eZ8n\u0011\u0019\u0001\b\u0001)A\u0005W\u00069!/\u00198e_6\u0004\u0003b\u0002:\u0001\u0005\u0004%Ia]\u0001\nu.,e.\u00192mK\u0012,\u0012!\u0010\u0005\u0007k\u0002\u0001\u000b\u0011B\u001f\u0002\u0015i\\WI\\1cY\u0016$\u0007\u0005C\u0003R\u0001\u0011\u0005q\u000f\u0006\u0002Tq\")aD\u001ea\u0001?!)\u0011\u000b\u0001C\u0001uRI1k\u001f?\u0002\n\u0005e\u00111\u0005\u0005\u0006=e\u0004\ra\b\u0005\u0006{f\u0004\rA`\u0001\bK:\u001cw\u000eZ3s!\u0011y\u0018Q\u0001\u001d\u000e\u0005\u0005\u0005!bAA\u0002\t\u0005Q1/\u001a:jC2L'0\u001a:\n\t\u0005\u001d\u0011\u0011\u0001\u0002\b\u000b:\u001cw\u000eZ3s\u0011\u001d\tY!\u001fa\u0001\u0003\u001b\tA\"\u001a<f]RD\u0015M\u001c3mKJ\u0004R!a\u0004\u0002\u0016aj!!!\u0005\u000b\u0007\u0005M!!A\u0003bgft7-\u0003\u0003\u0002\u0018\u0005E!\u0001D#wK:$\b*\u00198eY\u0016\u0014\bbBA\u000es\u0002\u0007\u0011QD\u0001\u000bG\n\\\u0007*\u00198eY\u0016\u0014\b#BA\b\u0003?A\u0014\u0002BA\u0011\u0003#\u0011qbQ1mY\n\f7m\u001b%b]\u0012dWM\u001d\u0005\u0006Ie\u0004\r!\n\u0005\b\u0003O\u0001A\u0011AA\u0015\u0003\u0011\u0019XM\u001c3\u0015\u0007%\u000bY\u0003\u0003\u0005\u0002.\u0005\u0015\u0002\u0019AA\u0018\u00031\u0001(o\u001c3vG\u0016\u0014H)\u0019;b!\u0015A\u0012\u0011GA\u001b\u0013\r\t\u0019$\u0007\u0002\u000byI,\u0007/Z1uK\u0012t\u0004#\u0002\u0011\u00028!B\u0014bAA\u001d\u0005\ta\u0001K]8ek\u000e,'\u000fR1uC\"9\u0011Q\b\u0001\u0005\n\u0005}\u0012A\u0002>l'\u0016tG\rF\u0002J\u0003\u0003B\u0001\"!\f\u0002<\u0001\u0007\u0011q\u0006\u0005\b\u0003\u000b\u0002A\u0011BA$\u0003)\u0019wN\u001c4jON+g\u000e\u001a\u000b\u0004\u0013\u0006%\u0003\u0002CA\u0017\u0003\u0007\u0002\r!a\f\t\u000f\u00055\u0003\u0001\"\u0003\u0002P\u0005Ar-\u001a;QCJ$\u0018\u000e^5p]2K7\u000f\u001e$peR{\u0007/[2\u0015\t\u0005E\u0013Q\u000f\t\u0007\u0003'\n\u0019'!\u001b\u000f\t\u0005U\u0013q\f\b\u0005\u0003/\ni&\u0004\u0002\u0002Z)\u0019\u00111\f\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012bAA13\u00059\u0001/Y2lC\u001e,\u0017\u0002BA3\u0003O\u00121aU3r\u0015\r\t\t'\u0007\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011q\u000e\u0003\u0002\u000f\rdWo\u001d;fe&!\u00111OA7\u0005%\u0001\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002x\u0005-\u0003\u0019AA\u001b\u0003\t\u0001H\rC\u0004\u0002|\u0001!I!! \u0002\u0019\u001d,G\u000fU1si&$\u0018n\u001c8\u0015\r\u0005}\u0014QQAE!\rA\u0012\u0011Q\u0005\u0004\u0003\u0007K\"aA%oi\"9\u0011qQA=\u0001\u0004A\u0013aA6fs\"A\u00111RA=\u0001\u0004\ty(A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\b\u0003\u001f\u0003A\u0011BAI\u0003-\u0001(o\u001c3vG\u0016\u00148IY6\u0015\u000f%\u000b\u0019*a&\u0002*\"A\u0011QSAG\u0001\u0004\ty(A\u0002cS\u0012D\u0001\"!'\u0002\u000e\u0002\u0007\u00111T\u0001\u0005Q>\u001cH\u000f\u0005\u0003\u0002\u001e\u0006\rfb\u0001\r\u0002 &\u0019\u0011\u0011U\r\u0002\rA\u0013X\rZ3g\u0013\u0011\t)+a*\u0003\rM#(/\u001b8h\u0015\r\t\t+\u0007\u0005\t\u0003W\u000bi\t1\u0001\u0002\u0000\u0005!\u0001o\u001c:u\u0011\u001d\ty\u000b\u0001C\u0001\u0003c\u000bQa\u00197pg\u0016$\u0012!\u0013")
public class Producer<K, V>
implements Logging,
ScalaObject {
    public final ProducerConfig kafka$producer$Producer$$config;
    private final Partitioner<K> partitioner;
    public final ProducerPool kafka$producer$Producer$$producerPool;
    private final boolean populateProducerPool;
    private BrokerPartitionInfo kafka$producer$Producer$$brokerPartitionInfo;
    private final AtomicBoolean hasShutdown;
    private final Random kafka$producer$Producer$$random;
    private final boolean zkEnabled;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Producer producer = this;
        synchronized (producer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public final BrokerPartitionInfo kafka$producer$Producer$$brokerPartitionInfo() {
        return this.kafka$producer$Producer$$brokerPartitionInfo;
    }

    private void kafka$producer$Producer$$brokerPartitionInfo_$eq(BrokerPartitionInfo brokerPartitionInfo) {
        this.kafka$producer$Producer$$brokerPartitionInfo = brokerPartitionInfo;
    }

    private AtomicBoolean hasShutdown() {
        return this.hasShutdown;
    }

    public final Random kafka$producer$Producer$$random() {
        return this.kafka$producer$Producer$$random;
    }

    private boolean zkEnabled() {
        return this.zkEnabled;
    }

    public Producer(ProducerConfig config) {
        this(config, (Partitioner)Utils$.MODULE$.getObject(config.partitionerClass()), new ProducerPool(config, (Encoder)Utils$.MODULE$.getObject(config.serializerClass())), true, null);
    }

    public Producer(ProducerConfig config, Encoder<V> encoder2, EventHandler<V> eventHandler, CallbackHandler<V> cbkHandler, Partitioner<K> partitioner) {
        this(config, partitioner == null ? new DefaultPartitioner() : partitioner, new ProducerPool<V>(config, encoder2, eventHandler, cbkHandler), true, null);
    }

    public void send(Seq<ProducerData<K, V>> producerData) {
        boolean bl;
        block4: {
            block3: {
                block2: {
                    bl = this.zkEnabled();
                    if (!bl) break block2;
                    this.zkSend(producerData);
                    break block3;
                }
                if (bl) break block4;
                this.configSend(producerData);
            }
            return;
        }
        throw new MatchError(BoxesRunTime.boxToBoolean(bl));
    }

    private void zkSend(Seq<ProducerData<K, V>> producerData) {
        Seq producerPoolRequests = producerData.map(new $anonfun$3(this), Seq$.MODULE$.canBuildFrom());
        this.kafka$producer$Producer$$producerPool.send(producerPoolRequests);
    }

    private void configSend(Seq<ProducerData<K, V>> producerData) {
        Seq producerPoolRequests = producerData.map(new $anonfun$4(this), Seq$.MODULE$.canBuildFrom());
        this.kafka$producer$Producer$$producerPool.send(producerPoolRequests);
    }

    /*
     * WARNING - void declaration
     */
    public final Seq kafka$producer$Producer$$getPartitionListForTopic(ProducerData pd$1) {
        void var2_2;
        this.debug((Function0<String>)new $anonfun$kafka$producer$Producer$$getPartitionListForTopic$1(this, pd$1));
        Seq topicPartitionsList$1 = this.kafka$producer$Producer$$brokerPartitionInfo().getBrokerPartitionInfo(pd$1.getTopic()).toSeq();
        this.debug((Function0<String>)new $anonfun$kafka$producer$Producer$$getPartitionListForTopic$2(this, pd$1, topicPartitionsList$1));
        int totalNumPartitions = topicPartitionsList$1.length();
        if (totalNumPartitions == 0) {
            throw new NoBrokersForPartitionException(new StringBuilder().append((Object)"Partition = ").append(pd$1.getKey()).toString());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final int kafka$producer$Producer$$getPartition(Object key, int numPartitions) {
        void var3_3;
        int partition2;
        if (numPartitions <= 0) {
            throw new InvalidPartitionException(new StringBuilder().append((Object)"Invalid number of partitions: ").append(BoxesRunTime.boxToInteger(numPartitions)).append((Object)"\n Valid values are > 0").toString());
        }
        int n = partition2 = key == null ? this.kafka$producer$Producer$$random().nextInt(numPartitions) : this.partitioner.partition(key, numPartitions);
        if (partition2 < 0 || partition2 >= numPartitions) {
            throw new InvalidPartitionException(new StringBuilder().append((Object)"Invalid partition id : ").append(BoxesRunTime.boxToInteger(partition2)).append((Object)"\n Valid values are in the range inclusive [0, ").append(BoxesRunTime.boxToInteger(numPartitions - 1)).append((Object)"]").toString());
        }
        return (int)var3_3;
    }

    public final void kafka$producer$Producer$$producerCbk(int bid, String host, int port) {
        if (this.populateProducerPool) {
            this.kafka$producer$Producer$$producerPool.addProducer(new Broker(bid, host, host, port));
        } else {
            this.debug((Function0<String>)new $anonfun$kafka$producer$Producer$$producerCbk$1(this));
        }
    }

    public void close() {
        boolean canShutdown = this.hasShutdown().compareAndSet(false, true);
        if (canShutdown) {
            this.kafka$producer$Producer$$producerPool.close();
            this.kafka$producer$Producer$$brokerPartitionInfo().close();
        }
    }

    public Producer(ProducerConfig config, Partitioner<K> partitioner, ProducerPool<V> producerPool, boolean populateProducerPool, BrokerPartitionInfo brokerPartitionInfo) {
        this.kafka$producer$Producer$$config = config;
        this.partitioner = partitioner;
        this.kafka$producer$Producer$$producerPool = producerPool;
        this.populateProducerPool = populateProducerPool;
        this.kafka$producer$Producer$$brokerPartitionInfo = brokerPartitionInfo;
        Logging$class.$init$(this);
        this.hasShutdown = new AtomicBoolean(false);
        this.kafka$producer$Producer$$random = new Random();
        this.zkEnabled = Utils$.MODULE$.propertyExists(config.zkConnect());
        if (this.kafka$producer$Producer$$brokerPartitionInfo() == null) {
            boolean bl = this.zkEnabled();
            if (bl) {
                Properties zkProps = new Properties();
                zkProps.put("zk.connect", config.zkConnect());
                zkProps.put("zk.sessiontimeout.ms", ((Object)BoxesRunTime.boxToInteger(config.zkSessionTimeoutMs())).toString());
                zkProps.put("zk.connectiontimeout.ms", ((Object)BoxesRunTime.boxToInteger(config.zkConnectionTimeoutMs())).toString());
                zkProps.put("zk.synctime.ms", ((Object)BoxesRunTime.boxToInteger(config.zkSyncTimeMs())).toString());
                this.kafka$producer$Producer$$brokerPartitionInfo_$eq(new ZKBrokerPartitionInfo(new ZKConfig(zkProps), new $anonfun$1(this)));
            } else if (!bl) {
                this.kafka$producer$Producer$$brokerPartitionInfo_$eq(new ConfigBrokerPartitionInfo(config));
            } else {
                throw new MatchError(BoxesRunTime.boxToBoolean(bl));
            }
        }
        if (populateProducerPool) {
            Map<Integer, Broker> allBrokers = this.kafka$producer$Producer$$brokerPartitionInfo().getAllBrokerInfo();
            allBrokers.foreach(new $anonfun$2(this));
        }
    }
}

