/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Random;
import kafka.api.MultiProducerRequest;
import kafka.api.MultiProducerRequest$;
import kafka.api.ProducerRequest;
import kafka.api.ProducerRequest$;
import kafka.api.RequestKeys$;
import kafka.message.ByteBufferMessageSet;
import kafka.network.BoundedByteBufferSend;
import kafka.producer.SyncProducer$;
import kafka.producer.SyncProducerConfig;
import kafka.producer.SyncProducerStats$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015v!B\u0001\u0003\u0011\u000b9\u0011\u0001D*z]\u000e\u0004&o\u001c3vG\u0016\u0014(BA\u0002\u0005\u0003!\u0001(o\u001c3vG\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019A!B\u0001C\u0001\u0002#\u00151B\u0001\u0007Ts:\u001c\u0007K]8ek\u000e,'oE\u0002\n\u0019Q\u0001\"!\u0004\n\u000e\u00039Q!a\u0004\t\u0002\t1\fgn\u001a\u0006\u0002#\u0005!!.\u0019<b\u0013\t\u0019bB\u0001\u0004PE*,7\r\u001e\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000fC\u0003\u001c\u0013\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f!9a$\u0003b\u0001\n\u0003y\u0012A\u0003*fcV,7\u000f^&fsV\t\u0001\u0005\u0005\u0002\u0016C%\u0011!E\u0006\u0002\u0006'\"|'\u000f\u001e\u0005\u0007I%\u0001\u000b\u0011\u0002\u0011\u0002\u0017I+\u0017/^3ti.+\u0017\u0010\t\u0005\bM%\u0011\r\u0011\"\u0001(\u0003=\u0011\u0018M\u001c3p[\u001e+g.\u001a:bi>\u0014X#\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-\u0002\u0012\u0001B;uS2L!!\f\u0016\u0003\rI\u000bg\u000eZ8n\u0011\u0019y\u0013\u0002)A\u0005Q\u0005\u0001\"/\u00198e_6<UM\\3sCR|'\u000f\t\u0004\t\u0015\t!\t\u0011!A\u0001cM!\u0001\u0007\u0004\u001a\u0015!\t\u0019d'D\u00015\u0015\t)D!A\u0003vi&d7/\u0003\u00028i\t9Aj\\4hS:<\u0007\u0002C\u001d1\u0005\u000b\u0007I\u0011\u0001\u001e\u0002\r\r|gNZ5h+\u0005Y\u0004C\u0001\u0005=\u0013\ti$A\u0001\nTs:\u001c\u0007K]8ek\u000e,'oQ8oM&<\u0007\u0002C 1\u0005\u0003\u0005\u000b\u0011B\u001e\u0002\u000f\r|gNZ5hA!)1\u0004\rC\u0001\u0003R\u0011!i\u0011\t\u0003\u0011ABQ!\u000f!A\u0002mBq!\u0012\u0019C\u0002\u0013%a)A\nNCb\u001cuN\u001c8fGR\u0014\u0015mY6pM\u001al5/F\u0001H!\t)\u0002*\u0003\u0002J-\t\u0019\u0011J\u001c;\t\r-\u0003\u0004\u0015!\u0003H\u0003Qi\u0015\r_\"p]:,7\r\u001e\"bG.|gMZ'tA!9Q\n\ra\u0001\n\u0013q\u0015aB2iC:tW\r\\\u000b\u0002\u001fB\u0011\u0001+V\u0007\u0002#*\u0011!kU\u0001\tG\"\fgN\\3mg*\u0011A\u000bE\u0001\u0004]&|\u0017B\u0001,R\u00055\u0019vnY6fi\u000eC\u0017M\u001c8fY\"9\u0001\f\ra\u0001\n\u0013I\u0016aC2iC:tW\r\\0%KF$\"AW/\u0011\u0005UY\u0016B\u0001/\u0017\u0005\u0011)f.\u001b;\t\u000fy;\u0016\u0011!a\u0001\u001f\u0006\u0019\u0001\u0010J\u0019\t\r\u0001\u0004\u0004\u0015)\u0003P\u0003!\u0019\u0007.\u00198oK2\u0004\u0003b\u000221\u0001\u0004%IAR\u0001\u0011g\u0016tGo\u00148D_:tWm\u0019;j_:Dq\u0001\u001a\u0019A\u0002\u0013%Q-\u0001\u000btK:$xJ\\\"p]:,7\r^5p]~#S-\u001d\u000b\u00035\u001aDqAX2\u0002\u0002\u0003\u0007q\t\u0003\u0004ia\u0001\u0006KaR\u0001\u0012g\u0016tGo\u00148D_:tWm\u0019;j_:\u0004\u0003b\u000261\u0001\u0004%Ia[\u0001\u0013Y\u0006\u001cHoQ8o]\u0016\u001cG/[8o)&lW-F\u0001m!\t)R.\u0003\u0002o-\t1Ai\\;cY\u0016Dq\u0001\u001d\u0019A\u0002\u0013%\u0011/\u0001\fmCN$8i\u001c8oK\u000e$\u0018n\u001c8US6,w\fJ3r)\tQ&\u000fC\u0004__\u0006\u0005\t\u0019\u00017\t\rQ\u0004\u0004\u0015)\u0003m\u0003Ma\u0017m\u001d;D_:tWm\u0019;j_:$\u0016.\\3!\u0011\u001d1\bG1A\u0005\n]\fA\u0001\\8dWV\tA\u0002\u0003\u0004za\u0001\u0006I\u0001D\u0001\u0006Y>\u001c7\u000e\t\u0005\bwB\u0002\r\u0011\"\u0003}\u0003!\u0019\b.\u001e;e_^tW#A?\u0011\u0005Uq\u0018BA@\u0017\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u00011\u0001\u0004%I!!\u0002\u0002\u0019MDW\u000f\u001e3po:|F%Z9\u0015\u0007i\u000b9\u0001\u0003\u0005_\u0003\u0003\t\t\u00111\u0001~\u0011\u001d\tY\u0001\rQ!\nu\f\u0011b\u001d5vi\u0012|wO\u001c\u0011)\t\u0005%\u0011q\u0002\t\u0004+\u0005E\u0011bAA\n-\tAao\u001c7bi&dW\rC\u0004\u0002\u0018A\"I!!\u0007\u0002!Y,'/\u001b4z'\u0016tGMQ;gM\u0016\u0014Hc\u0001.\u0002\u001c!A\u0011QDA\u000b\u0001\u0004\ty\"\u0001\u0004ck\u001a4WM\u001d\t\u0005\u0003C\t\u0019#D\u0001T\u0013\r\t)c\u0015\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bbBA\u0015a\u0011%\u00111F\u0001\u0005g\u0016tG\rF\u0002[\u0003[A\u0001\"!\u000b\u0002(\u0001\u0007\u0011q\u0006\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007\u0003\u0002\u000f9,Go^8sW&!\u0011\u0011HA\u001a\u0005U\u0011u.\u001e8eK\u0012\u0014\u0015\u0010^3Ck\u001a4WM]*f]\u0012Dq!!\u000b1\t\u0003\ti\u0004F\u0004[\u0003\u007f\t\t&!\u0016\t\u0011\u0005\u0005\u00131\ba\u0001\u0003\u0007\nQ\u0001^8qS\u000e\u0004B!!\u0012\u0002L9\u0019Q#a\u0012\n\u0007\u0005%c#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\nyE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u00132\u0002bBA*\u0003w\u0001\raR\u0001\na\u0006\u0014H/\u001b;j_:D\u0001\"a\u0016\u0002<\u0001\u0007\u0011\u0011L\u0001\t[\u0016\u001c8/Y4fgB!\u00111LA1\u001b\t\tiFC\u0002\u0002`\u0011\tq!\\3tg\u0006<W-\u0003\u0003\u0002d\u0005u#\u0001\u0006\"zi\u0016\u0014UO\u001a4fe6+7o]1hKN+G\u000fC\u0004\u0002*A\"\t!a\u001a\u0015\u000bi\u000bI'a\u001b\t\u0011\u0005\u0005\u0013Q\ra\u0001\u0003\u0007B\u0001\"a\u0016\u0002f\u0001\u0007\u0011\u0011\f\u0005\b\u0003_\u0002D\u0011AA9\u0003%iW\u000f\u001c;j'\u0016tG\rF\u0002[\u0003gB\u0001\"!\u001e\u0002n\u0001\u0007\u0011qO\u0001\taJ|G-^2fgB)Q#!\u001f\u0002~%\u0019\u00111\u0010\f\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003S1!a!\u0005\u0003\r\t\u0007/[\u0005\u0005\u0003\u000f\u000b\tIA\bQe>$WoY3s%\u0016\fX/Z:u\u0011\u001d\tY\t\rC\u0001\u0003\u001b\u000bQa\u00197pg\u0016$\u0012A\u0017\u0005\b\u0003#\u0003D\u0011BAG\u0003)!\u0017n]2p]:,7\r\u001e\u0005\b\u0003+\u0003D\u0011BAL\u0003\u001d\u0019wN\u001c8fGR$\u0012a\u0014\u0005\b\u00037\u0003D\u0011BAG\u0003M9W\r^(s\u001b\u0006\\WmQ8o]\u0016\u001cG/[8oQ\r\u0001\u0014q\u0014\t\u0004g\u0005\u0005\u0016bAARi\tQA\u000f\u001b:fC\u0012\u001c\u0018MZ3")
public class SyncProducer
implements Logging,
ScalaObject {
    private final SyncProducerConfig config;
    private final int MaxConnectBackoffMs;
    private SocketChannel kafka$producer$SyncProducer$$channel;
    private int sentOnConnection;
    private double lastConnectionTime;
    private final Object lock;
    private volatile boolean shutdown;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Random randomGenerator() {
        return SyncProducer$.MODULE$.randomGenerator();
    }

    public static final short RequestKey() {
        return SyncProducer$.MODULE$.RequestKey();
    }

    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        SyncProducer syncProducer = this;
        synchronized (syncProducer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public SyncProducerConfig config() {
        return this.config;
    }

    private int MaxConnectBackoffMs() {
        return this.MaxConnectBackoffMs;
    }

    public final SocketChannel kafka$producer$SyncProducer$$channel() {
        return this.kafka$producer$SyncProducer$$channel;
    }

    private void kafka$producer$SyncProducer$$channel_$eq(SocketChannel socketChannel) {
        this.kafka$producer$SyncProducer$$channel = socketChannel;
    }

    private int sentOnConnection() {
        return this.sentOnConnection;
    }

    private void sentOnConnection_$eq(int n) {
        this.sentOnConnection = n;
    }

    private double lastConnectionTime() {
        return this.lastConnectionTime;
    }

    private void lastConnectionTime_$eq(double d) {
        this.lastConnectionTime = d;
    }

    private Object lock() {
        return this.lock;
    }

    private boolean shutdown() {
        return this.shutdown;
    }

    private void shutdown_$eq(boolean bl) {
        this.shutdown = bl;
    }

    private void verifySendBuffer(ByteBuffer buffer$1) {
        if (this.logger().isDebugEnabled()) {
            this.trace((Function0<String>)new $anonfun$verifySendBuffer$1(this, buffer$1));
            short requestTypeId = buffer$1.getShort();
            if (requestTypeId == RequestKeys$.MODULE$.MultiProduce()) {
                try {
                    MultiProducerRequest request = MultiProducerRequest$.MODULE$.readFrom(buffer$1);
                    Predef$.MODULE$.refArrayOps((Object[])request.produces()).foreach(new $anonfun$verifySendBuffer$2(this));
                }
                catch (Throwable throwable) {
                    this.error((Function0<String>)new $anonfun$verifySendBuffer$3(this), (Function0<Throwable>)new $anonfun$verifySendBuffer$4(this, throwable));
                }
            }
        }
    }

    private void send(BoundedByteBufferSend send$1) {
        Object object = this.lock();
        synchronized (object) {
            this.verifySendBuffer(send$1.buffer().slice());
            long startTime = SystemTime$.MODULE$.nanoseconds();
            this.getOrMakeConnection();
            this.liftedTree1$1(send$1);
            this.sentOnConnection_$eq(this.sentOnConnection() + 1);
            if (this.sentOnConnection() >= this.config().reconnectInterval() || this.config().reconnectTimeInterval() >= 0 && (double)System.currentTimeMillis() - this.lastConnectionTime() >= (double)this.config().reconnectTimeInterval()) {
                this.disconnect();
                this.kafka$producer$SyncProducer$$channel_$eq(this.connect());
                this.sentOnConnection_$eq(0);
                this.lastConnectionTime_$eq(System.currentTimeMillis());
            }
            long endTime = SystemTime$.MODULE$.nanoseconds();
            SyncProducerStats$.MODULE$.recordProduceRequest(endTime - startTime);
            return;
        }
    }

    public void send(String topic, int partition2, ByteBufferMessageSet messages) {
        messages.verifyMessageSize(this.config().maxMessageSize());
        int setSize$1 = (int)messages.sizeInBytes();
        this.trace((Function0<String>)new $anonfun$send$1(this, setSize$1));
        this.send(new BoundedByteBufferSend(new ProducerRequest(topic, partition2, messages)));
    }

    public void send(String topic, ByteBufferMessageSet messages) {
        this.send(topic, ProducerRequest$.MODULE$.RandomPartition(), messages);
    }

    public void multiSend(ProducerRequest[] produces) {
        Predef$.MODULE$.refArrayOps((Object[])produces).foreach(new $anonfun$multiSend$1(this));
        long setSize$2 = BoxesRunTime.unboxToLong(Predef$.MODULE$.refArrayOps((Object[])produces).foldLeft(BoxesRunTime.boxToLong(0L), new $anonfun$3(this)));
        this.trace((Function0<String>)new $anonfun$multiSend$2(this, setSize$2));
        this.send(new BoundedByteBufferSend(new MultiProducerRequest(produces)));
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            this.disconnect();
            this.shutdown_$eq(true);
            return;
        }
    }

    private void disconnect() {
        try {
            if (this.kafka$producer$SyncProducer$$channel() != null) {
                this.info((Function0<String>)new $anonfun$disconnect$3(this));
                Utils$.MODULE$.swallow(new $anonfun$disconnect$4(this), new $anonfun$disconnect$1(this));
                Utils$.MODULE$.swallow(new $anonfun$disconnect$5(this), new $anonfun$disconnect$2(this));
                this.kafka$producer$SyncProducer$$channel_$eq(null);
            }
        }
        catch (Exception exception) {
            this.error((Function0<String>)new $anonfun$disconnect$6(this), (Function0<Throwable>)new $anonfun$disconnect$7(this, exception));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private SocketChannel connect() {
        IntRef connectBackoffMs$1 = new IntRef(1);
        long beginTimeMs = SystemTime$.MODULE$.milliseconds();
        while (this.kafka$producer$SyncProducer$$channel() == null) {
            if (this.shutdown()) return this.kafka$producer$SyncProducer$$channel();
            {
                this.kafka$producer$SyncProducer$$channel_$eq(SocketChannel.open());
                this.kafka$producer$SyncProducer$$channel().socket().setSendBufferSize(this.config().bufferSize());
                this.kafka$producer$SyncProducer$$channel().configureBlocking(true);
                this.kafka$producer$SyncProducer$$channel().socket().setSoTimeout(this.config().socketTimeoutMs());
                this.kafka$producer$SyncProducer$$channel().socket().setKeepAlive(true);
                this.kafka$producer$SyncProducer$$channel().connect(new InetSocketAddress(this.config().host(), this.config().port()));
                this.info((Function0<String>)new $anonfun$connect$1(this));
            }
        }
        return this.kafka$producer$SyncProducer$$channel();
    }

    private void getOrMakeConnection() {
        if (this.kafka$producer$SyncProducer$$channel() == null) {
            this.kafka$producer$SyncProducer$$channel_$eq(this.connect());
        }
    }

    private final int liftedTree1$1(BoundedByteBufferSend boundedByteBufferSend) {
        int exceptionResult1 = 0;
        try {
            exceptionResult1 = boundedByteBufferSend.writeCompletely(this.kafka$producer$SyncProducer$$channel());
            return exceptionResult1;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    public SyncProducer(SyncProducerConfig config) {
        this.config = config;
        Logging$class.$init$(this);
        this.MaxConnectBackoffMs = 60000;
        this.kafka$producer$SyncProducer$$channel = null;
        this.sentOnConnection = 0;
        this.lastConnectionTime = (double)System.currentTimeMillis() - SyncProducer$.MODULE$.randomGenerator().nextDouble() * (double)config.reconnectInterval();
        this.lock = new Object();
        this.shutdown = false;
        this.trace((Function0<String>)new $anonfun$2(this));
    }
}

