/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.api.FetchRequest;
import kafka.api.FetchRequest$;
import kafka.api.MultiFetchRequest;
import kafka.api.MultiFetchRequest$;
import kafka.api.MultiProducerRequest;
import kafka.api.MultiProducerRequest$;
import kafka.api.OffsetArraySend;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.ProducerRequest;
import kafka.api.ProducerRequest$;
import kafka.api.RequestKeys$;
import kafka.common.ErrorMapping$;
import kafka.common.MessageSizeTooLargeException;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.message.MessageSet$;
import kafka.network.Receive;
import kafka.network.Send;
import kafka.server.BrokerTopicStat$;
import kafka.server.KafkaRequestHandlers$;
import kafka.server.KafkaRequestHandlers$$anonfun$kafka$server$KafkaRequestHandlers$;
import kafka.server.MessageSetSend;
import kafka.server.MultiMessageSetSend;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ua!C\u0001\u0003\t\u0003\u0005\t\u0011\u0001\u0003\u0007\u0005QY\u0015MZ6b%\u0016\fX/Z:u\u0011\u0006tG\r\\3sg*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001cB\u0001A\u0004\u0010+A\u0011\u0001\"D\u0007\u0002\u0013)\u0011!bC\u0001\u0005Y\u0006twMC\u0001\r\u0003\u0011Q\u0017M^1\n\u00059I!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0011'5\t\u0011C\u0003\u0002\u0013\t\u0005)Q\u000f^5mg&\u0011A#\u0005\u0002\b\u0019><w-\u001b8h!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011q\u0001!Q1A\u0005\u0002y\t!\u0002\\8h\u001b\u0006t\u0017mZ3s\u0007\u0001)\u0012a\b\t\u0003A\rj\u0011!\t\u0006\u0003E\u0011\t1\u0001\\8h\u0013\t!\u0013E\u0001\u0006M_\u001el\u0015M\\1hKJD\u0001B\n\u0001\u0003\u0002\u0003\u0006IaH\u0001\fY><W*\u00198bO\u0016\u0014\b\u0005C\u0003)\u0001\u0011\u0005\u0011&\u0001\u0004=S:LGO\u0010\u000b\u0003U1\u0002\"a\u000b\u0001\u000e\u0003\tAQ\u0001H\u0014A\u0002}AqA\f\u0001C\u0002\u0013%q&A\u0007sKF,Xm\u001d;M_\u001e<WM]\u000b\u0002aA\u0011\u0011\u0007O\u0007\u0002e)\u00111\u0007N\u0001\u0006Y><GG\u001b\u0006\u0003kY\na!\u00199bG\",'\"A\u001c\u0002\u0007=\u0014x-\u0003\u0002:e\t1Aj\\4hKJDaa\u000f\u0001!\u0002\u0013\u0001\u0014A\u0004:fcV,7\u000f\u001e'pO\u001e,'\u000f\t\u0005\u0006{\u0001!\tAP\u0001\u000bQ\u0006tG\r\\3s\r>\u0014HcA J\u001dB\u0011\u0001I\u0012\b\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007\u0012\tqA\\3uo>\u00148.\u0003\u0002F\u0005\u00069\u0001*\u00198eY\u0016\u0014\u0018BA$I\u0005\u001dA\u0015M\u001c3mKJT!!\u0012\"\t\u000b)c\u0004\u0019A&\u0002\u001bI,\u0017/^3tiRK\b/Z%e!\t1B*\u0003\u0002N/\t)1\u000b[8si\")q\n\u0010a\u0001!\u00069!/Z9vKN$\bCA!R\u0013\t\u0011&IA\u0004SK\u000e,\u0017N^3\t\u000bQ\u0003A\u0011A+\u0002+!\fg\u000e\u001a7f!J|G-^2feJ+\u0017/^3tiR\u0011a\u000b\u0018\t\u0004-]K\u0016B\u0001-\u0018\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011IW\u0005\u00037\n\u0013AaU3oI\")Ql\u0015a\u0001!\u00069!/Z2fSZ,\u0007\"B0\u0001\t\u0003\u0001\u0017A\u00075b]\u0012dW-T;mi&\u0004&o\u001c3vG\u0016\u0014(+Z9vKN$HC\u0001,b\u0011\u0015if\f1\u0001Q\u0011\u0015!\u0006\u0001\"\u0003d)\r!wM\u001c\t\u0003-\u0015L!AZ\f\u0003\t1{gn\u001a\u0005\u0006\u001f\n\u0004\r\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0003W\u0012\t1!\u00199j\u0013\ti'NA\bQe>$WoY3s%\u0016\fX/Z:u\u0011\u0015y'\r1\u0001q\u0003I\u0011X-];fgRD\u0015M\u001c3mKJt\u0015-\\3\u0011\u0005E$hB\u0001\fs\u0013\t\u0019x#\u0001\u0004Qe\u0016$WMZ\u0005\u0003kZ\u0014aa\u0015;sS:<'BA:\u0018\u0011\u0015A\b\u0001\"\u0001z\u0003IA\u0017M\u001c3mK\u001a+Go\u00195SKF,Xm\u001d;\u0015\u0005YS\b\"B(x\u0001\u0004\u0001\u0006\"\u0002?\u0001\t\u0003i\u0018a\u00065b]\u0012dW-T;mi&4U\r^2i%\u0016\fX/Z:u)\t1f\u0010C\u0003Pw\u0002\u0007\u0001\u000bC\u0004\u0002\u0002\u0001!I!a\u0001\u0002\u001dI,\u0017\rZ'fgN\fw-Z*fiR!\u0011QAA\u0006!\rY\u0013qA\u0005\u0004\u0003\u0013\u0011!AD'fgN\fw-Z*fiN+g\u000e\u001a\u0005\b\u0003\u001by\b\u0019AA\b\u000311W\r^2i%\u0016\fX/Z:u!\rI\u0017\u0011C\u0005\u0004\u0003'Q'\u0001\u0004$fi\u000eD'+Z9vKN$\bbBA\f\u0001\u0011\u0005\u0011\u0011D\u0001\u0014Q\u0006tG\r\\3PM\u001a\u001cX\r\u001e*fcV,7\u000f\u001e\u000b\u0004-\u0006m\u0001BB(\u0002\u0016\u0001\u0007\u0001\u000b")
public class KafkaRequestHandlers
implements Logging,
ScalaObject {
    private final LogManager logManager;
    private final Logger kafka$server$KafkaRequestHandlers$$requestLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        KafkaRequestHandlers kafkaRequestHandlers = this;
        synchronized (kafkaRequestHandlers) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public final Logger kafka$server$KafkaRequestHandlers$$requestLogger() {
        return this.kafka$server$KafkaRequestHandlers$$requestLogger;
    }

    public Function1<Receive, Option<Send>> handlerFor(short requestTypeId, Receive request) {
        block7: {
            AbstractFunction1 abstractFunction1;
            block3: {
                short s2;
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                s2 = requestTypeId;
                                if (s2 != RequestKeys$.MODULE$.Produce()) break block2;
                                abstractFunction1 = new $anonfun$handlerFor$1(this);
                                break block3;
                            }
                            if (s2 != RequestKeys$.MODULE$.Fetch()) break block4;
                            abstractFunction1 = new $anonfun$handlerFor$2(this);
                            break block3;
                        }
                        if (s2 != RequestKeys$.MODULE$.MultiFetch()) break block5;
                        abstractFunction1 = new $anonfun$handlerFor$3(this);
                        break block3;
                    }
                    if (s2 != RequestKeys$.MODULE$.MultiProduce()) break block6;
                    abstractFunction1 = new $anonfun$handlerFor$4(this);
                    break block3;
                }
                if (s2 != RequestKeys$.MODULE$.Offsets()) break block7;
                abstractFunction1 = new $anonfun$handlerFor$5(this);
            }
            return abstractFunction1;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"No mapping found for handler id ").append(BoxesRunTime.boxToShort(requestTypeId)).toString());
    }

    public Option<Send> handleProducerRequest(Receive receive) {
        long sTime$1 = SystemTime$.MODULE$.milliseconds();
        ProducerRequest request = ProducerRequest$.MODULE$.readFrom(receive.buffer());
        if (this.kafka$server$KafkaRequestHandlers$$requestLogger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$requestLogger().trace(new StringBuilder().append((Object)"Producer request ").append((Object)request.toString()).toString());
        }
        this.kafka$server$KafkaRequestHandlers$$handleProducerRequest(request, "ProduceRequest");
        this.debug((Function0<String>)new $anonfun$handleProducerRequest$1(this, sTime$1));
        return None$.MODULE$;
    }

    public Option<Send> handleMultiProducerRequest(Receive receive) {
        MultiProducerRequest request = MultiProducerRequest$.MODULE$.readFrom(receive.buffer());
        if (this.kafka$server$KafkaRequestHandlers$$requestLogger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$requestLogger().trace(new StringBuilder().append((Object)"Multiproducer request ").append((Object)request.toString()).toString());
        }
        Predef$.MODULE$.refArrayOps((Object[])request.produces()).map(new $anonfun$handleMultiProducerRequest$1(this), Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Long()));
        return None$.MODULE$;
    }

    public final long kafka$server$KafkaRequestHandlers$$handleProducerRequest(ProducerRequest request$1, String requestHandlerName$1) {
        int partition$1 = request$1.getTranslatedPartition(new $anonfun$1(this));
        long exceptionResult1 = 0L;
        try {
            this.logManager().getOrCreateLog(request$1.topic(), partition$1).append(request$1.messages());
            this.trace((Function0<String>)new $anonfun$kafka$server$KafkaRequestHandlers$$handleProducerRequest$1(this, request$1));
            request$1.messages().foreach(new $anonfun$kafka$server$KafkaRequestHandlers$$handleProducerRequest$2(this));
            BrokerTopicStat$.MODULE$.getBrokerTopicStat(request$1.topic()).recordBytesIn(request$1.messages().sizeInBytes());
            exceptionResult1 = BrokerTopicStat$.MODULE$.getBrokerAllTopicStat().recordBytesIn(request$1.messages().sizeInBytes());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new $anonfun$kafka$server$KafkaRequestHandlers$$handleProducerRequest$4(this, request$1, requestHandlerName$1, partition$1), (Function0<Throwable>)new $anonfun$kafka$server$KafkaRequestHandlers$$handleProducerRequest$5(this, throwable));
            BrokerTopicStat$.MODULE$.getBrokerTopicStat(request$1.topic()).recordFailedProduceRequest();
            BrokerTopicStat$.MODULE$.getBrokerAllTopicStat().recordFailedProduceRequest();
            throw throwable;
        }
        catch (MessageSizeTooLargeException messageSizeTooLargeException) {
            this.warn((Function0<String>)new $anonfun$kafka$server$KafkaRequestHandlers$$handleProducerRequest$3(this, request$1, partition$1, messageSizeTooLargeException));
            BrokerTopicStat$.MODULE$.getBrokerTopicStat(request$1.topic()).recordFailedProduceRequest();
            exceptionResult1 = BrokerTopicStat$.MODULE$.getBrokerAllTopicStat().recordFailedProduceRequest();
        }
        return exceptionResult1;
    }

    public Option<Send> handleFetchRequest(Receive request) {
        FetchRequest fetchRequest = FetchRequest$.MODULE$.readFrom(request.buffer());
        if (this.kafka$server$KafkaRequestHandlers$$requestLogger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$requestLogger().trace(new StringBuilder().append((Object)"Fetch request ").append((Object)fetchRequest.toString()).toString());
        }
        return new Some<Send>(this.kafka$server$KafkaRequestHandlers$$readMessageSet(fetchRequest));
    }

    public Option<Send> handleMultiFetchRequest(Receive request) {
        MultiFetchRequest multiFetchRequest = MultiFetchRequest$.MODULE$.readFrom(request.buffer());
        if (this.kafka$server$KafkaRequestHandlers$$requestLogger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$requestLogger().trace("Multifetch request");
        }
        Predef$.MODULE$.refArrayOps((Object[])multiFetchRequest.fetches()).foreach(new $anonfun$handleMultiFetchRequest$1(this));
        List<MessageSetSend> responses = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])multiFetchRequest.fetches()).map(new $anonfun$2(this), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(MessageSetSend.class)))).toList();
        return new Some<Send>(new MultiMessageSetSend(responses));
    }

    /*
     * WARNING - void declaration
     */
    public final MessageSetSend kafka$server$KafkaRequestHandlers$$readMessageSet(FetchRequest fetchRequest$1) {
        void var2_2;
        MessageSetSend response = null;
        BoxedUnit exceptionResult2 = null;
        try {
            Serializable serializable2;
            this.trace((Function0<String>)new $anonfun$kafka$server$KafkaRequestHandlers$$readMessageSet$1(this, fetchRequest$1));
            Log log2 = this.logManager().getLog(fetchRequest$1.topic(), fetchRequest$1.partition());
            if (log2 == null) {
                response = new MessageSetSend();
                serializable2 = BoxedUnit.UNIT;
            } else {
                response = new MessageSetSend(log2.read(fetchRequest$1.offset(), fetchRequest$1.maxSize()));
                BrokerTopicStat$.MODULE$.getBrokerTopicStat(fetchRequest$1.topic()).recordBytesOut(response.messages().sizeInBytes());
                serializable2 = BoxesRunTime.boxToLong(BrokerTopicStat$.MODULE$.getBrokerAllTopicStat().recordBytesOut(response.messages().sizeInBytes()));
            }
            exceptionResult2 = serializable2;
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new $anonfun$kafka$server$KafkaRequestHandlers$$readMessageSet$2(this, fetchRequest$1), (Function0<Throwable>)new $anonfun$kafka$server$KafkaRequestHandlers$$readMessageSet$3(this, throwable));
            BrokerTopicStat$.MODULE$.getBrokerTopicStat(fetchRequest$1.topic()).recordFailedFetchRequest();
            BrokerTopicStat$.MODULE$.getBrokerAllTopicStat().recordFailedFetchRequest();
            response = new MessageSetSend(MessageSet$.MODULE$.Empty(), ErrorMapping$.MODULE$.codeFor(throwable.getClass()));
            exceptionResult2 = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    public Option<Send> handleOffsetRequest(Receive request) {
        OffsetRequest offsetRequest = OffsetRequest$.MODULE$.readFrom(request.buffer());
        if (this.kafka$server$KafkaRequestHandlers$$requestLogger().isTraceEnabled()) {
            this.kafka$server$KafkaRequestHandlers$$requestLogger().trace(new StringBuilder().append((Object)"Offset request ").append((Object)offsetRequest.toString()).toString());
        }
        long[] offsets = this.logManager().getOffsets(offsetRequest);
        OffsetArraySend response = new OffsetArraySend(offsets);
        return new Some<Send>(response);
    }

    public KafkaRequestHandlers(LogManager logManager) {
        this.logManager = logManager;
        Logging$class.$init$(this);
        this.kafka$server$KafkaRequestHandlers$$requestLogger = Logger.getLogger("kafka.request.logger");
    }
}

