/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.InetAddress;
import kafka.cluster.Broker;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaZooKeeper$;
import kafka.server.KafkaZooKeeper$SessionExpireListener$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Watcher;
import scala.Function0;
import scala.ScalaObject;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u001d-\u000bgm[1[_>\\U-\u001a9fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u0011A1\u0002CA\u0005\u000f\u001b\u0005Q!BA\u0006\r\u0003\u0011a\u0017M\\4\u000b\u00035\tAA[1wC&\u0011qB\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005E!R\"\u0001\n\u000b\u0005M!\u0011!B;uS2\u001c\u0018BA\u000b\u0013\u0005\u001daunZ4j]\u001e\u0004\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u00111bU2bY\u0006|%M[3di\"AQ\u0004\u0001B\u0001B\u0003%a$\u0001\u0004d_:4\u0017n\u001a\t\u0003?\u0001j\u0011AA\u0005\u0003C\t\u00111bS1gW\u0006\u001cuN\u001c4jO\"A1\u0005\u0001B\u0001B\u0003%A%\u0001\u0006m_\u001el\u0015M\\1hKJ\u0004\"!\n\u0015\u000e\u0003\u0019R!a\n\u0003\u0002\u00071|w-\u0003\u0002*M\tQAj\\4NC:\fw-\u001a:\t\u000b-\u0002A\u0011\u0001\u0017\u0002\rqJg.\u001b;?)\ricf\f\t\u0003?\u0001AQ!\b\u0016A\u0002yAQa\t\u0016A\u0002\u0011Bq!\r\u0001C\u0002\u0013\u0005!'\u0001\u0007ce>\\WM]%e!\u0006$\b.F\u00014!\tIA'\u0003\u00026\u0015\t11\u000b\u001e:j]\u001eDaa\u000e\u0001!\u0002\u0013\u0019\u0014!\u00042s_.,'/\u00133QCRD\u0007\u0005C\u0004:\u0001\u0001\u0007I\u0011\u0001\u001e\u0002\u0011i\\7\t\\5f]R,\u0012a\u000f\t\u0003y\rk\u0011!\u0010\u0006\u0003}}\n\u0001B_6dY&,g\u000e\u001e\u0006\u0003\u0001\u0006\u000ba!\u0013\u0019Ji\u0016\u001c'\"\u0001\"\u0002\u0007=\u0014x-\u0003\u0002E{\tA!l[\"mS\u0016tG\u000fC\u0004G\u0001\u0001\u0007I\u0011A$\u0002\u0019i\\7\t\\5f]R|F%Z9\u0015\u0005![\u0005CA\fJ\u0013\tQ\u0005D\u0001\u0003V]&$\bb\u0002'F\u0003\u0003\u0005\raO\u0001\u0004q\u0012\n\u0004B\u0002(\u0001A\u0003&1(A\u0005{W\u000ec\u0017.\u001a8uA!9\u0001\u000b\u0001a\u0001\n\u0003\t\u0016A\u0002;pa&\u001c7/F\u0001S!\r\u00196L\u0018\b\u0003)fs!!\u0016-\u000e\u0003YS!a\u0016\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0012B\u0001.\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001X/\u0003\t1K7\u000f\u001e\u0006\u00035b\u0001\"a\u00182\u000f\u0005]\u0001\u0017BA1\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011Qg\u0019\u0006\u0003CbAq!\u001a\u0001A\u0002\u0013\u0005a-\u0001\u0006u_BL7m]0%KF$\"\u0001S4\t\u000f1#\u0017\u0011!a\u0001%\"1\u0011\u000e\u0001Q!\nI\u000bq\u0001^8qS\u000e\u001c\b\u0005C\u0004l\u0001\t\u0007I\u0011\u00017\u0002\t1|7m[\u000b\u0002\u0011!1a\u000e\u0001Q\u0001\n!\tQ\u0001\\8dW\u0002BQ\u0001\u001d\u0001\u0005\u0002E\fqa\u001d;beR,\b\u000fF\u0001I\u0011\u0015\u0019\b\u0001\"\u0001r\u0003I\u0011XmZ5ti\u0016\u0014(I]8lKJLeNW6\t\u000bU\u0004A\u0011\u0001<\u0002#I,w-[:uKJ$v\u000e]5d\u0013:T6\u000e\u0006\u0002Io\")\u0001\u0010\u001ea\u0001=\u0006)Ao\u001c9jG\")!\u0010\u0001C\u0001w\u0006I\"/Z4jgR,'\u000fV8qS\u000eLeNW6J]R,'O\\1m)\tAE\u0010C\u0003ys\u0002\u0007aL\u0002\u0005\u007f\u0001\u0011\u0005\t\u0011!\u0001\u0000\u0005U\u0019Vm]:j_:,\u0005\u0010]5sK2K7\u000f^3oKJ\u001cR! \u0005\u0002\u0002Y\u00012\u0001PA\u0002\u0013\r\t)!\u0010\u0002\u0011\u0013j[7\u000b^1uK2K7\u000f^3oKJDaaK?\u0005\u0002\u0005%ACAA\u0006!\r\ti!`\u0007\u0002\u0001!9\u0011\u0011C?\u0005\u0002\u0005M\u0011A\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hK\u0012$2\u0001SA\u000b\u0011!\t9\"a\u0004A\u0002\u0005e\u0011!B:uCR,\u0007\u0003BA\u000e\u0003{qA!!\b\u000289!\u0011qDA\u0019\u001d\u0011\t\t#a\u000b\u000f\t\u0005\r\u0012q\u0005\b\u0004+\u0006\u0015\u0012\"\u0001\"\n\u0007\u0005%\u0012)\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003[\ty#A\u0005{_>\\W-\u001a9fe*\u0019\u0011\u0011F!\n\t\u0005M\u0012QG\u0001\b/\u0006$8\r[3s\u0015\u0011\ti#a\f\n\t\u0005e\u00121H\u0001\u0006\u000bZ,g\u000e\u001e\u0006\u0005\u0003g\t)$\u0003\u0003\u0002@\u0005\u0005#aC&fKB,'o\u0015;bi\u0016TA!!\u000f\u0002<!2\u0011qBA#\u0003\u0017\u00022aFA$\u0013\r\tI\u0005\u0007\u0002\u0007i\"\u0014xn^:$\u0005\u00055\u0003cA*\u0002P%\u0019\u0011\u0011K/\u0003\u0013\u0015C8-\u001a9uS>t\u0007BBA+{\u0012\u0005\u0011/\u0001\tiC:$G.\u001a(foN+7o]5p]\"2\u00111KA#\u0003\u0017Ba!a\u0017\u0001\t\u0003\t\u0018!B2m_N,\u0007")
public class KafkaZooKeeper
implements Logging,
ScalaObject {
    public final KafkaConfig kafka$server$KafkaZooKeeper$$config;
    private final LogManager logManager;
    private final String brokerIdPath;
    private ZkClient zkClient;
    private List<String> topics;
    private final Object lock;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        KafkaZooKeeper kafkaZooKeeper = this;
        synchronized (kafkaZooKeeper) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public String brokerIdPath() {
        return this.brokerIdPath;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(ZkClient zkClient) {
        this.zkClient = zkClient;
    }

    public List<String> topics() {
        return this.topics;
    }

    public void topics_$eq(List<String> list2) {
        this.topics = list2;
    }

    public Object lock() {
        return this.lock;
    }

    public void startup() {
        this.info((Function0<String>)new $anonfun$startup$1(this));
        this.zkClient_$eq(new ZkClient(this.kafka$server$KafkaZooKeeper$$config.zkConnect(), this.kafka$server$KafkaZooKeeper$$config.zkSessionTimeoutMs(), this.kafka$server$KafkaZooKeeper$$config.zkConnectionTimeoutMs(), ZKStringSerializer$.MODULE$));
        this.zkClient().subscribeStateChanges(new SessionExpireListener());
    }

    public void registerBrokerInZk() {
        this.info((Function0<String>)new $anonfun$registerBrokerInZk$1(this));
        String hostName = this.kafka$server$KafkaZooKeeper$$config.hostName() == null ? InetAddress.getLocalHost().getHostAddress() : this.kafka$server$KafkaZooKeeper$$config.hostName();
        String creatorId = new StringBuilder().append((Object)hostName).append((Object)"-").append(BoxesRunTime.boxToLong(System.currentTimeMillis())).toString();
        Broker broker$1 = new Broker(this.kafka$server$KafkaZooKeeper$$config.brokerId(), creatorId, hostName, this.kafka$server$KafkaZooKeeper$$config.port());
        try {
            ZkUtils$.MODULE$.createEphemeralPathExpectConflict(this.zkClient(), this.brokerIdPath(), broker$1.getZKString());
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new RuntimeException(new StringBuilder().append((Object)"A broker is already registered on the path ").append((Object)this.brokerIdPath()).append((Object)". This probably ").append((Object)"indicates that you either have configured a brokerid that is already in use, or ").append((Object)"else you have shutdown this broker and restarted it faster than the zookeeper ").append((Object)"timeout so it appears to be re-registering.").toString());
        }
        this.info((Function0<String>)new $anonfun$registerBrokerInZk$2(this, broker$1));
    }

    public void registerTopicInZk(String topic) {
        this.registerTopicInZkInternal(topic);
        Object object = this.lock();
        synchronized (object) {
            this.topics_$eq(this.topics().$colon$colon(topic));
            return;
        }
    }

    public void registerTopicInZkInternal(String topic) {
        String brokerTopicPath$1 = new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerTopicsPath()).append((Object)"/").append((Object)topic).append((Object)"/").append(BoxesRunTime.boxToInteger(this.kafka$server$KafkaZooKeeper$$config.brokerId())).toString();
        int numParts$1 = BoxesRunTime.unboxToInt(this.logManager.getTopicPartitionsMap().getOrElse(topic, new $anonfun$1(this)));
        this.info((Function0<String>)new $anonfun$registerTopicInZkInternal$1(this, brokerTopicPath$1, numParts$1));
        ZkUtils$.MODULE$.createEphemeralPathExpectConflict(this.zkClient(), brokerTopicPath$1, ((Object)BoxesRunTime.boxToInteger(numParts$1)).toString());
        this.info((Function0<String>)new $anonfun$registerTopicInZkInternal$2(this, brokerTopicPath$1));
    }

    public void close() {
        if (this.zkClient() != null) {
            this.info((Function0<String>)new $anonfun$close$1(this));
            this.zkClient().close();
        }
    }

    public KafkaZooKeeper(KafkaConfig config, LogManager logManager) {
        this.kafka$server$KafkaZooKeeper$$config = config;
        this.logManager = logManager;
        Logging$class.$init$(this);
        this.brokerIdPath = new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append(BoxesRunTime.boxToInteger(config.brokerId())).toString();
        this.zkClient = null;
        this.topics = Nil$.MODULE$;
        this.lock = new Object();
    }

    public class SessionExpireListener
    implements IZkStateListener,
    ScalaObject {
        public void handleStateChanged(Watcher.Event.KeeperState state) throws Exception {
        }

        public void handleNewSession() throws Exception {
            this.kafka$server$KafkaZooKeeper$SessionExpireListener$$$outer().info((Function0<String>)new SessionExpireListener$$anonfun$handleNewSession$1(this));
            this.kafka$server$KafkaZooKeeper$SessionExpireListener$$$outer().registerBrokerInZk();
            Object object = this.kafka$server$KafkaZooKeeper$SessionExpireListener$$$outer().lock();
            synchronized (object) {
                this.kafka$server$KafkaZooKeeper$SessionExpireListener$$$outer().info((Function0<String>)new SessionExpireListener$$anonfun$handleNewSession$2(this));
                this.kafka$server$KafkaZooKeeper$SessionExpireListener$$$outer().topics().foreach(new SessionExpireListener$$anonfun$handleNewSession$3(this));
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                this.kafka$server$KafkaZooKeeper$SessionExpireListener$$$outer().info((Function0<String>)new SessionExpireListener$$anonfun$handleNewSession$4(this));
                return;
            }
        }

        public /* synthetic */ KafkaZooKeeper kafka$server$KafkaZooKeeper$SessionExpireListener$$$outer() {
            return KafkaZooKeeper.this;
        }

        public SessionExpireListener() {
            if (KafkaZooKeeper.this == null) {
                throw new NullPointerException();
            }
        }
    }
}

