/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import kafka.consumer.SimpleConsumer;
import kafka.tools.ConsumerOffsetChecker$;
import kafka.tools.ConsumerOffsetChecker$$anonfun$kafka$tools$ConsumerOffsetChecker$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering$String$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConsumerOffsetChecker$
implements Logging,
ScalaObject {
    public static final ConsumerOffsetChecker$ MODULE$;
    private final Map<String, Option<SimpleConsumer>> consumerMap;
    private final Regex BidPidPattern;
    private final Regex BrokerIpPattern;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ConsumerOffsetChecker$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ConsumerOffsetChecker$ consumerOffsetChecker$ = this;
        synchronized (consumerOffsetChecker$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    private Map<String, Option<SimpleConsumer>> consumerMap() {
        return this.consumerMap;
    }

    private Regex BidPidPattern() {
        return this.BidPidPattern;
    }

    private Regex BrokerIpPattern() {
        return this.BrokerIpPattern;
    }

    public final Option kafka$tools$ConsumerOffsetChecker$$getConsumer(ZkClient zkClient, String bid) {
        Option option;
        List<String> list2;
        String brokerInfo$1;
        String string2 = brokerInfo$1 = ZkUtils$.MODULE$.readDataMaybeNull(zkClient, Predef$.MODULE$.augmentString("/brokers/ids/%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{bid})));
        Option<List<String>> option2 = this.BrokerIpPattern().unapplySeq(string2);
        if (!option2.isEmpty() && ((list2 = option2.get()) == null ? false : list2.lengthCompare(2) == 0)) {
            option = new Some<SimpleConsumer>(new SimpleConsumer((String)list2.apply(0), Predef$.MODULE$.augmentString((String)list2.apply(1)).toInt(), 10000, 100000));
        } else {
            this.error((Function0<String>)new anonfun.1(brokerInfo$1));
            option = None$.MODULE$;
        }
        None$ consumer = option;
        return consumer;
    }

    public final void kafka$tools$ConsumerOffsetChecker$$processPartition(ZkClient zkClient$1, String group, String topic, String bidPid$1) {
        List<String> list2;
        long offset = Predef$.MODULE$.augmentString(ZkUtils$.MODULE$.readData(zkClient$1, Predef$.MODULE$.augmentString("/consumers/%s/offsets/%s/%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{group, topic, bidPid$1})))).toLong();
        String owner = ZkUtils$.MODULE$.readDataMaybeNull(zkClient$1, Predef$.MODULE$.augmentString("/consumers/%s/owners/%s/%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{group, topic, bidPid$1})));
        Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%s,%s,%s (Group,Topic,BrokerId-PartitionId)").format(Predef$.MODULE$.genericWrapArray(new Object[]{group, topic, bidPid$1})));
        Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%20s%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{"Owner = ", owner})));
        Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%20s%d").format(Predef$.MODULE$.genericWrapArray(new Object[]{"Consumer offset = ", BoxesRunTime.boxToLong(offset)})));
        Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%20s%,d (%,.2fG)").format(Predef$.MODULE$.genericWrapArray(new Object[]{"= ", BoxesRunTime.boxToLong(offset), BoxesRunTime.boxToDouble((double)offset / package$.MODULE$.pow(1024.0, 3.0))})));
        String string2 = bidPid$1;
        Option<List<String>> option = this.BidPidPattern().unapplySeq(string2);
        if (!option.isEmpty() && ((list2 = option.get()) == null ? false : list2.lengthCompare(2) == 0)) {
            String string3 = (String)list2.apply(0);
            String string4 = (String)list2.apply(1);
            String bid$1 = string3;
            String pid = string4;
            Option consumerOpt = (Option)this.consumerMap().getOrElseUpdate(bid$1, new anonfun.2(zkClient$1, bid$1));
            Option option2 = consumerOpt;
            if (option2 instanceof Some) {
                SimpleConsumer simpleConsumer;
                Some some = (Some)option2;
                SimpleConsumer consumer = simpleConsumer = (SimpleConsumer)some.x();
                long logSize = BoxesRunTime.unboxToLong(Predef$.MODULE$.longArrayOps(consumer.getOffsetsBefore(topic, Predef$.MODULE$.augmentString(pid).toInt(), -1L, 1)).last());
                Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%20s%d").format(Predef$.MODULE$.genericWrapArray(new Object[]{"Log size = ", BoxesRunTime.boxToLong(logSize)})));
                Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%20s%,d (%,.2fG)").format(Predef$.MODULE$.genericWrapArray(new Object[]{"= ", BoxesRunTime.boxToLong(logSize), BoxesRunTime.boxToDouble((double)logSize / package$.MODULE$.pow(1024.0, 3.0))})));
                long lag = logSize - offset;
                Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%20s%d").format(Predef$.MODULE$.genericWrapArray(new Object[]{"Consumer lag = ", BoxesRunTime.boxToLong(lag)})));
                Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%20s%,d (%,.2fG)").format(Predef$.MODULE$.genericWrapArray(new Object[]{"= ", BoxesRunTime.boxToLong(lag), BoxesRunTime.boxToDouble((double)lag / package$.MODULE$.pow(1024.0, 3.0))})));
                Predef$.MODULE$.println();
            } else {
                None$ none$ = None$.MODULE$;
                Option option3 = option2;
                if (none$ == null ? option3 != null : !none$.equals(option3)) {
                    throw new MatchError(option2);
                }
            }
        } else {
            this.error((Function0<String>)new anonfun$kafka$tools$ConsumerOffsetChecker$$processPartition$1(bidPid$1));
        }
    }

    public final void kafka$tools$ConsumerOffsetChecker$$processTopic(ZkClient zkClient$2, String group$1, String topic$1) {
        List bidsPids = ZkUtils$.MODULE$.getChildrenParentMayNotExist(zkClient$2, Predef$.MODULE$.augmentString("/consumers/%s/offsets/%s").format(Predef$.MODULE$.genericWrapArray(new Object[]{group$1, topic$1}))).toList();
        ((LinearSeqOptimized)bidsPids.sorted(Ordering$String$.MODULE$)).foreach(new anonfun$kafka$tools$ConsumerOffsetChecker$$processTopic$1(zkClient$2, group$1, topic$1));
    }

    private void printBrokerInfo() {
        Predef$.MODULE$.println("BROKER INFO");
        this.consumerMap().foreach(new anonfun.printBrokerInfo.1());
    }

    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec<String> zkConnectOpt = parser$1.accepts("zkconnect", "ZooKeeper connect string.").withRequiredArg().defaultsTo("localhost:2181", (String[])((Object[])new String[0])).ofType(String.class);
        ArgumentAcceptingOptionSpec<String> topicsOpt = parser$1.accepts("topic", "Comma-separated list of consumer topics (all topics if absent).").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<String> groupOpt = parser$1.accepts("group", "Consumer group.").withRequiredArg().ofType(String.class);
        parser$1.accepts("help", "Print this message.");
        OptionSet options$1 = parser$1.parse(args);
        if (options$1.has("help")) {
            parser$1.printHelpOn(System.out);
            System.exit(0);
        }
        List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{groupOpt})).foreach(new anonfun.main.1(parser$1, options$1));
        String zkConnect$1 = options$1.valueOf(zkConnectOpt);
        String group$2 = options$1.valueOf(groupOpt);
        Option topics = options$1.has(topicsOpt) ? new Some<String>(options$1.valueOf(topicsOpt)) : None$.MODULE$;
        ObjectRef<Object> zkClient$3 = new ObjectRef<Object>(null);
        try {
            Option option;
            block11: {
                List list2;
                block10: {
                    block9: {
                        zkClient$3.elem = new ZkClient(zkConnect$1, 30000, 30000, ZKStringSerializer$.MODULE$);
                        option = topics;
                        if (!(option instanceof Some)) break block9;
                        list2 = Predef$.MODULE$.refArrayOps((Object[])((String)((Some)option).x()).split(",")).view().toList();
                        break block10;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block11;
                    list2 = ZkUtils$.MODULE$.getChildren((ZkClient)zkClient$3.elem, Predef$.MODULE$.augmentString("/consumers/%s/offsets").format(Predef$.MODULE$.genericWrapArray(new Object[]{group$2}))).toList();
                }
                List topicList$1 = list2;
                this.debug((Function0<String>)new anonfun.main.2(zkConnect$1, group$2, topicList$1));
                ((LinearSeqOptimized)topicList$1.sorted(Ordering$String$.MODULE$)).foreach(new anonfun.main.3(group$2, zkClient$3));
                this.printBrokerInfo();
                return;
            }
            throw new MatchError(option);
        }
        finally {
            this.consumerMap().values().foreach(new anonfun.main.4());
            if ((ZkClient)zkClient$3.elem != null) {
                ((ZkClient)zkClient$3.elem).close();
            }
        }
    }

    private ConsumerOffsetChecker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.consumerMap = (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.BidPidPattern = Predef$.MODULE$.augmentString("(\\d+)-(\\d+)").r();
        this.BrokerIpPattern = Predef$.MODULE$.augmentString(".*:(\\d+\\.\\d+\\.\\d+\\.\\d+):(\\d+$)").r();
    }
}

