/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.KafkaStream;
import kafka.serializer.StringDecoder;
import kafka.tools.ConsumerShell$;
import kafka.utils.Utils$;
import scala.Predef;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ConsumerShell$
implements ScalaObject {
    public static final ConsumerShell$ MODULE$;

    static {
        new ConsumerShell$();
    }

    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec<String> topicOpt = parser$1.accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> consumerPropsOpt = parser$1.accepts("props", "REQUIRED: Properties file with the consumer properties.").withRequiredArg().describedAs("properties").ofType(String.class);
        ArgumentAcceptingOptionSpec<Integer> partitionsOpt = parser$1.accepts("partitions", "Number of partitions to consume from.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1), (Integer[])((Object[])new Integer[0]));
        OptionSet options$1 = parser$1.parse(args);
        List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{topicOpt, consumerPropsOpt})).foreach(new anonfun.main.1(parser$1, options$1));
        int partitions = options$1.valueOf(partitionsOpt);
        String propsFile = options$1.valueOf(consumerPropsOpt);
        String topic = options$1.valueOf(topicOpt);
        Predef$.MODULE$.println("Starting consumer...");
        ConsumerConfig consumerConfig = new ConsumerConfig(Utils$.MODULE$.loadProps(propsFile));
        ConsumerConnector consumerConnector$1 = Consumer$.MODULE$.create(consumerConfig);
        Map<String, List<KafkaStream<String>>> topicMessageStreams = consumerConnector$1.createMessageStreams((Map<String, Integer>)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{((Predef.ArrowAssoc)((Object)Predef$.MODULE$.any2ArrowAssoc(topic))).$minus$greater(BoxesRunTime.boxToInteger(partitions))})), new StringDecoder());
        ObjectRef<Nil$> threadList$1 = new ObjectRef<Nil$>(Nil$.MODULE$);
        topicMessageStreams.foreach(new anonfun.main.2(threadList$1));
        ((List)threadList$1.elem).foreach(new anonfun.main.3());
        Runtime.getRuntime().addShutdownHook(new anon.1(consumerConnector$1, threadList$1));
    }

    private ConsumerShell$() {
        MODULE$ = this;
    }
}

