/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.net.URI;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import kafka.consumer.SimpleConsumer;
import kafka.tools.GetOffsetShell$;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class GetOffsetShell$
implements ScalaObject {
    public static final GetOffsetShell$ MODULE$;

    static {
        new GetOffsetShell$();
    }

    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec<String> urlOpt = parser$1.accepts("server", "REQUIRED: The hostname of the server to connect to.").withRequiredArg().describedAs("kafka://hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> topicOpt = parser$1.accepts("topic", "REQUIRED: The topic to get offset from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec<Integer> partitionOpt = parser$1.accepts("partition", "partition id").withRequiredArg().describedAs("partition id").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Long> timeOpt = parser$1.accepts("time", "timestamp of the offsets before that").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class);
        ArgumentAcceptingOptionSpec<Integer> nOffsetsOpt = parser$1.accepts("offsets", "number of offsets returned").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1), (Integer[])((Object[])new Integer[0]));
        OptionSet options$1 = parser$1.parse(args);
        List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{urlOpt, topicOpt, timeOpt})).foreach(new anonfun.main.2(parser$1, options$1));
        URI url = new URI(options$1.valueOf(urlOpt));
        String topic = options$1.valueOf(topicOpt);
        int partition2 = options$1.valueOf(partitionOpt);
        long time = options$1.valueOf(timeOpt);
        int nOffsets = options$1.valueOf(nOffsetsOpt);
        SimpleConsumer consumer = new SimpleConsumer(url.getHost(), url.getPort(), 10000, 100000);
        long[] offsets = consumer.getOffsetsBefore(topic, partition2, time, nOffsets);
        Predef$.MODULE$.println(new StringBuilder().append((Object)"get ").append(BoxesRunTime.boxToInteger(offsets.length)).append((Object)" results").toString());
        Predef$.MODULE$.longArrayOps(offsets).foreach(new anonfun.main.1());
    }

    private GetOffsetShell$() {
        MODULE$ = this;
    }
}

