/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import kafka.tools.JmxTool$;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.math.Ordering$String$;
import scala.math.package$;
import scala.reflect.ClassManifest$;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JmxTool$
implements ScalaObject {
    public static final JmxTool$ MODULE$;

    static {
        new JmxTool$();
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> objectNameOpt = parser.accepts("object-name", "A JMX object name to use as a query. This can contain wild cards, and this option can be given multiple times to specify more than one query. If no objects are specified all objects will be queried.").withRequiredArg().describedAs("name").ofType(String.class);
        ArgumentAcceptingOptionSpec<Integer> reportingIntervalOpt = parser.accepts("reporting-interval", "Interval in MS with which to poll jmx stats.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(5000), (Integer[])((Object[])new Integer[0]));
        OptionSpecBuilder helpOpt = parser.accepts("help", "Print usage information.");
        ArgumentAcceptingOptionSpec<String> dateFormatOpt = parser.accepts("date-format", "The date format to use for formatting the time field. See java.text.SimpleDateFormat for options.").withRequiredArg().describedAs("format").ofType(String.class).defaultsTo("yyyy-MM-dd HH:mm:ss.SSS", (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<String> jmxServiceUrlOpt = parser.accepts("jmx-url", "The url to connect to to poll JMX data. See Oracle javadoc for JMXServiceURL for details.").withRequiredArg().describedAs("service-url").ofType(String.class).defaultsTo("service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String[])((Object[])new String[0]));
        OptionSet options = parser.parse(args);
        if (options.has(helpOpt)) {
            parser.printHelpOn(System.out);
            System.exit(0);
        }
        JMXServiceURL url = new JMXServiceURL(options.valueOf(jmxServiceUrlOpt));
        int interval = options.valueOf(reportingIntervalOpt);
        SimpleDateFormat dateFormat = new SimpleDateFormat(options.valueOf(dateFormatOpt));
        JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
        MBeanServerConnection mbsc$1 = jmxc.getMBeanServerConnection();
        GenTraversable queries = options.has(objectNameOpt) ? (Iterable)JavaConversions$.MODULE$.asBuffer(options.valuesOf(objectNameOpt)).map(new anonfun.1(), Buffer$.MODULE$.canBuildFrom()) : List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray(new Null$[]{null}));
        Iterable names = (Iterable)((GenericTraversableTemplate)queries.map(new anonfun.2(mbsc$1), Iterable$.MODULE$.canBuildFrom())).flatten(Predef$.MODULE$.conforms());
        Iterable attributes = names.map(new anonfun.3(mbsc$1), Iterable$.MODULE$.canBuildFrom());
        List keys = (List)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"time"})).$plus$plus(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.queryAttributes(mbsc$1, names).keys().toArray(ClassManifest$.MODULE$.classType(String.class))).sorted(Ordering$String$.MODULE$)), List$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println(((TraversableOnce)keys.map(new anonfun.main.1(), List$.MODULE$.canBuildFrom())).mkString(", "));
        while (true) {
            long start = System.currentTimeMillis();
            HashMap<String, Object> attributes$2 = this.queryAttributes(mbsc$1, names);
            attributes$2.update("time", dateFormat.format(new Date()));
            Predef$.MODULE$.println(((TraversableOnce)keys.map(new anonfun.main.2(attributes$2), List$.MODULE$.canBuildFrom())).mkString(", "));
            long sleep = package$.MODULE$.max(0L, (long)interval - (System.currentTimeMillis() - start));
            Thread.sleep(sleep);
        }
    }

    public HashMap<String, Object> queryAttributes(MBeanServerConnection mbsc$2, Iterable<ObjectName> names) {
        ObjectRef attributes$1 = new ObjectRef(new HashMap());
        names.foreach(new anonfun.queryAttributes.1(mbsc$2, attributes$1));
        return (HashMap)attributes$1.elem;
    }

    private JmxTool$() {
        MODULE$ = this;
    }
}

