/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.common.InvalidTopicException;
import kafka.server.KafkaConfig;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u001d3\u0001\"\u0001\u0002\u0005\u0002\u0003\u0005\ta\u0002\u0002\u0013)>\u0004\u0018n\u0019(b[\u00164\u0016\r\\5eCR|'O\u0003\u0002\u0004\t\u0005)Q\u000f^5mg*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001A\u0001\u0003\u0005\u0002\n\u001d5\t!B\u0003\u0002\f\u0019\u0005!A.\u00198h\u0015\u0005i\u0011\u0001\u00026bm\u0006L!a\u0004\u0006\u0003\r=\u0013'.Z2u!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011]\u0001!\u0011!Q\u0001\na\taaY8oM&<\u0007CA\r\u001d\u001b\u0005Q\"BA\u000e\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011QD\u0007\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0003C\r\u0002\"A\t\u0001\u000e\u0003\tAQa\u0006\u0010A\u0002aAq!\n\u0001C\u0002\u0013%a%\u0001\u0007jY2,w-\u00197DQ\u0006\u00148/F\u0001(!\tI\u0001&\u0003\u0002*\u0015\t11\u000b\u001e:j]\u001eDaa\u000b\u0001!\u0002\u00139\u0013!D5mY\u0016<\u0017\r\\\"iCJ\u001c\b\u0005C\u0004.\u0001\t\u0007I\u0011\u0002\u0018\u0002\u0007I<\u00070F\u00010!\t\u0001T'D\u00012\u0015\t\u00114'\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\t!$#\u0001\u0003vi&d\u0017B\u0001\u001c2\u0005\u0015\u0011VmZ3y\u0011\u0019A\u0004\u0001)A\u0005_\u0005!!o\u001a=!\u0011\u0015Q\u0004\u0001\"\u0001<\u0003!1\u0018\r\\5eCR,GC\u0001\u001f@!\t\tR(\u0003\u0002?%\t!QK\\5u\u0011\u0015\u0001\u0015\b1\u0001B\u0003\u0015!x\u000e]5d!\t\u0011UI\u0004\u0002\u0012\u0007&\u0011AIE\u0001\u0007!J,G-\u001a4\n\u0005%2%B\u0001#\u0013\u0001")
public class TopicNameValidator
implements ScalaObject {
    private final KafkaConfig config;
    private final String illegalChars;
    private final Regex rgx;

    private String illegalChars() {
        return this.illegalChars;
    }

    private Regex rgx() {
        return this.rgx;
    }

    public void validate(String topic) {
        if (topic.length() <= 0) {
            throw new InvalidTopicException("topic name is illegal, can't be empty");
        }
        if (topic.length() > this.config.maxTopicNameLength()) {
            throw new InvalidTopicException(new StringBuilder().append((Object)"topic name is illegal, can't be longer than ").append(BoxesRunTime.boxToInteger(this.config.maxTopicNameLength())).append((Object)" characters").toString());
        }
        Option<String> option = this.rgx().findFirstIn(topic);
        if (option instanceof Some) {
            throw new InvalidTopicException(new StringBuilder().append((Object)"topic name ").append((Object)topic).append((Object)" is illegal, doesn't match expected regular expression").toString());
        }
        None$ none$ = None$.MODULE$;
        Option<String> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            return;
        }
        throw new MatchError(option);
    }

    public TopicNameValidator(KafkaConfig config) {
        this.config = config;
        this.illegalChars = new StringBuilder().append((Object)"/").append(BoxesRunTime.boxToCharacter('\u0000')).append(BoxesRunTime.boxToCharacter('\u0001')).append((Object)"-").append(BoxesRunTime.boxToCharacter('\u001f')).append(BoxesRunTime.boxToCharacter('\u007f')).append((Object)"-").append(BoxesRunTime.boxToCharacter('\u009f')).append(BoxesRunTime.boxToCharacter('\ud800')).append((Object)"-").append(BoxesRunTime.boxToCharacter('\uf8ff')).append(BoxesRunTime.boxToCharacter('\ufff0')).append((Object)"-").append(BoxesRunTime.boxToCharacter('\uffff')).toString();
        this.rgx = new Regex(new StringBuilder().append((Object)"(^\\.{1,2}$)|[").append((Object)this.illegalChars()).append((Object)"]").toString(), Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }
}

