/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.bidimap;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.OrderedBidiMap;
import org.apache.commons.collections.OrderedIterator;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.iterators.EmptyOrderedMapIterator;
import org.apache.commons.collections.keyvalue.UnmodifiableMapEntry;

public class TreeBidiMap
implements OrderedBidiMap {
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int MAPENTRY = 2;
    private static final int INVERSEMAPENTRY = 3;
    private static final int SUM_OF_INDICES = 1;
    private static final int FIRST_INDEX = 0;
    private static final int NUMBER_OF_INDICES = 2;
    private static final String[] dataName = new String[]{"key", "value"};
    private Node[] rootNode = new Node[2];
    private int nodeCount = 0;
    private int modifications = 0;
    private Set keySet;
    private Set valuesSet;
    private Set entrySet;
    private Inverse inverse = null;

    public TreeBidiMap() {
    }

    public TreeBidiMap(Map map2) {
        this.putAll(map2);
    }

    public int size() {
        return this.nodeCount;
    }

    public boolean isEmpty() {
        return this.nodeCount == 0;
    }

    public boolean containsKey(Object key) {
        TreeBidiMap.checkKey(key);
        return this.lookup((Comparable)key, 0) != null;
    }

    public boolean containsValue(Object value2) {
        TreeBidiMap.checkValue(value2);
        return this.lookup((Comparable)value2, 1) != null;
    }

    public Object get(Object key) {
        return this.doGet((Comparable)key, 0);
    }

    public Object put(Object key, Object value2) {
        return this.doPut((Comparable)key, (Comparable)value2, 0);
    }

    public void putAll(Map map2) {
        Iterator it = map2.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        return this.doRemove((Comparable)key, 0);
    }

    public void clear() {
        this.modify();
        this.nodeCount = 0;
        this.rootNode[0] = null;
        this.rootNode[1] = null;
    }

    public Object getKey(Object value2) {
        return this.doGet((Comparable)value2, 1);
    }

    public Object removeValue(Object value2) {
        return this.doRemove((Comparable)value2, 1);
    }

    public Object firstKey() {
        if (this.nodeCount == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return TreeBidiMap.leastNode(this.rootNode[0], 0).getKey();
    }

    public Object lastKey() {
        if (this.nodeCount == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return TreeBidiMap.greatestNode(this.rootNode[0], 0).getKey();
    }

    public Object nextKey(Object key) {
        TreeBidiMap.checkKey(key);
        Node node = this.nextGreater(this.lookup((Comparable)key, 0), 0);
        return node == null ? null : node.getKey();
    }

    public Object previousKey(Object key) {
        TreeBidiMap.checkKey(key);
        Node node = this.nextSmaller(this.lookup((Comparable)key, 0), 0);
        return node == null ? null : node.getKey();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new View(this, 0, 0);
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.valuesSet == null) {
            this.valuesSet = new View(this, 0, 1);
        }
        return this.valuesSet;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            return new EntryView(this, 0, 2);
        }
        return this.entrySet;
    }

    public MapIterator mapIterator() {
        if (this.isEmpty()) {
            return EmptyOrderedMapIterator.INSTANCE;
        }
        return new ViewMapIterator(this, 0);
    }

    public OrderedMapIterator orderedMapIterator() {
        if (this.isEmpty()) {
            return EmptyOrderedMapIterator.INSTANCE;
        }
        return new ViewMapIterator(this, 0);
    }

    public BidiMap inverseBidiMap() {
        return this.inverseOrderedBidiMap();
    }

    public OrderedBidiMap inverseOrderedBidiMap() {
        if (this.inverse == null) {
            this.inverse = new Inverse(this);
        }
        return this.inverse;
    }

    public boolean equals(Object obj) {
        return this.doEquals(obj, 0);
    }

    public int hashCode() {
        return this.doHashCode(0);
    }

    public String toString() {
        return this.doToString(0);
    }

    private Object doGet(Comparable obj, int index2) {
        TreeBidiMap.checkNonNullComparable(obj, index2);
        Node node = this.lookup(obj, index2);
        return node == null ? null : node.getData(TreeBidiMap.oppositeIndex(index2));
    }

    private Object doPut(Comparable key, Comparable value2, int index2) {
        Object prev;
        block6: {
            TreeBidiMap.checkKeyAndValue(key, value2);
            prev = index2 == 0 ? this.doGet(key, 0) : this.doGet(value2, 1);
            this.doRemove(key, 0);
            this.doRemove(value2, 1);
            Node node = this.rootNode[0];
            if (node == null) {
                Node root2;
                this.rootNode[0] = root2 = new Node(key, value2);
                this.rootNode[1] = root2;
                this.grow();
            } else {
                while (true) {
                    int cmp;
                    if ((cmp = TreeBidiMap.compare(key, node.getData(0))) == 0) {
                        throw new IllegalArgumentException("Cannot store a duplicate key (\"" + key + "\") in this Map");
                    }
                    if (cmp < 0) {
                        if (node.getLeft(0) != null) {
                            node = node.getLeft(0);
                            continue;
                        }
                        Node newNode = new Node(key, value2);
                        this.insertValue(newNode);
                        node.setLeft(newNode, 0);
                        newNode.setParent(node, 0);
                        this.doRedBlackInsert(newNode, 0);
                        this.grow();
                        break block6;
                    }
                    if (node.getRight(0) == null) break;
                    node = node.getRight(0);
                }
                Node newNode = new Node(key, value2);
                this.insertValue(newNode);
                node.setRight(newNode, 0);
                newNode.setParent(node, 0);
                this.doRedBlackInsert(newNode, 0);
                this.grow();
            }
        }
        return prev;
    }

    private Object doRemove(Comparable o, int index2) {
        Node node = this.lookup(o, index2);
        Comparable rval = null;
        if (node != null) {
            rval = node.getData(TreeBidiMap.oppositeIndex(index2));
            this.doRedBlackDelete(node);
        }
        return rval;
    }

    private Node lookup(Comparable data2, int index2) {
        Node rval = null;
        Node node = this.rootNode[index2];
        while (node != null) {
            int cmp = TreeBidiMap.compare(data2, node.getData(index2));
            if (cmp == 0) {
                rval = node;
                break;
            }
            node = cmp < 0 ? node.getLeft(index2) : node.getRight(index2);
        }
        return rval;
    }

    private Node nextGreater(Node node, int index2) {
        Node rval = null;
        if (node == null) {
            rval = null;
        } else if (node.getRight(index2) != null) {
            rval = TreeBidiMap.leastNode(node.getRight(index2), index2);
        } else {
            Node parent = node.getParent(index2);
            Node child = node;
            while (parent != null && child == parent.getRight(index2)) {
                child = parent;
                parent = parent.getParent(index2);
            }
            rval = parent;
        }
        return rval;
    }

    private Node nextSmaller(Node node, int index2) {
        Node rval = null;
        if (node == null) {
            rval = null;
        } else if (node.getLeft(index2) != null) {
            rval = TreeBidiMap.greatestNode(node.getLeft(index2), index2);
        } else {
            Node parent = node.getParent(index2);
            Node child = node;
            while (parent != null && child == parent.getLeft(index2)) {
                child = parent;
                parent = parent.getParent(index2);
            }
            rval = parent;
        }
        return rval;
    }

    private static int oppositeIndex(int index2) {
        return 1 - index2;
    }

    private static int compare(Comparable o1, Comparable o2) {
        return o1.compareTo(o2);
    }

    private static Node leastNode(Node node, int index2) {
        Node rval = node;
        if (rval != null) {
            while (rval.getLeft(index2) != null) {
                rval = rval.getLeft(index2);
            }
        }
        return rval;
    }

    private static Node greatestNode(Node node, int index2) {
        Node rval = node;
        if (rval != null) {
            while (rval.getRight(index2) != null) {
                rval = rval.getRight(index2);
            }
        }
        return rval;
    }

    private static void copyColor(Node from2, Node to2, int index2) {
        if (to2 != null) {
            if (from2 == null) {
                to2.setBlack(index2);
            } else {
                to2.copyColor(from2, index2);
            }
        }
    }

    private static boolean isRed(Node node, int index2) {
        return node == null ? false : node.isRed(index2);
    }

    private static boolean isBlack(Node node, int index2) {
        return node == null ? true : node.isBlack(index2);
    }

    private static void makeRed(Node node, int index2) {
        if (node != null) {
            node.setRed(index2);
        }
    }

    private static void makeBlack(Node node, int index2) {
        if (node != null) {
            node.setBlack(index2);
        }
    }

    private static Node getGrandParent(Node node, int index2) {
        return TreeBidiMap.getParent(TreeBidiMap.getParent(node, index2), index2);
    }

    private static Node getParent(Node node, int index2) {
        return node == null ? null : node.getParent(index2);
    }

    private static Node getRightChild(Node node, int index2) {
        return node == null ? null : node.getRight(index2);
    }

    private static Node getLeftChild(Node node, int index2) {
        return node == null ? null : node.getLeft(index2);
    }

    private static boolean isLeftChild(Node node, int index2) {
        return node == null ? true : (node.getParent(index2) == null ? false : node == node.getParent(index2).getLeft(index2));
    }

    private static boolean isRightChild(Node node, int index2) {
        return node == null ? true : (node.getParent(index2) == null ? false : node == node.getParent(index2).getRight(index2));
    }

    private void rotateLeft(Node node, int index2) {
        Node rightChild = node.getRight(index2);
        node.setRight(rightChild.getLeft(index2), index2);
        if (rightChild.getLeft(index2) != null) {
            rightChild.getLeft(index2).setParent(node, index2);
        }
        rightChild.setParent(node.getParent(index2), index2);
        if (node.getParent(index2) == null) {
            this.rootNode[index2] = rightChild;
        } else if (node.getParent(index2).getLeft(index2) == node) {
            node.getParent(index2).setLeft(rightChild, index2);
        } else {
            node.getParent(index2).setRight(rightChild, index2);
        }
        rightChild.setLeft(node, index2);
        node.setParent(rightChild, index2);
    }

    private void rotateRight(Node node, int index2) {
        Node leftChild = node.getLeft(index2);
        node.setLeft(leftChild.getRight(index2), index2);
        if (leftChild.getRight(index2) != null) {
            leftChild.getRight(index2).setParent(node, index2);
        }
        leftChild.setParent(node.getParent(index2), index2);
        if (node.getParent(index2) == null) {
            this.rootNode[index2] = leftChild;
        } else if (node.getParent(index2).getRight(index2) == node) {
            node.getParent(index2).setRight(leftChild, index2);
        } else {
            node.getParent(index2).setLeft(leftChild, index2);
        }
        leftChild.setRight(node, index2);
        node.setParent(leftChild, index2);
    }

    private void doRedBlackInsert(Node insertedNode, int index2) {
        Node currentNode = insertedNode;
        TreeBidiMap.makeRed(currentNode, index2);
        while (currentNode != null && currentNode != this.rootNode[index2] && TreeBidiMap.isRed(currentNode.getParent(index2), index2)) {
            Node y;
            if (TreeBidiMap.isLeftChild(TreeBidiMap.getParent(currentNode, index2), index2)) {
                y = TreeBidiMap.getRightChild(TreeBidiMap.getGrandParent(currentNode, index2), index2);
                if (TreeBidiMap.isRed(y, index2)) {
                    TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index2), index2);
                    TreeBidiMap.makeBlack(y, index2);
                    TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(currentNode, index2), index2);
                    currentNode = TreeBidiMap.getGrandParent(currentNode, index2);
                    continue;
                }
                if (TreeBidiMap.isRightChild(currentNode, index2)) {
                    currentNode = TreeBidiMap.getParent(currentNode, index2);
                    this.rotateLeft(currentNode, index2);
                }
                TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index2), index2);
                TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(currentNode, index2), index2);
                if (TreeBidiMap.getGrandParent(currentNode, index2) == null) continue;
                this.rotateRight(TreeBidiMap.getGrandParent(currentNode, index2), index2);
                continue;
            }
            y = TreeBidiMap.getLeftChild(TreeBidiMap.getGrandParent(currentNode, index2), index2);
            if (TreeBidiMap.isRed(y, index2)) {
                TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index2), index2);
                TreeBidiMap.makeBlack(y, index2);
                TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(currentNode, index2), index2);
                currentNode = TreeBidiMap.getGrandParent(currentNode, index2);
                continue;
            }
            if (TreeBidiMap.isLeftChild(currentNode, index2)) {
                currentNode = TreeBidiMap.getParent(currentNode, index2);
                this.rotateRight(currentNode, index2);
            }
            TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index2), index2);
            TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(currentNode, index2), index2);
            if (TreeBidiMap.getGrandParent(currentNode, index2) == null) continue;
            this.rotateLeft(TreeBidiMap.getGrandParent(currentNode, index2), index2);
        }
        TreeBidiMap.makeBlack(this.rootNode[index2], index2);
    }

    private void doRedBlackDelete(Node deletedNode) {
        for (int index2 = 0; index2 < 2; ++index2) {
            Node replacement;
            if (deletedNode.getLeft(index2) != null && deletedNode.getRight(index2) != null) {
                this.swapPosition(this.nextGreater(deletedNode, index2), deletedNode, index2);
            }
            Node node = replacement = deletedNode.getLeft(index2) != null ? deletedNode.getLeft(index2) : deletedNode.getRight(index2);
            if (replacement != null) {
                replacement.setParent(deletedNode.getParent(index2), index2);
                if (deletedNode.getParent(index2) == null) {
                    this.rootNode[index2] = replacement;
                } else if (deletedNode == deletedNode.getParent(index2).getLeft(index2)) {
                    deletedNode.getParent(index2).setLeft(replacement, index2);
                } else {
                    deletedNode.getParent(index2).setRight(replacement, index2);
                }
                deletedNode.setLeft(null, index2);
                deletedNode.setRight(null, index2);
                deletedNode.setParent(null, index2);
                if (!TreeBidiMap.isBlack(deletedNode, index2)) continue;
                this.doRedBlackDeleteFixup(replacement, index2);
                continue;
            }
            if (deletedNode.getParent(index2) == null) {
                this.rootNode[index2] = null;
                continue;
            }
            if (TreeBidiMap.isBlack(deletedNode, index2)) {
                this.doRedBlackDeleteFixup(deletedNode, index2);
            }
            if (deletedNode.getParent(index2) == null) continue;
            if (deletedNode == deletedNode.getParent(index2).getLeft(index2)) {
                deletedNode.getParent(index2).setLeft(null, index2);
            } else {
                deletedNode.getParent(index2).setRight(null, index2);
            }
            deletedNode.setParent(null, index2);
        }
        this.shrink();
    }

    private void doRedBlackDeleteFixup(Node replacementNode, int index2) {
        Node currentNode = replacementNode;
        while (currentNode != this.rootNode[index2] && TreeBidiMap.isBlack(currentNode, index2)) {
            Node siblingNode;
            if (TreeBidiMap.isLeftChild(currentNode, index2)) {
                siblingNode = TreeBidiMap.getRightChild(TreeBidiMap.getParent(currentNode, index2), index2);
                if (TreeBidiMap.isRed(siblingNode, index2)) {
                    TreeBidiMap.makeBlack(siblingNode, index2);
                    TreeBidiMap.makeRed(TreeBidiMap.getParent(currentNode, index2), index2);
                    this.rotateLeft(TreeBidiMap.getParent(currentNode, index2), index2);
                    siblingNode = TreeBidiMap.getRightChild(TreeBidiMap.getParent(currentNode, index2), index2);
                }
                if (TreeBidiMap.isBlack(TreeBidiMap.getLeftChild(siblingNode, index2), index2) && TreeBidiMap.isBlack(TreeBidiMap.getRightChild(siblingNode, index2), index2)) {
                    TreeBidiMap.makeRed(siblingNode, index2);
                    currentNode = TreeBidiMap.getParent(currentNode, index2);
                    continue;
                }
                if (TreeBidiMap.isBlack(TreeBidiMap.getRightChild(siblingNode, index2), index2)) {
                    TreeBidiMap.makeBlack(TreeBidiMap.getLeftChild(siblingNode, index2), index2);
                    TreeBidiMap.makeRed(siblingNode, index2);
                    this.rotateRight(siblingNode, index2);
                    siblingNode = TreeBidiMap.getRightChild(TreeBidiMap.getParent(currentNode, index2), index2);
                }
                TreeBidiMap.copyColor(TreeBidiMap.getParent(currentNode, index2), siblingNode, index2);
                TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index2), index2);
                TreeBidiMap.makeBlack(TreeBidiMap.getRightChild(siblingNode, index2), index2);
                this.rotateLeft(TreeBidiMap.getParent(currentNode, index2), index2);
                currentNode = this.rootNode[index2];
                continue;
            }
            siblingNode = TreeBidiMap.getLeftChild(TreeBidiMap.getParent(currentNode, index2), index2);
            if (TreeBidiMap.isRed(siblingNode, index2)) {
                TreeBidiMap.makeBlack(siblingNode, index2);
                TreeBidiMap.makeRed(TreeBidiMap.getParent(currentNode, index2), index2);
                this.rotateRight(TreeBidiMap.getParent(currentNode, index2), index2);
                siblingNode = TreeBidiMap.getLeftChild(TreeBidiMap.getParent(currentNode, index2), index2);
            }
            if (TreeBidiMap.isBlack(TreeBidiMap.getRightChild(siblingNode, index2), index2) && TreeBidiMap.isBlack(TreeBidiMap.getLeftChild(siblingNode, index2), index2)) {
                TreeBidiMap.makeRed(siblingNode, index2);
                currentNode = TreeBidiMap.getParent(currentNode, index2);
                continue;
            }
            if (TreeBidiMap.isBlack(TreeBidiMap.getLeftChild(siblingNode, index2), index2)) {
                TreeBidiMap.makeBlack(TreeBidiMap.getRightChild(siblingNode, index2), index2);
                TreeBidiMap.makeRed(siblingNode, index2);
                this.rotateLeft(siblingNode, index2);
                siblingNode = TreeBidiMap.getLeftChild(TreeBidiMap.getParent(currentNode, index2), index2);
            }
            TreeBidiMap.copyColor(TreeBidiMap.getParent(currentNode, index2), siblingNode, index2);
            TreeBidiMap.makeBlack(TreeBidiMap.getParent(currentNode, index2), index2);
            TreeBidiMap.makeBlack(TreeBidiMap.getLeftChild(siblingNode, index2), index2);
            this.rotateRight(TreeBidiMap.getParent(currentNode, index2), index2);
            currentNode = this.rootNode[index2];
        }
        TreeBidiMap.makeBlack(currentNode, index2);
    }

    private void swapPosition(Node x, Node y, int index2) {
        boolean yWasLeftChild;
        Node xFormerParent = x.getParent(index2);
        Node xFormerLeftChild = x.getLeft(index2);
        Node xFormerRightChild = x.getRight(index2);
        Node yFormerParent = y.getParent(index2);
        Node yFormerLeftChild = y.getLeft(index2);
        Node yFormerRightChild = y.getRight(index2);
        boolean xWasLeftChild = x.getParent(index2) != null && x == x.getParent(index2).getLeft(index2);
        boolean bl = yWasLeftChild = y.getParent(index2) != null && y == y.getParent(index2).getLeft(index2);
        if (x == yFormerParent) {
            x.setParent(y, index2);
            if (yWasLeftChild) {
                y.setLeft(x, index2);
                y.setRight(xFormerRightChild, index2);
            } else {
                y.setRight(x, index2);
                y.setLeft(xFormerLeftChild, index2);
            }
        } else {
            x.setParent(yFormerParent, index2);
            if (yFormerParent != null) {
                if (yWasLeftChild) {
                    yFormerParent.setLeft(x, index2);
                } else {
                    yFormerParent.setRight(x, index2);
                }
            }
            y.setLeft(xFormerLeftChild, index2);
            y.setRight(xFormerRightChild, index2);
        }
        if (y == xFormerParent) {
            y.setParent(x, index2);
            if (xWasLeftChild) {
                x.setLeft(y, index2);
                x.setRight(yFormerRightChild, index2);
            } else {
                x.setRight(y, index2);
                x.setLeft(yFormerLeftChild, index2);
            }
        } else {
            y.setParent(xFormerParent, index2);
            if (xFormerParent != null) {
                if (xWasLeftChild) {
                    xFormerParent.setLeft(y, index2);
                } else {
                    xFormerParent.setRight(y, index2);
                }
            }
            x.setLeft(yFormerLeftChild, index2);
            x.setRight(yFormerRightChild, index2);
        }
        if (x.getLeft(index2) != null) {
            x.getLeft(index2).setParent(x, index2);
        }
        if (x.getRight(index2) != null) {
            x.getRight(index2).setParent(x, index2);
        }
        if (y.getLeft(index2) != null) {
            y.getLeft(index2).setParent(y, index2);
        }
        if (y.getRight(index2) != null) {
            y.getRight(index2).setParent(y, index2);
        }
        x.swapColors(y, index2);
        if (this.rootNode[index2] == x) {
            this.rootNode[index2] = y;
        } else if (this.rootNode[index2] == y) {
            this.rootNode[index2] = x;
        }
    }

    private static void checkNonNullComparable(Object o, int index2) {
        if (o == null) {
            throw new NullPointerException(dataName[index2] + " cannot be null");
        }
        if (!(o instanceof Comparable)) {
            throw new ClassCastException(dataName[index2] + " must be Comparable");
        }
    }

    private static void checkKey(Object key) {
        TreeBidiMap.checkNonNullComparable(key, 0);
    }

    private static void checkValue(Object value2) {
        TreeBidiMap.checkNonNullComparable(value2, 1);
    }

    private static void checkKeyAndValue(Object key, Object value2) {
        TreeBidiMap.checkKey(key);
        TreeBidiMap.checkValue(value2);
    }

    private void modify() {
        ++this.modifications;
    }

    private void grow() {
        this.modify();
        ++this.nodeCount;
    }

    private void shrink() {
        this.modify();
        --this.nodeCount;
    }

    private void insertValue(Node newNode) throws IllegalArgumentException {
        block4: {
            Node node = this.rootNode[1];
            while (true) {
                int cmp;
                if ((cmp = TreeBidiMap.compare(newNode.getData(1), node.getData(1))) == 0) {
                    throw new IllegalArgumentException("Cannot store a duplicate value (\"" + newNode.getData(1) + "\") in this Map");
                }
                if (cmp < 0) {
                    if (node.getLeft(1) != null) {
                        node = node.getLeft(1);
                        continue;
                    }
                    node.setLeft(newNode, 1);
                    newNode.setParent(node, 1);
                    this.doRedBlackInsert(newNode, 1);
                    break block4;
                }
                if (node.getRight(1) == null) break;
                node = node.getRight(1);
            }
            node.setRight(newNode, 1);
            newNode.setParent(node, 1);
            this.doRedBlackInsert(newNode, 1);
        }
    }

    private boolean doEquals(Object obj, int type) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        if (other.size() != this.size()) {
            return false;
        }
        if (this.nodeCount > 0) {
            try {
                ViewMapIterator it = new ViewMapIterator(this, type);
                while (it.hasNext()) {
                    Object key = it.next();
                    Object value2 = it.getValue();
                    if (value2.equals(other.get(key))) continue;
                    return false;
                }
            }
            catch (ClassCastException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return true;
    }

    private int doHashCode(int type) {
        int total = 0;
        if (this.nodeCount > 0) {
            ViewMapIterator it = new ViewMapIterator(this, type);
            while (it.hasNext()) {
                Object key = it.next();
                Object value2 = it.getValue();
                total += key.hashCode() ^ value2.hashCode();
            }
        }
        return total;
    }

    private String doToString(int type) {
        if (this.nodeCount == 0) {
            return "{}";
        }
        StringBuffer buf = new StringBuffer(this.nodeCount * 32);
        buf.append('{');
        ViewMapIterator it = new ViewMapIterator(this, type);
        boolean hasNext = it.hasNext();
        while (hasNext) {
            Object key = it.next();
            Object value2 = it.getValue();
            buf.append(key == this ? "(this Map)" : key).append('=').append(value2 == this ? "(this Map)" : value2);
            hasNext = it.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append('}');
        return buf.toString();
    }

    static class Inverse
    implements OrderedBidiMap {
        private final TreeBidiMap main;
        private Set keySet;
        private Set valuesSet;
        private Set entrySet;

        Inverse(TreeBidiMap main2) {
            this.main = main2;
        }

        public int size() {
            return this.main.size();
        }

        public boolean isEmpty() {
            return this.main.isEmpty();
        }

        public Object get(Object key) {
            return this.main.getKey(key);
        }

        public Object getKey(Object value2) {
            return this.main.get(value2);
        }

        public boolean containsKey(Object key) {
            return this.main.containsValue(key);
        }

        public boolean containsValue(Object value2) {
            return this.main.containsKey(value2);
        }

        public Object firstKey() {
            if (this.main.nodeCount == 0) {
                throw new NoSuchElementException("Map is empty");
            }
            return TreeBidiMap.leastNode(this.main.rootNode[1], 1).getValue();
        }

        public Object lastKey() {
            if (this.main.nodeCount == 0) {
                throw new NoSuchElementException("Map is empty");
            }
            return TreeBidiMap.greatestNode(this.main.rootNode[1], 1).getValue();
        }

        public Object nextKey(Object key) {
            TreeBidiMap.checkKey(key);
            Node node = this.main.nextGreater(this.main.lookup((Comparable)key, 1), 1);
            return node == null ? null : node.getValue();
        }

        public Object previousKey(Object key) {
            TreeBidiMap.checkKey(key);
            Node node = this.main.nextSmaller(this.main.lookup((Comparable)key, 1), 1);
            return node == null ? null : node.getValue();
        }

        public Object put(Object key, Object value2) {
            return this.main.doPut((Comparable)value2, (Comparable)key, 1);
        }

        public void putAll(Map map2) {
            Iterator it = map2.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public Object remove(Object key) {
            return this.main.removeValue(key);
        }

        public Object removeValue(Object value2) {
            return this.main.remove(value2);
        }

        public void clear() {
            this.main.clear();
        }

        public Set keySet() {
            if (this.keySet == null) {
                this.keySet = new View(this.main, 1, 1);
            }
            return this.keySet;
        }

        public Collection values() {
            if (this.valuesSet == null) {
                this.valuesSet = new View(this.main, 1, 0);
            }
            return this.valuesSet;
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                return new EntryView(this.main, 1, 3);
            }
            return this.entrySet;
        }

        public MapIterator mapIterator() {
            if (this.isEmpty()) {
                return EmptyOrderedMapIterator.INSTANCE;
            }
            return new ViewMapIterator(this.main, 1);
        }

        public OrderedMapIterator orderedMapIterator() {
            if (this.isEmpty()) {
                return EmptyOrderedMapIterator.INSTANCE;
            }
            return new ViewMapIterator(this.main, 1);
        }

        public BidiMap inverseBidiMap() {
            return this.main;
        }

        public OrderedBidiMap inverseOrderedBidiMap() {
            return this.main;
        }

        public boolean equals(Object obj) {
            return this.main.doEquals(obj, 1);
        }

        public int hashCode() {
            return this.main.doHashCode(1);
        }

        public String toString() {
            return this.main.doToString(1);
        }
    }

    static class Node
    implements Map.Entry,
    KeyValue {
        private Comparable[] data;
        private Node[] leftNode;
        private Node[] rightNode;
        private Node[] parentNode;
        private boolean[] blackColor;
        private int hashcodeValue;
        private boolean calculatedHashCode;

        Node(Comparable key, Comparable value2) {
            this.data = new Comparable[]{key, value2};
            this.leftNode = new Node[2];
            this.rightNode = new Node[2];
            this.parentNode = new Node[2];
            this.blackColor = new boolean[]{true, true};
            this.calculatedHashCode = false;
        }

        private Comparable getData(int index2) {
            return this.data[index2];
        }

        private void setLeft(Node node, int index2) {
            this.leftNode[index2] = node;
        }

        private Node getLeft(int index2) {
            return this.leftNode[index2];
        }

        private void setRight(Node node, int index2) {
            this.rightNode[index2] = node;
        }

        private Node getRight(int index2) {
            return this.rightNode[index2];
        }

        private void setParent(Node node, int index2) {
            this.parentNode[index2] = node;
        }

        private Node getParent(int index2) {
            return this.parentNode[index2];
        }

        private void swapColors(Node node, int index2) {
            int n = index2;
            this.blackColor[n] = this.blackColor[n] ^ node.blackColor[index2];
            int n2 = index2;
            node.blackColor[n2] = node.blackColor[n2] ^ this.blackColor[index2];
            int n3 = index2;
            this.blackColor[n3] = this.blackColor[n3] ^ node.blackColor[index2];
        }

        private boolean isBlack(int index2) {
            return this.blackColor[index2];
        }

        private boolean isRed(int index2) {
            return !this.blackColor[index2];
        }

        private void setBlack(int index2) {
            this.blackColor[index2] = true;
        }

        private void setRed(int index2) {
            this.blackColor[index2] = false;
        }

        private void copyColor(Node node, int index2) {
            this.blackColor[index2] = node.blackColor[index2];
        }

        public Object getKey() {
            return this.data[0];
        }

        public Object getValue() {
            return this.data[1];
        }

        public Object setValue(Object ignored) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Map.Entry.setValue is not supported");
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)obj;
            return this.data[0].equals(e.getKey()) && this.data[1].equals(e.getValue());
        }

        public int hashCode() {
            if (!this.calculatedHashCode) {
                this.hashcodeValue = this.data[0].hashCode() ^ this.data[1].hashCode();
                this.calculatedHashCode = true;
            }
            return this.hashcodeValue;
        }
    }

    static class EntryView
    extends View {
        private final int oppositeType;

        EntryView(TreeBidiMap main2, int orderType, int dataType) {
            super(main2, orderType, dataType);
            this.oppositeType = TreeBidiMap.oppositeIndex(orderType);
        }

        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object value2 = entry.getValue();
            Node node = this.main.lookup((Comparable)entry.getKey(), this.orderType);
            return node != null && node.getData(this.oppositeType).equals(value2);
        }

        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object value2 = entry.getValue();
            Node node = this.main.lookup((Comparable)entry.getKey(), this.orderType);
            if (node != null && node.getData(this.oppositeType).equals(value2)) {
                this.main.doRedBlackDelete(node);
                return true;
            }
            return false;
        }
    }

    static class ViewMapIterator
    extends ViewIterator
    implements OrderedMapIterator {
        private final int oppositeType;

        ViewMapIterator(TreeBidiMap main2, int orderType) {
            super(main2, orderType, orderType);
            this.oppositeType = TreeBidiMap.oppositeIndex(this.dataType);
        }

        public Object getKey() {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException("Iterator getKey() can only be called after next() and before remove()");
            }
            return this.lastReturnedNode.getData(this.dataType);
        }

        public Object getValue() {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException("Iterator getValue() can only be called after next() and before remove()");
            }
            return this.lastReturnedNode.getData(this.oppositeType);
        }

        public Object setValue(Object obj) {
            throw new UnsupportedOperationException();
        }
    }

    static class ViewIterator
    implements OrderedIterator {
        protected final TreeBidiMap main;
        protected final int orderType;
        protected final int dataType;
        protected Node lastReturnedNode;
        protected Node nextNode;
        protected Node previousNode;
        private int expectedModifications;

        ViewIterator(TreeBidiMap main2, int orderType, int dataType) {
            this.main = main2;
            this.orderType = orderType;
            this.dataType = dataType;
            this.expectedModifications = main2.modifications;
            this.nextNode = TreeBidiMap.leastNode(main2.rootNode[orderType], orderType);
            this.lastReturnedNode = null;
            this.previousNode = null;
        }

        public final boolean hasNext() {
            return this.nextNode != null;
        }

        public final Object next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            if (this.main.modifications != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.lastReturnedNode = this.nextNode;
            this.previousNode = this.nextNode;
            this.nextNode = this.main.nextGreater(this.nextNode, this.orderType);
            return this.doGetData();
        }

        public boolean hasPrevious() {
            return this.previousNode != null;
        }

        public Object previous() {
            if (this.previousNode == null) {
                throw new NoSuchElementException();
            }
            if (this.main.modifications != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.nextNode = this.lastReturnedNode;
            if (this.nextNode == null) {
                this.nextNode = this.main.nextGreater(this.previousNode, this.orderType);
            }
            this.lastReturnedNode = this.previousNode;
            this.previousNode = this.main.nextSmaller(this.previousNode, this.orderType);
            return this.doGetData();
        }

        protected Object doGetData() {
            switch (this.dataType) {
                case 0: {
                    return this.lastReturnedNode.getKey();
                }
                case 1: {
                    return this.lastReturnedNode.getValue();
                }
                case 2: {
                    return this.lastReturnedNode;
                }
                case 3: {
                    return new UnmodifiableMapEntry(this.lastReturnedNode.getValue(), this.lastReturnedNode.getKey());
                }
            }
            return null;
        }

        public final void remove() {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException();
            }
            if (this.main.modifications != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.main.doRedBlackDelete(this.lastReturnedNode);
            ++this.expectedModifications;
            this.lastReturnedNode = null;
            this.previousNode = this.nextNode == null ? TreeBidiMap.greatestNode(this.main.rootNode[this.orderType], this.orderType) : this.main.nextSmaller(this.nextNode, this.orderType);
        }
    }

    static class View
    extends AbstractSet {
        protected final TreeBidiMap main;
        protected final int orderType;
        protected final int dataType;

        View(TreeBidiMap main2, int orderType, int dataType) {
            this.main = main2;
            this.orderType = orderType;
            this.dataType = dataType;
        }

        public Iterator iterator() {
            return new ViewIterator(this.main, this.orderType, this.dataType);
        }

        public int size() {
            return this.main.size();
        }

        public boolean contains(Object obj) {
            TreeBidiMap.checkNonNullComparable(obj, this.dataType);
            return this.main.lookup((Comparable)obj, this.dataType) != null;
        }

        public boolean remove(Object obj) {
            return this.main.doRemove((Comparable)obj, this.dataType) != null;
        }

        public void clear() {
            this.main.clear();
        }
    }
}

