/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.ConfigurationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeConfiguration
extends AbstractConfiguration
implements Cloneable {
    private List<Configuration> configList = new LinkedList<Configuration>();
    private Configuration inMemoryConfiguration;
    private boolean inMemoryConfigIsChild;

    public CompositeConfiguration() {
        this.clear();
    }

    public CompositeConfiguration(Configuration inMemoryConfiguration) {
        this.configList.clear();
        this.inMemoryConfiguration = inMemoryConfiguration;
        this.configList.add(inMemoryConfiguration);
    }

    public CompositeConfiguration(Collection<? extends Configuration> configurations) {
        this(new BaseConfiguration(), configurations);
    }

    public CompositeConfiguration(Configuration inMemoryConfiguration, Collection<? extends Configuration> configurations) {
        this(inMemoryConfiguration);
        if (configurations != null) {
            for (Configuration configuration : configurations) {
                this.addConfiguration(configuration);
            }
        }
    }

    public void addConfiguration(Configuration config) {
        this.addConfiguration(config, false);
    }

    public void addConfiguration(Configuration config, boolean asInMemory) {
        if (!this.configList.contains(config)) {
            if (asInMemory) {
                this.replaceInMemoryConfiguration(config);
                this.inMemoryConfigIsChild = true;
            }
            if (!this.inMemoryConfigIsChild) {
                this.configList.add(this.configList.indexOf(this.inMemoryConfiguration), config);
            } else {
                this.configList.add(config);
            }
            if (config instanceof AbstractConfiguration) {
                ((AbstractConfiguration)config).setThrowExceptionOnMissing(this.isThrowExceptionOnMissing());
            }
        }
    }

    public void removeConfiguration(Configuration config) {
        if (!config.equals(this.inMemoryConfiguration)) {
            this.configList.remove(config);
        }
    }

    public int getNumberOfConfigurations() {
        return this.configList.size();
    }

    @Override
    public void clear() {
        this.configList.clear();
        this.inMemoryConfiguration = new BaseConfiguration();
        ((BaseConfiguration)this.inMemoryConfiguration).setThrowExceptionOnMissing(this.isThrowExceptionOnMissing());
        ((BaseConfiguration)this.inMemoryConfiguration).setListDelimiter(this.getListDelimiter());
        ((BaseConfiguration)this.inMemoryConfiguration).setDelimiterParsingDisabled(this.isDelimiterParsingDisabled());
        this.configList.add(this.inMemoryConfiguration);
        this.inMemoryConfigIsChild = false;
    }

    @Override
    protected void addPropertyDirect(String key, Object token2) {
        this.inMemoryConfiguration.addProperty(key, token2);
    }

    @Override
    public Object getProperty(String key) {
        Configuration firstMatchingConfiguration = null;
        for (Configuration config : this.configList) {
            if (!config.containsKey(key)) continue;
            firstMatchingConfiguration = config;
            break;
        }
        if (firstMatchingConfiguration != null) {
            return firstMatchingConfiguration.getProperty(key);
        }
        return null;
    }

    @Override
    public Iterator<String> getKeys() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (Configuration config : this.configList) {
            Iterator<String> it = config.getKeys();
            while (it.hasNext()) {
                keys.add(it.next());
            }
        }
        return keys.iterator();
    }

    @Override
    public Iterator<String> getKeys(String key) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (Configuration config : this.configList) {
            Iterator<String> it = config.getKeys(key);
            while (it.hasNext()) {
                keys.add(it.next());
            }
        }
        return keys.iterator();
    }

    @Override
    public boolean isEmpty() {
        for (Configuration config : this.configList) {
            if (config.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void clearPropertyDirect(String key) {
        for (Configuration config : this.configList) {
            config.clearProperty(key);
        }
    }

    @Override
    public boolean containsKey(String key) {
        for (Configuration config : this.configList) {
            if (!config.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Object> getList(String key, List<?> defaultValue) {
        ArrayList<Object> list2 = new ArrayList<Object>();
        Iterator<Configuration> it = this.configList.iterator();
        while (it.hasNext() && list2.isEmpty()) {
            Configuration config = it.next();
            if (config == this.inMemoryConfiguration || !config.containsKey(key)) continue;
            CompositeConfiguration.appendListProperty(list2, config, key);
        }
        CompositeConfiguration.appendListProperty(list2, this.inMemoryConfiguration, key);
        if (list2.isEmpty()) {
            return defaultValue;
        }
        ListIterator<Object> lit = list2.listIterator();
        while (lit.hasNext()) {
            lit.set(this.interpolate(lit.next()));
        }
        return list2;
    }

    @Override
    public String[] getStringArray(String key) {
        List<Object> list2 = this.getList(key);
        String[] tokens = new String[list2.size()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = String.valueOf(list2.get(i));
        }
        return tokens;
    }

    public Configuration getConfiguration(int index2) {
        return this.configList.get(index2);
    }

    public Configuration getInMemoryConfiguration() {
        return this.inMemoryConfiguration;
    }

    @Override
    public Object clone() {
        try {
            CompositeConfiguration copy = (CompositeConfiguration)super.clone();
            copy.clearConfigurationListeners();
            copy.configList = new LinkedList<Configuration>();
            copy.inMemoryConfiguration = ConfigurationUtils.cloneConfiguration(this.getInMemoryConfiguration());
            copy.configList.add(copy.inMemoryConfiguration);
            for (Configuration config : this.configList) {
                if (config == this.getInMemoryConfiguration()) continue;
                copy.addConfiguration(ConfigurationUtils.cloneConfiguration(config));
            }
            return copy;
        }
        catch (CloneNotSupportedException cnex) {
            throw new ConfigurationRuntimeException(cnex);
        }
    }

    @Override
    public void setDelimiterParsingDisabled(boolean delimiterParsingDisabled) {
        if (this.inMemoryConfiguration instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.inMemoryConfiguration).setDelimiterParsingDisabled(delimiterParsingDisabled);
        }
        super.setDelimiterParsingDisabled(delimiterParsingDisabled);
    }

    @Override
    public void setListDelimiter(char listDelimiter) {
        if (this.inMemoryConfiguration instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.inMemoryConfiguration).setListDelimiter(listDelimiter);
        }
        super.setListDelimiter(listDelimiter);
    }

    public Configuration getSource(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null!");
        }
        Configuration source = null;
        for (Configuration conf : this.configList) {
            if (!conf.containsKey(key)) continue;
            if (source != null) {
                throw new IllegalArgumentException("The key " + key + " is defined by multiple sources!");
            }
            source = conf;
        }
        return source;
    }

    private void replaceInMemoryConfiguration(Configuration config) {
        if (!this.inMemoryConfigIsChild) {
            this.configList.remove(this.inMemoryConfiguration);
        }
        this.inMemoryConfiguration = config;
    }

    private static void appendListProperty(List<Object> dest, Configuration config, String key) {
        Object value2 = config.getProperty(key);
        if (value2 != null) {
            if (value2 instanceof Collection) {
                Collection col = (Collection)value2;
                dest.addAll(col);
            } else {
                dest.add(value2);
            }
        }
    }
}

