/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationMap;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationConverter {
    private ConfigurationConverter() {
    }

    public static Configuration getConfiguration(ExtendedProperties eprops) {
        return new MapConfiguration(eprops);
    }

    public static Configuration getConfiguration(Properties props) {
        return new MapConfiguration(props);
    }

    public static ExtendedProperties getExtendedProperties(Configuration config) {
        ExtendedProperties props = new ExtendedProperties();
        Iterator<String> keys = config.getKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            ArrayList property = config.getProperty(key);
            if (property instanceof List) {
                property = new ArrayList(property);
            }
            props.setProperty(key, property);
        }
        return props;
    }

    public static Properties getProperties(Configuration config) {
        Properties props = new Properties();
        char delimiter = config instanceof AbstractConfiguration ? (char)((AbstractConfiguration)config).getListDelimiter() : (char)',';
        Iterator<String> keys = config.getKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            List<Object> list2 = config.getList(key);
            props.setProperty(key, StringUtils.join(list2.iterator(), delimiter));
        }
        return props;
    }

    public static Map<Object, Object> getMap(Configuration config) {
        return new ConfigurationMap(config);
    }
}

