/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.PropertyConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapConfiguration
extends AbstractConfiguration
implements Cloneable {
    protected Map<String, Object> map;
    private boolean trimmingDisabled;

    public MapConfiguration(Map<String, ?> map2) {
        this.map = map2;
    }

    public MapConfiguration(Properties props) {
        this.map = MapConfiguration.convertPropertiesToMap(props);
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public boolean isTrimmingDisabled() {
        return this.trimmingDisabled;
    }

    public void setTrimmingDisabled(boolean trimmingDisabled) {
        this.trimmingDisabled = trimmingDisabled;
    }

    @Override
    public Object getProperty(String key) {
        Object value2 = this.map.get(key);
        if (value2 instanceof String && !this.isDelimiterParsingDisabled()) {
            List<String> list2 = PropertyConverter.split((String)value2, this.getListDelimiter(), !this.isTrimmingDisabled());
            return list2.size() > 1 ? list2 : list2.get(0);
        }
        return value2;
    }

    @Override
    protected void addPropertyDirect(String key, Object value2) {
        Object previousValue = this.getProperty(key);
        if (previousValue == null) {
            this.map.put(key, value2);
        } else if (previousValue instanceof List) {
            ((List)previousValue).add(value2);
        } else {
            ArrayList<Object> list2 = new ArrayList<Object>();
            list2.add(previousValue);
            list2.add(value2);
            this.map.put(key, list2);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    protected void clearPropertyDirect(String key) {
        this.map.remove(key);
    }

    @Override
    public Iterator<String> getKeys() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object clone() {
        try {
            Map clonedMap;
            MapConfiguration copy = (MapConfiguration)super.clone();
            copy.clearConfigurationListeners();
            copy.map = clonedMap = (Map)ConfigurationUtils.clone(this.map);
            return copy;
        }
        catch (CloneNotSupportedException cex) {
            throw new ConfigurationRuntimeException(cex);
        }
    }

    private static Map<String, Object> convertPropertiesToMap(final Properties props) {
        return new AbstractMap<String, Object>(){

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>();
                for (final Map.Entry<Object, Object> propertyEntry : props.entrySet()) {
                    if (!(propertyEntry.getKey() instanceof String)) continue;
                    entries.add(new Map.Entry<String, Object>(){

                        @Override
                        public String getKey() {
                            return propertyEntry.getKey().toString();
                        }

                        @Override
                        public Object getValue() {
                            return propertyEntry.getValue();
                        }

                        @Override
                        public Object setValue(Object value2) {
                            throw new UnsupportedOperationException();
                        }
                    });
                }
                return entries;
            }
        };
    }
}

