/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.http.entity.AbstractHttpEntity;

public class StringEntity
extends AbstractHttpEntity
implements Cloneable {
    protected final byte[] content;

    public StringEntity(String string2, String mimeType, String charset) throws UnsupportedEncodingException {
        if (string2 == null) {
            throw new IllegalArgumentException("Source string may not be null");
        }
        if (mimeType == null) {
            mimeType = "text/plain";
        }
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        this.content = string2.getBytes(charset);
        this.setContentType(mimeType + "; charset=" + charset);
    }

    public StringEntity(String string2, String charset) throws UnsupportedEncodingException {
        this(string2, null, charset);
    }

    public StringEntity(String string2) throws UnsupportedEncodingException {
        this(string2, null);
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.content.length;
    }

    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public void writeTo(OutputStream outstream) throws IOException {
        if (outstream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        outstream.write(this.content);
        outstream.flush();
    }

    public boolean isStreaming() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

