/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.params;

import org.apache.http.params.HttpParams;

public abstract class AbstractHttpParams
implements HttpParams {
    protected AbstractHttpParams() {
    }

    public long getLongParameter(String name, long defaultValue) {
        Object param2 = this.getParameter(name);
        if (param2 == null) {
            return defaultValue;
        }
        return (Long)param2;
    }

    public HttpParams setLongParameter(String name, long value2) {
        this.setParameter(name, new Long(value2));
        return this;
    }

    public int getIntParameter(String name, int defaultValue) {
        Object param2 = this.getParameter(name);
        if (param2 == null) {
            return defaultValue;
        }
        return (Integer)param2;
    }

    public HttpParams setIntParameter(String name, int value2) {
        this.setParameter(name, new Integer(value2));
        return this;
    }

    public double getDoubleParameter(String name, double defaultValue) {
        Object param2 = this.getParameter(name);
        if (param2 == null) {
            return defaultValue;
        }
        return (Double)param2;
    }

    public HttpParams setDoubleParameter(String name, double value2) {
        this.setParameter(name, new Double(value2));
        return this;
    }

    public boolean getBooleanParameter(String name, boolean defaultValue) {
        Object param2 = this.getParameter(name);
        if (param2 == null) {
            return defaultValue;
        }
        return (Boolean)param2;
    }

    public HttpParams setBooleanParameter(String name, boolean value2) {
        this.setParameter(name, value2 ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public boolean isParameterTrue(String name) {
        return this.getBooleanParameter(name, false);
    }

    public boolean isParameterFalse(String name) {
        return !this.getBooleanParameter(name, false);
    }
}

