/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jolokia.converter.json.Extractor;
import org.jolokia.converter.json.ObjectToJsonConverter;
import org.jolokia.converter.object.StringToObjectConverter;
import org.jolokia.request.ValueFaultHandler;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanExtractor
implements Extractor {
    private static final Set<Class> FINAL_CLASSES = new HashSet<Class>(Arrays.asList(String.class, Number.class, Byte.class, Double.class, Float.class, Long.class, Short.class, Integer.class, Boolean.class));
    private static final Set<String> IGNORE_METHODS = new HashSet<String>(Arrays.asList("getClass"));
    private static final String[] GETTER_PREFIX = new String[]{"get", "is", "has"};

    @Override
    public Class getType() {
        return Object.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pExtraArgs, boolean jsonify) throws AttributeNotFoundException {
        ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
        if (!pExtraArgs.isEmpty()) {
            String attribute = pExtraArgs.pop();
            Object attributeValue = this.extractBeanPropertyValue(pValue, attribute, faultHandler);
            return pConverter.extractObject(attributeValue, pExtraArgs, jsonify);
        }
        if (jsonify) {
            return this.exctractJsonifiedValue(pValue, pExtraArgs, pConverter, faultHandler);
        }
        return pValue;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        Object oldValue;
        String rest = new StringBuffer(pAttribute.substring(0, 1).toUpperCase()).append(pAttribute.substring(1)).toString();
        String setter2 = new StringBuffer("set").append(rest).toString();
        String getter2 = new StringBuffer("get").append(rest).toString();
        Class<?> clazz = pInner.getClass();
        Method found = null;
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(setter2)) continue;
            found = method;
            break;
        }
        if (found == null) {
            throw new IllegalArgumentException("No Method " + setter2 + " known for object of type " + clazz.getName());
        }
        Class<?>[] params = found.getParameterTypes();
        if (params.length != 1) {
            throw new IllegalArgumentException("Invalid parameter signature for " + setter2 + " known for object of type " + clazz.getName() + ". Setter must take exactly one parameter.");
        }
        try {
            Method getMethod = clazz.getMethod(getter2, new Class[0]);
            AccessController.doPrivileged(new SetMethodAccessibleAction(getMethod));
            oldValue = getMethod.invoke(pInner, new Object[0]);
        }
        catch (NoSuchMethodException exp) {
            oldValue = null;
        }
        AccessController.doPrivileged(new SetMethodAccessibleAction(found));
        found.invoke(pInner, pConverter.prepareValue(params[0].getName(), pValue));
        return oldValue;
    }

    @Override
    public boolean canSetValue() {
        return true;
    }

    private Object exctractJsonifiedValue(Object pValue, Stack<String> pExtraArgs, ObjectToJsonConverter pConverter, ValueFaultHandler pFaultHandler) throws AttributeNotFoundException {
        if (pValue.getClass().isPrimitive() || FINAL_CLASSES.contains(pValue.getClass()) || pValue instanceof JSONAware) {
            return pValue;
        }
        List<String> attributes = this.extractBeanAttributes(pValue);
        if (attributes != null && attributes.size() > 0) {
            JSONObject ret = new JSONObject();
            for (String attribute : attributes) {
                ret.put(attribute, this.extractJsonifiedPropertyValue(pValue, attribute, pExtraArgs, pConverter, pFaultHandler));
            }
            return ret;
        }
        return pValue.toString();
    }

    private Object extractJsonifiedPropertyValue(Object pValue, String pAttribute, Stack<String> pExtraArgs, ObjectToJsonConverter pConverter, ValueFaultHandler pFaultHandler) throws AttributeNotFoundException {
        Object value2 = this.extractBeanPropertyValue(pValue, pAttribute, pFaultHandler);
        if (value2 == null) {
            return null;
        }
        if (value2 == pValue) {
            return "[this]";
        }
        return pConverter.extractObject(value2, pExtraArgs, true);
    }

    private List<String> extractBeanAttributes(Object pValue) {
        ArrayList<String> attrs = new ArrayList<String>();
        for (Method method : pValue.getClass().getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || IGNORE_METHODS.contains(method.getName())) continue;
            this.addAttributes(attrs, method);
        }
        return attrs;
    }

    private void addAttributes(List<String> pAttrs, Method pMethod) {
        String name = pMethod.getName();
        for (String pref : GETTER_PREFIX) {
            int len;
            String firstLetter;
            if (!name.startsWith(pref) || name.length() <= pref.length() || pMethod.getParameterTypes().length != 0 || !(firstLetter = name.substring(len = pref.length(), len + 1)).toUpperCase().equals(firstLetter)) continue;
            String attribute = new StringBuffer(firstLetter.toLowerCase()).append(name.substring(len + 1)).toString();
            pAttrs.add(attribute);
        }
    }

    private Object extractBeanPropertyValue(Object pValue, String pAttribute, ValueFaultHandler pFaultHandler) throws AttributeNotFoundException {
        Class<?> clazz = pValue.getClass();
        Method method = null;
        String suffix = pAttribute.substring(0, 1).toUpperCase() + pAttribute.substring(1);
        for (String pref : GETTER_PREFIX) {
            try {
                String methodName = pref + suffix;
                method = clazz.getMethod(methodName, new Class[0]);
                break;
            }
            catch (NoSuchMethodException e) {
            }
        }
        if (method == null) {
            try {
                method = clazz.getMethod(pAttribute.substring(0, 1).toLowerCase() + pAttribute.substring(1), new Class[0]);
            }
            catch (NoSuchMethodException exp) {
                method = null;
            }
        }
        if (method == null) {
            return pFaultHandler.handleException(new AttributeNotFoundException("No getter known for attribute " + pAttribute + " for class " + pValue.getClass().getName()));
        }
        try {
            method.setAccessible(true);
            return method.invoke(pValue, new Object[0]);
        }
        catch (IllegalAccessException e) {
            return pFaultHandler.handleException(new IllegalStateException("Error while extracting " + pAttribute + " from " + pValue, e));
        }
        catch (InvocationTargetException e) {
            return pFaultHandler.handleException(new IllegalStateException("Error while extracting " + pAttribute + " from " + pValue, e));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetMethodAccessibleAction
    implements PrivilegedAction<Void> {
        private final Method getMethod;

        public SetMethodAccessibleAction(Method pMethod) {
            this.getMethod = pMethod;
        }

        @Override
        public Void run() {
            this.getMethod.setAccessible(true);
            return null;
        }
    }
}

