/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import org.jolokia.converter.json.Extractor;
import org.jolokia.converter.json.ObjectToJsonConverter;
import org.jolokia.converter.object.StringToObjectConverter;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabularDataExtractor
implements Extractor {
    @Override
    public Class getType() {
        return TabularData.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pExtraArgs, boolean pJsonify) throws AttributeNotFoundException {
        TabularData td = (TabularData)pValue;
        if (!pExtraArgs.isEmpty()) {
            CompositeData cd = this.extractCompositeDataFromPath(td, pExtraArgs);
            return pConverter.extractObject(cd != null && this.checkForMxBeanMap(td.getTabularType()) ? cd.get("value") : cd, pExtraArgs, pJsonify);
        }
        if (pJsonify) {
            return this.checkForMxBeanMap(td.getTabularType()) ? this.convertMxBeanMapToJson(td, pExtraArgs, pConverter) : this.convertTabularDataToJson(td, pExtraArgs, pConverter);
        }
        return td;
    }

    private boolean checkForMxBeanMap(TabularType pType) {
        CompositeType rowType = pType.getRowType();
        return rowType.containsKey("key") && rowType.containsKey("value") && rowType.keySet().size() == 2;
    }

    private Object convertTabularDataToJson(TabularData pTd, Stack<String> pExtraArgs, ObjectToJsonConverter pConverter) throws AttributeNotFoundException {
        TabularType type = pTd.getTabularType();
        List<String> indexNames = type.getIndexNames();
        JSONObject ret = new JSONObject();
        for (CompositeData cd : pTd.values()) {
            JSONObject targetJSONObject = ret;
            for (int i = 0; i < indexNames.size() - 1; ++i) {
                Object indexValue = pConverter.extractObject(cd.get(indexNames.get(i)), null, true);
                targetJSONObject = this.getNextMap(targetJSONObject, indexValue);
            }
            Object row = pConverter.extractObject(cd, pExtraArgs, true);
            String finalIndex = indexNames.get(indexNames.size() - 1);
            Object finalIndexValue = pConverter.extractObject(cd.get(finalIndex), null, true);
            targetJSONObject.put(finalIndexValue, row);
        }
        return ret;
    }

    private JSONObject getNextMap(JSONObject pJsonObject, Object pKey) {
        JSONObject ret = (JSONObject)pJsonObject.get(pKey);
        if (ret == null) {
            ret = new JSONObject();
            pJsonObject.put(pKey, ret);
        }
        return ret;
    }

    private CompositeData extractCompositeDataFromPath(TabularData pTd, Stack<String> pPathStack) {
        TabularType type = pTd.getTabularType();
        List<String> indexNames = type.getIndexNames();
        if (indexNames.size() > pPathStack.size()) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < indexNames.size(); ++i) {
                buf.append(indexNames.get(i));
                if (i >= indexNames.size() - 1) continue;
                buf.append(",");
            }
            throw new IllegalArgumentException("No enough keys on path stack provided for accessing tabular data with index names " + buf.toString());
        }
        Object[] keys = new Object[indexNames.size()];
        CompositeType rowType = type.getRowType();
        for (int i = indexNames.size() - 1; i >= 0; --i) {
            OpenType<?> keyType = rowType.getType(indexNames.get(i));
            if (SimpleType.STRING != keyType) {
                throw new IllegalArgumentException("All keys must be a string type for accessing TabularData via a path. This is not the case for '" + indexNames.get(i) + "' which is of type " + keyType);
            }
            keys[i] = pPathStack.pop();
        }
        return pTd.get(keys);
    }

    private Object convertMxBeanMapToJson(TabularData pTd, Stack<String> pExtraArgs, ObjectToJsonConverter pConverter) throws AttributeNotFoundException {
        JSONObject ret = new JSONObject();
        for (Object rowObject : pTd.values()) {
            CompositeData row = (CompositeData)rowObject;
            Object keyObject = row.get("key");
            if (keyObject == null) continue;
            Object value2 = pConverter.extractObject(row.get("value"), pExtraArgs, true);
            ret.put(keyObject.toString(), value2);
        }
        return ret;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        throw new IllegalArgumentException("TabularData cannot be written to");
    }

    @Override
    public boolean canSetValue() {
        return false;
    }
}

