/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.object;

import java.lang.reflect.Array;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.jolokia.converter.object.OpenTypeConverter;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayTypeConverter
extends OpenTypeConverter<ArrayType> {
    ArrayTypeConverter(OpenTypeConverter pDispatcher) {
        super(pDispatcher);
    }

    @Override
    public boolean canConvert(OpenType pType) {
        return pType instanceof ArrayType;
    }

    @Override
    public Object convertToObject(ArrayType type, Object pFrom) {
        JSONAware value2 = this.toJSON(pFrom);
        if (!(value2 instanceof JSONArray)) {
            throw new IllegalArgumentException("Can not convert " + value2 + " to type " + type + " because JSON object type " + value2.getClass() + " is not a JSONArray");
        }
        JSONArray jsonArray2 = (JSONArray)value2;
        OpenType<?> elementOpenType = type.getElementOpenType();
        Object[] valueArray = this.createTargetArray(elementOpenType, jsonArray2.size());
        int i = 0;
        for (Object element : jsonArray2) {
            valueArray[i++] = this.getDispatcher().convertToObject(elementOpenType, element);
        }
        return valueArray;
    }

    private Object[] createTargetArray(OpenType pElementType, int pLength) {
        if (pElementType instanceof SimpleType) {
            try {
                SimpleType simpleType = (SimpleType)pElementType;
                Class<?> elementClass = Class.forName(simpleType.getClassName());
                return (Object[])Array.newInstance(elementClass, pLength);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Can't find class " + pElementType.getClassName() + " for instantiating array: " + e.getMessage(), e);
            }
        }
        if (pElementType instanceof CompositeType) {
            return new CompositeData[pLength];
        }
        throw new UnsupportedOperationException("Unsupported array element type: " + pElementType);
    }
}

