/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jolokia.request.JmxRequest;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerHandle {
    private String product;
    private String version;
    private URL agentUrl;
    private Map<String, String> extraInfo;
    private String vendor;

    public ServerHandle(String vendor, String product2, String version, URL agentUrl, Map<String, String> extraInfo) {
        this.product = product2;
        this.version = version;
        this.agentUrl = agentUrl;
        this.extraInfo = extraInfo;
        this.vendor = vendor;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getProduct() {
        return this.product;
    }

    public String getVersion() {
        return this.version;
    }

    public URL getAgentUrl() {
        return this.agentUrl;
    }

    public Map<String, String> getExtraInfo(Set<? extends MBeanServerConnection> pServers) {
        return this.extraInfo;
    }

    public void preDispatch(Set<MBeanServer> pMBeanServers, JmxRequest pJmxReq) {
    }

    public ObjectName registerMBeanAtServer(MBeanServer pServer, Object pMBean, String pName) throws MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException, MalformedObjectNameException {
        if (pName != null) {
            ObjectName oName = new ObjectName(pName);
            return pServer.registerMBean(pMBean, oName).getObjectName();
        }
        return pServer.registerMBean(pMBean, null).getObjectName();
    }

    public JSONObject toJSONObject(Set<MBeanServerConnection> pServers) {
        JSONObject ret = new JSONObject();
        this.addNullSafe(ret, "vendor", this.vendor);
        this.addNullSafe(ret, "product", this.product);
        this.addNullSafe(ret, "version", this.version);
        this.addNullSafe(ret, "agent-url", this.agentUrl);
        this.addNullSafe(ret, "extraInfo", this.getExtraInfo(pServers));
        return ret;
    }

    private void addNullSafe(JSONObject pRet, String pKey, Object pValue) {
        if (pValue != null) {
            pRet.put(pKey, pValue);
        }
    }
}

