/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.detector.ServerHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatDetector
extends AbstractServerDetector {
    private static final Pattern SERVER_INFO_PATTERN = Pattern.compile("^\\s*([^/]+)\\s*/\\s*([\\d\\.]+)");

    @Override
    public ServerHandle detect(Set<MBeanServer> pMbeanServers) {
        String serverInfo = this.getSingleStringAttribute(pMbeanServers, "*:type=Server", "serverInfo");
        if (serverInfo == null) {
            return null;
        }
        Matcher matcher = SERVER_INFO_PATTERN.matcher(serverInfo);
        if (matcher.matches()) {
            String product2 = matcher.group(1);
            String version = matcher.group(2);
            if (product2.toLowerCase().contains("tomcat")) {
                return new ServerHandle("Apache", "tomcat", version, null, null);
            }
        }
        return null;
    }
}

