/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.detector.ServerHandle;
import org.jolokia.util.ClassUtil;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebsphereDetector
extends AbstractServerDetector {
    private static final Pattern SERVER_VERSION_PATTERN = Pattern.compile("^Version\\s+([0-9.]+)\\s*$.*?^Build Date\\s+([0-9/]+)\\s*$", 42);
    public static final String INTERNAL_ERROR_MSG = "Internal: Found AdminServiceFactory but can not call methods on it (wrong WAS version ?)";
    private boolean isWebsphere = ClassUtil.checkForClass("com.ibm.websphere.management.AdminServiceFactory");
    private boolean isWebsphere7 = ClassUtil.checkForClass("com.ibm.websphere.management.AdminContext");
    private boolean isWebsphere6 = this.isWebsphere && !this.isWebsphere7;

    @Override
    public ServerHandle detect(Set<MBeanServer> pMbeanServers) {
        String serverVersion = this.getSingleStringAttribute(pMbeanServers, "*:j2eeType=J2EEServer,type=Server,*", "serverVersion");
        if (serverVersion != null && serverVersion.contains("WebSphere")) {
            Matcher matcher = SERVER_VERSION_PATTERN.matcher(serverVersion);
            if (matcher.find()) {
                String version = matcher.group(1);
                String date = matcher.group(2);
                JSONObject extraInfo = new JSONObject();
                if (date != null) {
                    extraInfo.put("buildDate", date);
                }
                return new WebsphereServerHandle(version, null, extraInfo.size() > 0 ? extraInfo : null);
            }
            return null;
        }
        if (this.isWebsphere) {
            return new WebsphereServerHandle(this.isWebsphere6 ? "6" : "7 or 8", null, null);
        }
        return null;
    }

    @Override
    public void addMBeanServers(Set<MBeanServer> servers) {
        try {
            Class<?> adminServiceClass = this.getClass().getClassLoader().loadClass("com.ibm.websphere.management.AdminServiceFactory");
            Method getMBeanFactoryMethod = adminServiceClass.getMethod("getMBeanFactory", new Class[0]);
            Object mbeanFactory = getMBeanFactoryMethod.invoke(null, new Object[0]);
            Method getMBeanServerMethod = mbeanFactory.getClass().getMethod("getMBeanServer", new Class[0]);
            servers.add((MBeanServer)getMBeanServerMethod.invoke(mbeanFactory, new Object[0]));
        }
        catch (ClassNotFoundException ex) {
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException(INTERNAL_ERROR_MSG, ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(INTERNAL_ERROR_MSG, ex);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(INTERNAL_ERROR_MSG, ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WebsphereServerHandle
    extends ServerHandle {
        public WebsphereServerHandle(String pVersion, URL pAgenturl, Map<String, String> pExtrainfo) {
            super("IBM", "websphere", pVersion, pAgenturl, pExtrainfo);
        }

        @Override
        public ObjectName registerMBeanAtServer(MBeanServer pServer, Object pMBean, String pName) throws MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException, MalformedObjectNameException {
            if (WebsphereDetector.this.isWebsphere6 && pMBean instanceof MBeanRegistration) {
                return pServer.registerMBean(pMBean, null).getObjectName();
            }
            return super.registerMBeanAtServer(pServer, pMBean, pName);
        }
    }
}

