/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.handler.list;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.handler.list.AttributeDataUpdater;
import org.jolokia.handler.list.DataKeys;
import org.jolokia.handler.list.DataUpdater;
import org.jolokia.handler.list.DescriptionDataUpdater;
import org.jolokia.handler.list.NotificationDataUpdater;
import org.jolokia.handler.list.OperationDataUpdater;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanInfoData {
    private int maxDepth;
    private Stack<String> pathStack;
    private JSONObject infoMap;
    private static final Map<String, DataUpdater> UPDATERS = new HashMap<String, DataUpdater>();

    public MBeanInfoData(int pMaxDepth, Stack<String> pPathStack) {
        this.maxDepth = pMaxDepth;
        this.pathStack = pPathStack != null ? (Stack)pPathStack.clone() : new Stack();
        this.infoMap = new JSONObject();
    }

    public boolean handleFirstOrSecondLevel(ObjectName pName) {
        if (this.maxDepth == 1 && this.pathStack.size() == 0) {
            this.infoMap.put(pName.getDomain(), 1);
            return true;
        }
        if (this.maxDepth == 2 && this.pathStack.size() == 0) {
            JSONObject mBeansMap = this.getOrCreateJSONObject(this.infoMap, pName.getDomain());
            mBeansMap.put(pName.getCanonicalKeyPropertyListString(), 1);
            return true;
        }
        return false;
    }

    public void addMBeanInfo(MBeanInfo mBeanInfo, ObjectName pName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        JSONObject mBeansMap = this.getOrCreateJSONObject(this.infoMap, pName.getDomain());
        JSONObject mBeanMap = this.getOrCreateJSONObject(mBeansMap, pName.getCanonicalKeyPropertyListString());
        Stack<String> stack = this.truncatePathStack(2);
        if (stack.empty()) {
            this.addFullMBeanInfo(mBeanMap, mBeanInfo);
        } else {
            this.addPartialMBeanInfo(mBeanMap, mBeanInfo, stack);
        }
        if (mBeanMap.size() == 0) {
            mBeansMap.remove(pName.getCanonicalKeyPropertyListString());
            if (mBeansMap.size() == 0) {
                this.infoMap.remove(pName.getDomain());
            }
        }
    }

    public void handleException(ObjectName pName, IOException pExp) throws IOException {
        if (this.pathStack.size() != 0) {
            throw pExp;
        }
        JSONObject mBeansMap = this.getOrCreateJSONObject(this.infoMap, pName.getDomain());
        JSONObject mBeanMap = this.getOrCreateJSONObject(mBeansMap, pName.getCanonicalKeyPropertyListString());
        mBeanMap.put(DataKeys.ERROR.getKey(), pExp);
    }

    public Object truncate() {
        Object value2 = this.navigatePath();
        if (this.maxDepth == 0) {
            return value2;
        }
        if (!(value2 instanceof JSONObject)) {
            return value2;
        }
        return this.truncateJSONObject((JSONObject)value2, this.maxDepth);
    }

    private void addFullMBeanInfo(JSONObject pMBeanMap, MBeanInfo pMBeanInfo) {
        for (DataUpdater updater : UPDATERS.values()) {
            updater.update(pMBeanMap, pMBeanInfo, null);
        }
    }

    private void addPartialMBeanInfo(JSONObject pMBeanMap, MBeanInfo pMBeanInfo, Stack<String> pPathStack) {
        String what = pPathStack.empty() ? null : pPathStack.pop();
        DataUpdater updater = UPDATERS.get(what);
        if (updater == null) {
            throw new IllegalArgumentException("Illegal path element " + what);
        }
        updater.update(pMBeanMap, pMBeanInfo, pPathStack);
    }

    private JSONObject getOrCreateJSONObject(JSONObject pMap, String pKey) {
        JSONObject nMap = (JSONObject)pMap.get(pKey);
        if (nMap == null) {
            nMap = new JSONObject();
            pMap.put(pKey, nMap);
        }
        return nMap;
    }

    private Object truncateJSONObject(JSONObject pValue, int pMaxDepth) {
        if (pMaxDepth == 0) {
            return 1;
        }
        JSONObject ret = new JSONObject();
        Set entries = pValue.entrySet();
        for (Map.Entry entry : entries) {
            Object value2 = entry.getValue();
            Object key = entry.getKey();
            if (value2 instanceof JSONObject) {
                ret.put(key, this.truncateJSONObject((JSONObject)value2, pMaxDepth - 1));
                continue;
            }
            ret.put(key, value2);
        }
        return ret;
    }

    private Stack<String> truncatePathStack(int pLevel) {
        if (this.pathStack.size() < pLevel) {
            return new Stack<String>();
        }
        Stack ret = (Stack)this.pathStack.clone();
        for (int i = 0; i < pLevel; ++i) {
            ret.pop();
        }
        return ret;
    }

    private Object navigatePath() {
        JSONObject innerMap = this.infoMap;
        for (int size2 = this.pathStack.size(); size2 > 0; --size2) {
            Collection vals = innerMap.values();
            if (vals.size() == 0) {
                return innerMap;
            }
            if (vals.size() != 1) {
                throw new IllegalStateException("Internal: More than one key found when extracting with path: " + vals);
            }
            Object value2 = vals.iterator().next();
            if (size2 == 1) {
                return value2;
            }
            if (!(value2 instanceof JSONObject)) {
                throw new IllegalStateException("Internal: Value within path extraction must be a Map, not " + value2.getClass());
            }
            innerMap = (JSONObject)value2;
        }
        return innerMap;
    }

    static {
        for (DataUpdater updater : new DataUpdater[]{new DescriptionDataUpdater(), new AttributeDataUpdater(), new OperationDataUpdater(), new NotificationDataUpdater()}) {
            UPDATERS.put(updater.getKey(), updater);
        }
    }
}

