/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.handler.list;

import java.util.List;
import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.jolokia.handler.list.DataKeys;
import org.jolokia.handler.list.DataUpdater;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

class OperationDataUpdater
extends DataUpdater {
    OperationDataUpdater() {
    }

    String getKey() {
        return DataKeys.OPERATIONS.getKey();
    }

    protected JSONObject extractData(MBeanInfo pMBeanInfo, String pOperation) {
        JSONObject opMap = new JSONObject();
        for (MBeanOperationInfo opInfo : pMBeanInfo.getOperations()) {
            if (pOperation != null && !opInfo.getName().equals(pOperation)) continue;
            JSONObject map2 = new JSONObject();
            JSONArray argList = new JSONArray();
            for (MBeanParameterInfo paramInfo : opInfo.getSignature()) {
                JSONObject args = new JSONObject();
                args.put(DataKeys.DESCRIPTION.getKey(), paramInfo.getDescription());
                args.put(DataKeys.NAME.getKey(), paramInfo.getName());
                args.put(DataKeys.TYPE.getKey(), paramInfo.getType());
                argList.add(args);
            }
            map2.put(DataKeys.ARGS.getKey(), argList);
            map2.put(DataKeys.RETURN_TYPE.getKey(), opInfo.getReturnType());
            map2.put(DataKeys.DESCRIPTION.getKey(), opInfo.getDescription());
            Object ops2 = opMap.get(opInfo.getName());
            if (ops2 != null) {
                if (ops2 instanceof List) {
                    ((List)ops2).add(map2);
                    continue;
                }
                if (ops2 instanceof Map) {
                    JSONArray opList = new JSONArray();
                    opList.add(ops2);
                    opList.add(map2);
                    opMap.put(opInfo.getName(), opList);
                    continue;
                }
                throw new IllegalArgumentException("Internal: list, addOperations: Expected Map or List, not " + ops2.getClass());
            }
            opMap.put(opInfo.getName(), map2);
        }
        return opMap;
    }
}

