/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.history;

import java.io.Serializable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.request.JmxExecRequest;
import org.jolokia.request.JmxObjectNameRequest;
import org.jolokia.request.JmxReadRequest;
import org.jolokia.request.JmxWriteRequest;

public class HistoryKey
implements Serializable {
    private static final long serialVersionUID = 42L;
    private String type;
    private ObjectName mBean;
    private String secondary;
    private String path;
    private String target;

    HistoryKey(JmxReadRequest pJmxRequest) {
        this.init(pJmxRequest);
        if (pJmxRequest.getAttributeNames() != null && pJmxRequest.getAttributeNames().size() > 1) {
            throw new IllegalArgumentException("A key cannot contain more than one attribute");
        }
        this.type = "attribute";
        String string2 = this.secondary = pJmxRequest.isMultiAttributeMode() ? pJmxRequest.getAttributeNames().get(0) : pJmxRequest.getAttributeName();
        if (this.secondary == null) {
            this.secondary = "(all)";
        }
        this.path = pJmxRequest.getPath();
    }

    HistoryKey(JmxWriteRequest pJmxReq) {
        this.init(pJmxReq);
        this.type = "attribute";
        this.secondary = pJmxReq.getAttributeName();
        this.path = pJmxReq.getPath();
        if (this.secondary == null) {
            throw new IllegalArgumentException(this.type + " name must not be null");
        }
    }

    HistoryKey(JmxExecRequest pJmxReq) {
        this.init(pJmxReq);
        this.type = "operation";
        this.secondary = pJmxReq.getOperation();
        this.path = null;
        if (this.secondary == null) {
            throw new IllegalArgumentException(this.type + " name must not be null");
        }
    }

    private void init(JmxObjectNameRequest pJmxReq) {
        if (pJmxReq.getObjectNameAsString() == null) {
            throw new IllegalArgumentException("MBean name must not be null");
        }
        if (pJmxReq.getObjectName().isPattern()) {
            throw new IllegalArgumentException("MBean name must not be a pattern");
        }
        if (pJmxReq.getTargetConfig() != null) {
            this.target = pJmxReq.getTargetConfig().getUrl();
        }
        this.mBean = pJmxReq.getObjectName();
    }

    public HistoryKey(String pMBean, String pOperation, String pTarget) throws MalformedObjectNameException {
        this.type = "operation";
        this.mBean = new ObjectName(pMBean);
        this.secondary = pOperation;
        this.path = null;
        this.target = this.sanitize(pTarget);
    }

    private String sanitize(String pValue) {
        return "".equals(pValue) ? null : pValue;
    }

    public HistoryKey(String pMBean, String pAttribute, String pPath, String pTarget) throws MalformedObjectNameException {
        this.type = "attribute";
        this.mBean = new ObjectName(pMBean);
        this.secondary = pAttribute;
        this.path = pPath;
        this.target = pTarget;
    }

    public boolean isMBeanPattern() {
        return this.mBean.isPattern();
    }

    public boolean matches(HistoryKey pKey) {
        return this.mBean.apply(pKey.mBean);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryKey that = (HistoryKey)o;
        if (!this.mBean.equals(that.mBean)) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (!this.secondary.equals(that.secondary)) {
            return false;
        }
        if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = 31 * result2 + this.mBean.hashCode();
        result2 = 31 * result2 + this.secondary.hashCode();
        result2 = 31 * result2 + (this.path != null ? this.path.hashCode() : 0);
        result2 = 31 * result2 + (this.target != null ? this.target.hashCode() : 0);
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HistoryKey");
        sb.append("{type='").append(this.type).append('\'');
        sb.append(", mBean=").append(this.mBean);
        sb.append(", secondary='").append(this.secondary).append('\'');
        sb.append(", path='").append(this.path).append('\'');
        sb.append(", target='").append(this.target).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

