/*
 * Decompiled with CFR 0.152.
 */
package org.skife.config;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.skife.config.DataAmountUnit;

public class DataAmount {
    private final long value;
    private final DataAmountUnit unit;
    private final long numBytes;
    private static final Pattern SPLIT = Pattern.compile("^(\\d+)\\s*([a-zA-Z]+)$");
    private static final Pattern NUM_ONLY = Pattern.compile("^(\\d+)$");

    public DataAmount(String spec) {
        Matcher m = SPLIT.matcher(spec);
        if (!m.matches()) {
            m = NUM_ONLY.matcher(spec);
            if (!m.matches()) {
                throw new IllegalArgumentException(String.format("%s is not a valid data amount", spec));
            }
            this.unit = DataAmountUnit.BYTE;
            this.value = this.numBytes = Long.parseLong(spec);
        } else {
            String number2 = m.group(1);
            String type = m.group(2);
            this.value = Long.parseLong(number2);
            this.unit = DataAmountUnit.fromString(type);
            this.numBytes = this.unit.getFactor() * this.value;
        }
    }

    public DataAmount(long value2, DataAmountUnit unit) {
        this.value = value2;
        this.unit = unit;
        this.numBytes = unit.getFactor() * value2;
    }

    public DataAmount(long rawBytes) {
        this.value = this.numBytes = rawBytes;
        this.unit = DataAmountUnit.BYTE;
    }

    public long getValue() {
        return this.value;
    }

    public DataAmountUnit getUnit() {
        return this.unit;
    }

    public long getNumberOfBytes() {
        return this.numBytes;
    }

    public DataAmount convertTo(DataAmountUnit newUnit) {
        return new DataAmount(this.numBytes / newUnit.getFactor(), newUnit);
    }

    public String toString() {
        return this.value + this.unit.getSymbol();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (int)(this.numBytes ^ this.numBytes >>> 32);
        result2 = 31 * result2 + this.unit.hashCode();
        result2 = 31 * result2 + (int)(this.value ^ this.value >>> 32);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataAmount other = (DataAmount)obj;
        return this.numBytes == other.numBytes;
    }
}

