/*
 * Decompiled with CFR 0.152.
 */
package org.skife.config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataAmountUnit {
    BYTE("B", 1L),
    KIBIBYTE("KiB", 1024L),
    MEBIBYTE("MiB", 0x100000L),
    GIBIBYTE("GiB", 0x40000000L),
    TEBIBYTE("TiB", 0x10000000000L),
    PEBIBYTE("PiB", 0x4000000000000L),
    EXIBYTE("EiB", 0x1000000000000000L),
    KILOBYTE("kB", 1000L),
    MEGABYTE("MB", 1000000L),
    GIGABYTE("GB", 1000000000L),
    TERABYTE("TB", 1000000000000L),
    PETABYTE("PB", 1000000000000000L),
    EXABYTE("EB", 1000000000000000000L);

    private final String symbol;
    private final long factor;

    private DataAmountUnit(String symbol, long factor) {
        this.symbol = symbol;
        this.factor = factor;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public long getFactor() {
        return this.factor;
    }

    public static DataAmountUnit fromString(String text2) {
        for (DataAmountUnit unit : DataAmountUnit.values()) {
            if (!unit.symbol.equals(text2)) continue;
            return unit;
        }
        throw new IllegalArgumentException("Unknown unit '" + text2 + "'");
    }

    public static DataAmountUnit fromStringCaseInsensitive(String origText) {
        String text2 = origText.toLowerCase();
        for (DataAmountUnit unit : DataAmountUnit.values()) {
            if (!unit.symbol.equals(text2)) continue;
            return unit;
        }
        throw new IllegalArgumentException("Unknown unit '" + origText + "'");
    }
}

