/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.Descriptor;
import javax.management.DescriptorKey;
import javax.management.ImmutableDescriptor;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.JmxException;
import org.weakref.jmx.ManagedAnnotation;
import org.weakref.jmx.Nested;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static Descriptor buildDescriptor(Method annotatedMethod) {
        return AnnotationUtils.buildDescriptor(annotatedMethod.getAnnotations());
    }

    public static Descriptor buildDescriptor(Annotation ... annotations) {
        TreeMap<String, String[]> fields = new TreeMap<String, String[]>();
        for (Annotation annotation : annotations) {
            for (Method field2 : annotation.annotationType().getMethods()) {
                String[] value2;
                DescriptorKey descriptorKey = field2.getAnnotation(DescriptorKey.class);
                if (descriptorKey == null) continue;
                String name = descriptorKey.value();
                try {
                    value2 = field2.invoke((Object)annotation, new Object[0]);
                }
                catch (Exception e) {
                    Throwable cause = e;
                    if (e instanceof InvocationTargetException) {
                        cause = e.getCause();
                    }
                    throw new JmxException(JmxException.Reason.INVALID_ANNOTATION, cause, "Unexpected exception getting value from @DescriptorKey field type: annotationClass=%s, field=%s", annotation.annotationType().getName(), field2.getName());
                }
                if (value2 == null) continue;
                if (value2 instanceof Class) {
                    value2 = ((Class)value2).getName();
                } else if (value2 instanceof Enum) {
                    value2 = ((Enum)value2).name();
                } else if (value2.getClass().isArray()) {
                    int i;
                    String[] stringArray;
                    Class<?> componentType = value2.getClass().getComponentType();
                    if (Class.class.equals(componentType)) {
                        Class[] classArray = (Class[])value2;
                        stringArray = new String[classArray.length];
                        for (i = 0; i < classArray.length; ++i) {
                            if (classArray[i] == null) continue;
                            stringArray[i] = classArray[i].getName();
                        }
                        value2 = stringArray;
                    } else if (componentType.isEnum()) {
                        Enum[] enumArray = (Enum[])value2;
                        stringArray = new String[enumArray.length];
                        for (i = 0; i < enumArray.length; ++i) {
                            if (enumArray[i] == null) continue;
                            stringArray[i] = enumArray[i].name();
                        }
                        value2 = stringArray;
                    }
                } else if (value2 instanceof Annotation) {
                    throw new JmxException(JmxException.Reason.INVALID_ANNOTATION, "@DescriptorKey can not be applied to an annotation field type: annotationClass=%s, field=%s", annotation.annotationType().getName(), field2.getName());
                }
                fields.put(name, value2);
            }
        }
        return new ImmutableDescriptor(fields);
    }

    public static String getDescription(Descriptor descriptor, Method ... annotatedMethods) {
        for (Method annotatedMethod : annotatedMethods) {
            String description;
            if (annotatedMethod == null || (description = AnnotationUtils.getDescription(annotatedMethod)) == null) continue;
            return description;
        }
        Object descriptionValue = descriptor.getFieldValue("description");
        if (descriptionValue instanceof String) {
            return (String)descriptionValue;
        }
        return null;
    }

    public static String getDescription(Descriptor descriptor, Annotation ... annotatedMethod) {
        String description = AnnotationUtils.getDescription(annotatedMethod);
        if (description != null) {
            return description;
        }
        Object descriptionValue = descriptor.getFieldValue("description");
        if (descriptionValue instanceof String) {
            return (String)descriptionValue;
        }
        return null;
    }

    public static String getDescription(Method annotatedMethod) {
        return AnnotationUtils.getDescription(annotatedMethod.getAnnotations());
    }

    public static String getDescription(Annotation ... annotations) {
        String description = "";
        for (Annotation annotation : annotations) {
            try {
                Method descriptionMethod = annotation.annotationType().getMethod("description", new Class[0]);
                description = descriptionMethod.invoke((Object)annotation, new Object[0]).toString();
            }
            catch (InvocationTargetException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return description;
    }

    public static Map<Method, Method> findManagedMethods(Class<?> clazz) {
        HashMap<Method, Method> result2 = new HashMap<Method, Method>();
        for (Method method : clazz.getMethods()) {
            Method managedMethod;
            if (method.isSynthetic() || method.isBridge() || (managedMethod = AnnotationUtils.findManagedMethod(clazz, method.getName(), method.getParameterTypes())) == null) continue;
            result2.put(method, managedMethod);
        }
        return result2;
    }

    public static Method findManagedMethod(Method method) {
        return AnnotationUtils.findManagedMethod(method.getDeclaringClass(), method.getName(), method.getParameterTypes());
    }

    public static Method findManagedMethod(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        Method managedMethod;
        try {
            Method method = clazz.getDeclaredMethod(methodName, paramTypes);
            if (AnnotationUtils.isManagedMethod(method)) {
                return method;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (clazz.getSuperclass() != null && (managedMethod = AnnotationUtils.findManagedMethod(clazz.getSuperclass(), methodName, paramTypes)) != null) {
            return managedMethod;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            Method managedMethod2 = AnnotationUtils.findManagedMethod(iface, methodName, paramTypes);
            if (managedMethod2 == null) continue;
            return managedMethod2;
        }
        return null;
    }

    public static boolean isManagedMethod(Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(ManagedAnnotation.class)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFlatten(Method method) {
        return method != null && AnnotationUtils.isAnnotationPresent(Flatten.class, new HashSet<Class<? extends Annotation>>(), method.getAnnotations());
    }

    public static boolean isNested(Method method) {
        return method != null && AnnotationUtils.isAnnotationPresent(Nested.class, new HashSet<Class<? extends Annotation>>(), method.getAnnotations());
    }

    private static boolean isAnnotationPresent(Class<? extends Annotation> annotationClass, Set<Class<? extends Annotation>> processedTypes, Annotation ... annotations) {
        for (Annotation annotation : annotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            return true;
        }
        for (Annotation annotation : annotations) {
            if (!processedTypes.add(annotation.annotationType()) || !AnnotationUtils.isAnnotationPresent(annotationClass, processedTypes, annotation.annotationType().getAnnotations())) continue;
            return true;
        }
        return false;
    }
}

