/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx;

import java.lang.reflect.Method;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import org.weakref.jmx.MBeanAttribute;
import org.weakref.jmx.ReflectionUtils;

class ReflectionMBeanAttribute
implements MBeanAttribute {
    private final MBeanAttributeInfo info;
    private final Object target;
    private final String name;
    private final Method getter;
    private final Method setter;

    public ReflectionMBeanAttribute(MBeanAttributeInfo info, Object target, Method getter2, Method setter2) {
        if (info == null) {
            throw new NullPointerException("info is null");
        }
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        this.info = info;
        this.target = target;
        this.name = info.getName();
        this.getter = getter2;
        this.setter = setter2;
    }

    public MBeanAttributeInfo getInfo() {
        return this.info;
    }

    public Object getTarget() {
        return this.target;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (this.getter == null) {
            throw new AttributeNotFoundException(this.name + " is write-only");
        }
        Object result2 = ReflectionUtils.invoke(this.target, this.getter, new Object[0]);
        return result2;
    }

    public void setValue(Object value2) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.setter == null) {
            throw new AttributeNotFoundException(this.name + " is read-only");
        }
        if (!ReflectionUtils.isAssignable(value2, this.setter.getParameterTypes()[0])) {
            throw new InvalidAttributeValueException("Can not assign " + value2.getClass() + " to attribute " + this.name);
        }
        ReflectionUtils.invoke(this.target, this.setter, value2);
    }
}

