/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeOperationsException;
import org.weakref.jmx.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ReflectionUtils {
    private static final Pattern getterOrSetterPattern = Pattern.compile("(get|set|is)(.+)");
    private static final Map<Class<?>, Class<?>> primitiveToWrapper;

    private ReflectionUtils() {
    }

    public static Object invoke(Object target, Method method, Object ... params) throws MBeanException, ReflectionException {
        ReflectionUtils.assertNotNull(target, "target");
        ReflectionUtils.assertNotNull(target, "method");
        ReflectionUtils.assertNotNull(target, "params");
        try {
            Object result2 = method.invoke(target, params);
            return result2;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw new MBeanException((RuntimeException)targetException, "RuntimeException occured while invoking " + ReflectionUtils.toSimpleName(method));
            }
            if (targetException instanceof ReflectionException) {
                throw (ReflectionException)targetException;
            }
            if (targetException instanceof MBeanException) {
                throw (MBeanException)targetException;
            }
            if (targetException instanceof Exception) {
                throw new MBeanException((Exception)targetException, "Exception occured while invoking " + ReflectionUtils.toSimpleName(method));
            }
            if (targetException instanceof Error) {
                throw new RuntimeErrorException((Error)targetException, "Error occured while invoking " + ReflectionUtils.toSimpleName(method));
            }
            throw new RuntimeErrorException((Error)((Object)new AssertionError((Object)targetException)), "Unexpected throwable occured while invoking " + ReflectionUtils.toSimpleName(method));
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e, "RuntimeException occured while invoking " + ReflectionUtils.toSimpleName(method));
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, "IllegalAccessException occured while invoking " + ReflectionUtils.toSimpleName(method));
        }
        catch (Error err2) {
            throw new RuntimeErrorException(err2, "Error occured while invoking " + ReflectionUtils.toSimpleName(method));
        }
        catch (Exception e) {
            throw new ReflectionException(e, "Exception occured while invoking " + ReflectionUtils.toSimpleName(method));
        }
    }

    private static String toSimpleName(Method method) {
        return new Signature(method).toString();
    }

    public static boolean isGetter(Method method) {
        String methodName = method.getName();
        return (methodName.startsWith("get") || methodName.startsWith("is")) && ReflectionUtils.isValidGetter(method);
    }

    public static boolean isSetter(Method method) {
        return method.getName().startsWith("set") && ReflectionUtils.isValidSetter(method);
    }

    public static String getAttributeName(Method method) {
        Matcher matcher = getterOrSetterPattern.matcher(method.getName());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("method does not represent a getter or setter");
        }
        return matcher.group(2);
    }

    public static boolean isValidGetter(Method getter2) {
        if (getter2 == null) {
            throw new NullPointerException("getter is null");
        }
        if (getter2.getParameterTypes().length != 0) {
            return false;
        }
        return !getter2.getReturnType().equals(Void.TYPE);
    }

    public static boolean isValidSetter(Method setter2) {
        if (setter2 == null) {
            throw new NullPointerException("setter is null");
        }
        return setter2.getParameterTypes().length == 1;
    }

    public static boolean isAssignable(Object value2, Class<?> type) {
        if (type.isPrimitive()) {
            return primitiveToWrapper.get(type).isInstance(value2);
        }
        return value2 == null || type.isInstance(value2);
    }

    private static void assertNotNull(Object param2, String name) {
        if (param2 == null) {
            throw new RuntimeOperationsException(new NullPointerException(name + " is null"));
        }
    }

    static {
        LinkedHashMap<Class<Comparable<Boolean>>, Class> map2 = new LinkedHashMap<Class<Comparable<Boolean>>, Class>();
        map2.put(Boolean.TYPE, Boolean.class);
        map2.put(Character.TYPE, Character.class);
        map2.put(Byte.TYPE, Byte.class);
        map2.put(Short.TYPE, Short.class);
        map2.put(Integer.TYPE, Integer.class);
        map2.put(Long.TYPE, Long.class);
        map2.put(Float.TYPE, Float.class);
        map2.put(Double.TYPE, Double.class);
        primitiveToWrapper = Collections.unmodifiableMap(map2);
    }
}

