/*
 * Decompiled with CFR 0.152.
 */
package sonia.maven.native2utf8;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import sonia.maven.native2utf8.Native2UTF8;

public class Native2UTF8Mojo
extends AbstractMojo {
    protected String encoding;
    protected String[] excludes;
    protected String[] includes;
    protected File tempDir;
    protected File workDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Iterator files;
        if (!this.workDir.exists()) {
            return;
        }
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.encoding = System.getProperty("file.encoding");
            this.getLog().warn((CharSequence)("Using platform encoding (" + this.encoding + " actually) to convert resources!"));
        }
        if (this.includes == null || this.includes.length == 0) {
            this.includes = new String[]{"**/*.properties"};
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        try {
            this.getLog().info((CharSequence)("Includes: " + Arrays.asList(this.includes)));
            this.getLog().info((CharSequence)("Excludes: " + Arrays.asList(this.excludes)));
            String incl = StringUtils.join((Object[])this.includes, (String)",");
            String excl = StringUtils.join((Object[])this.excludes, (String)",");
            files = FileUtils.getFiles((File)this.workDir, (String)incl, (String)excl).iterator();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to get list of files");
        }
        while (files.hasNext()) {
            File file = (File)files.next();
            this.getLog().info((CharSequence)("Processing " + file.getAbsolutePath()));
            try {
                File tempFile = File.createTempFile(file.getName(), "native2utf8", this.tempDir);
                Native2UTF8.nativeToUTF8(file, tempFile, this.encoding);
                FileUtils.rename((File)tempFile, (File)file);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to convert " + file.getAbsolutePath(), (Exception)e);
            }
        }
    }
}

