/*
 * Decompiled with CFR 0.152.
 */
package de.spaceteams.aws.http;

import akka.Done;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentType$;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpHeader$;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocols$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.RequestEntityAcceptance;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Content$minusLength$;
import akka.http.scaladsl.model.headers.Content$minusType$;
import akka.http.scaladsl.settings.ConnectionPoolSettings;
import akka.stream.Graph;
import akka.stream.Materializer$;
import akka.stream.scaladsl.FlowOpsMat;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString$;
import de.spaceteams.aws.http.AkkaAwsHttpClient;
import java.io.Serializable;
import org.reactivestreams.Publisher;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SetOps;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;

public final class AkkaAwsHttpClient$ {
    public static final AkkaAwsHttpClient$ MODULE$ = new AkkaAwsHttpClient$();

    public Option<ConnectionPoolSettings> $lessinit$greater$default$1() {
        return None$.MODULE$;
    }

    public HttpRequest toAkkaRequest(AsyncExecuteRequest request) {
        HttpEntity.Strict strict;
        SdkHttpRequest underlyingRequest = request.request();
        SdkHttpContentPublisher contentPublisher = request.requestContentPublisher();
        HttpMethod httpMethod = (HttpMethod)HttpMethods$.MODULE$.getForKeyCaseInsensitive(underlyingRequest.method().name(), (.less.colon.less)$less$colon$less$.MODULE$.refl()).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unsupported HTTP method: ").append(underlyingRequest.method()).toString());
        });
        List headers = (List)CollectionConverters$.MODULE$.MapHasAsScala(underlyingRequest.headers()).asScala().foldLeft((Object)package$.MODULE$.List().empty(), (Function2 & Serializable)(prev, header) -> {
            HttpHeader header2;
            Tuple2 tuple2 = header;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            java.util.List value = (java.util.List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)name, (Object)value);
            Tuple2 tuple23 = tuple22;
            String name2 = (String)tuple23._1();
            java.util.List value2 = (java.util.List)tuple23._2();
            HttpHeader.ParsingResult parsingResult = HttpHeader$.MODULE$.parse(name2, CollectionConverters$.MODULE$.ListHasAsScala(value2).asScala().mkString(","), HttpHeader$.MODULE$.parse$default$3());
            if (parsingResult instanceof HttpHeader.ParsingResult$.Error) {
                HttpHeader.ParsingResult$.Error error = (HttpHeader.ParsingResult$.Error)parsingResult;
                ErrorInfo error2 = error.error();
                throw new IllegalArgumentException(new StringBuilder(31).append("Failure parsing HTTP header: ").append(name2).append(": ").append(error2.formatPretty()).toString());
            }
            if (!(parsingResult instanceof HttpHeader.ParsingResult$.Ok)) {
                throw new MatchError((Object)parsingResult);
            }
            HttpHeader.ParsingResult$.Ok ok = (HttpHeader.ParsingResult$.Ok)parsingResult;
            HttpHeader httpHeader = header2 = ok.header();
            List list = prev.$colon$colon((Object)httpHeader);
            return list;
        });
        List requestHeaders = headers.filterNot((Function1 & Serializable)header -> BoxesRunTime.boxToBoolean((boolean)AkkaAwsHttpClient$.$anonfun$toAkkaRequest$3(header)));
        RequestEntityAcceptance requestEntityAcceptance = httpMethod.requestEntityAcceptance();
        if (RequestEntityAcceptance.Expected$.MODULE$.equals(requestEntityAcceptance)) {
            HttpEntity.Chunked chunked;
            ContentType contentType = (ContentType)headers.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.is(Content$minusType$.MODULE$.lowercaseName()))).map((Function1 & Serializable)h -> {
                ContentType value;
                Either either = ContentType$.MODULE$.parse(h.value());
                if (either instanceof Left) {
                    Left left = (Left)either;
                    List value2 = (List)left.value();
                    throw new IllegalArgumentException(new StringBuilder(36).append("Unsupported content type value: ").append(h.value()).append(". \n ").append(value2.map((Function1 & Serializable)x$4 -> x$4.formatPretty()).mkString("\n")).toString());
                }
                if (!(either instanceof Right)) {
                    throw new MatchError((Object)either);
                }
                Right right = (Right)either;
                ContentType contentType = value = (ContentType)right.value();
                return contentType;
            }).getOrElse((Function0 & Serializable)() -> ContentTypes$.MODULE$.NoContentType());
            Source source = (Source)Source$.MODULE$.fromPublisher((Publisher)contentPublisher).map((Function1 & Serializable)x$5 -> ByteString$.MODULE$.apply(x$5));
            Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(contentPublisher.contentLength()));
            if (option instanceof Some) {
                Some some = (Some)option;
                Long length = (Long)some.value();
                chunked = HttpEntity$.MODULE$.apply(contentType, Predef$.MODULE$.Long2long(length), source);
            } else if (None$.MODULE$.equals(option)) {
                chunked = HttpEntity$.MODULE$.apply(contentType, source);
            } else {
                throw new MatchError((Object)option);
            }
            strict = chunked;
        } else {
            strict = HttpEntity$.MODULE$.Empty();
        }
        HttpEntity.Strict entity = strict;
        return HttpRequest$.MODULE$.apply(httpMethod, Uri$.MODULE$.apply(underlyingRequest.getUri().toString()), (scala.collection.immutable.Seq)requestHeaders, (RequestEntity)entity, HttpProtocols$.MODULE$.HTTP$div1$u002E1());
    }

    public Future<BoxedUnit> toAwsSdkResponse(HttpResponse response, SdkAsyncHttpResponseHandler handler, ActorSystem actorSystem, ExecutionContext ec) {
        SdkHttpFullResponse.Builder resp = SdkHttpFullResponse.builder().headers(CollectionConverters$.MODULE$.MapHasAsJava((Map)response.headers().groupBy((Function1 & Serializable)x$6 -> x$6.name()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            scala.collection.immutable.Seq v = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)v.map((Function1 & Serializable)x$7 -> x$7.value())).asJava());
            return tuple22;
        })).asJava()).statusCode(response.status().intValue()).statusText(response.status().reason());
        OptionConverters.RichOptionalLong$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptionalLong(response.entity().getContentLengthOption())).foreach((Function1 & Serializable)cl -> resp.appendHeader(Content$minusLength$.MODULE$.name(), Long.toString(BoxesRunTime.unboxToLong((Object)cl))));
        resp.appendHeader(Content$minusType$.MODULE$.name(), response.entity().getContentType().toString());
        Tuple2 tuple2 = (Tuple2)((Source)((FlowOpsMat)response.entity().dataBytes().map((Function1 & Serializable)x$8 -> x$8.asByteBuffer())).alsoToMat((Graph)Sink$.MODULE$.ignore(), Keep$.MODULE$.right())).toMat((Graph)Sink$.MODULE$.asPublisher(false), Keep$.MODULE$.both()).run(Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)actorSystem));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Future done = (Future)tuple2._1();
        Publisher content = (Publisher)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)done, (Object)content);
        Tuple2 tuple23 = tuple22;
        Future done2 = (Future)tuple23._1();
        Publisher content2 = (Publisher)tuple23._2();
        handler.onHeaders((SdkHttpResponse)resp.build());
        handler.onStream(content2);
        return done2.map((Function1 & Serializable)x$10 -> {
            AkkaAwsHttpClient$.$anonfun$toAwsSdkResponse$6(x$10);
            return BoxedUnit.UNIT;
        }, ec);
    }

    public AkkaAwsHttpClient apply(Option<ConnectionPoolSettings> connectionPoolSettings, ActorSystem actorSystem) {
        ExecutionContextExecutor ec = actorSystem.dispatcher();
        return new AkkaAwsHttpClient(connectionPoolSettings, actorSystem, (ExecutionContext)ec);
    }

    public Option<ConnectionPoolSettings> apply$default$1() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$toAkkaRequest$3(HttpHeader header) {
        return ((SetOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Content$minusLength$.MODULE$.lowercaseName(), Content$minusType$.MODULE$.lowercaseName()}))).contains((Object)header.lowercaseName());
    }

    public static final /* synthetic */ void $anonfun$toAwsSdkResponse$6(Done x$10) {
    }

    private AkkaAwsHttpClient$() {
    }
}

