/*
 * Decompiled with CFR 0.152.
 */
package de.spaceteams.jsonlogging;

import de.spaceteams.jsonlogging.JsonLogger$;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.LegacyAbstractLogger;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.MDCAdapter;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.javaapi.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;

public abstract class JsonLogger
extends LegacyAbstractLogger {
    private final String name;
    private final JsonLogger parent;
    private final MDCAdapter mdcAdapter;
    private final PrintStream out;
    private final DateTimeFormatter dateTimeFormat;
    private List<JsonLogger> children;
    private Option<Level> level;
    private int levelInt;

    public static Map<String, String> logging_context() {
        return JsonLogger$.MODULE$.logging_context();
    }

    public JsonLogger(String name, JsonLogger parent, MDCAdapter mdcAdapter, PrintStream out) {
        this.name = name;
        this.parent = parent;
        this.mdcAdapter = mdcAdapter;
        this.out = out;
        this.dateTimeFormat = DateTimeFormatter.ISO_INSTANT;
        this.children = package$.MODULE$.Nil();
        this.level = None$.MODULE$;
        this.levelInt = Level.INFO.toInt();
    }

    public String getName() {
        return this.name;
    }

    public DateTimeFormatter dateTimeFormat() {
        return this.dateTimeFormat;
    }

    public String getFullyQualifiedCallerName() {
        return null;
    }

    public abstract String serialize(Map<String, String> var1);

    public abstract JsonLogger mkChildInstance(String var1);

    private int levelInt() {
        return this.levelInt;
    }

    private void levelInt_$eq(int x$0) {
        this.levelInt = x$0;
    }

    public Option<Level> getLevel() {
        return this.level;
    }

    public void setLevel(Option<Level> newLevel) {
        block5: {
            JsonLogger jsonLogger = this;
            synchronized (jsonLogger) {
                block4: {
                    Option<Level> option = this.level;
                    Option<Level> option2 = newLevel;
                    if (!(option == null ? option2 != null : !option.equals(option2))) break block4;
                    if (newLevel.isEmpty() && Option$.MODULE$.apply((Object)this.parent).isEmpty()) {
                        throw new IllegalArgumentException("The log level of the root logger cannot be unset.");
                    }
                    this.level = newLevel;
                    newLevel.orElse(this::setLevel$$anonfun$1).foreach((Function1)(JProcedure1 & Serializable)effectiveLevel -> this.levelInt_$eq(effectiveLevel.toInt()));
                    this.children.foreach((Function1)(JProcedure1 & Serializable)child -> child.handleParentLevelChange(newLevel));
                    break block5;
                }
                return;
            }
        }
    }

    public JsonLogger createChild(String childName) {
        return (JsonLogger)((Object)this.children.find((Function1 & Serializable)_$1 -> {
            String string = _$1.getName();
            String string2 = childName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).getOrElse(() -> this.createChild$$anonfun$2(childName)));
    }

    public void handleParentLevelChange(Option<Level> newLevel) {
        JsonLogger jsonLogger = this;
        synchronized (jsonLogger) {
            BoxedUnit boxedUnit;
            if (this.level.isEmpty()) {
                newLevel.foreach((Function1)(JProcedure1 & Serializable)l -> {
                    this.levelInt_$eq(l.toInt());
                    this.children.foreach((Function1)(JProcedure1 & Serializable)c -> c.handleParentLevelChange(newLevel));
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public boolean isTraceEnabled() {
        return this.levelInt() <= Level.TRACE.toInt();
    }

    public boolean isDebugEnabled() {
        return this.levelInt() <= Level.DEBUG.toInt();
    }

    public boolean isInfoEnabled() {
        return this.levelInt() <= Level.INFO.toInt();
    }

    public boolean isWarnEnabled() {
        return this.levelInt() <= Level.WARN.toInt();
    }

    public boolean isErrorEnabled() {
        return this.levelInt() <= Level.ERROR.toInt();
    }

    public void handleNormalizedLoggingCall(Level level, Marker marker, String msg, Object[] arguments, Throwable throwable) {
        scala.collection.mutable.Map map = (scala.collection.mutable.Map)JsonLogger$.MODULE$.logging_context().headOption().map((Function1 & Serializable)_$2 -> (scala.collection.mutable.Map)Map$.MODULE$.from(JsonLogger$.MODULE$.logging_context())).getOrElse(JsonLogger::$anonfun$2);
        Option$.MODULE$.apply((Object)this.mdcAdapter.getCopyOfContextMap()).filter((Function1 & Serializable)m -> !m.isEmpty()).foreach((Function1 & Serializable)mdc -> (scala.collection.mutable.Map)map.addAll((IterableOnce)CollectionConverters$.MODULE$.asScala(mdc)));
        map.put((Object)"timestamp", (Object)this.dateTimeFormat().format(Instant.now()));
        map.put((Object)"level", (Object)level.toString());
        String message = MessageFormatter.basicArrayFormat((String)msg, (Object[])arguments);
        map.put((Object)"message", (Object)message);
        map.put((Object)"logger", (Object)this.name);
        Option$.MODULE$.apply((Object)throwable).foreach((Function1 & Serializable)t -> {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            return map.put((Object)"exception", (Object)sw.toString());
        });
        String outputString = this.serialize((Map<String, String>)map.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.out.println(outputString);
    }

    private final Option setLevel$$anonfun$1() {
        return this.parent.getLevel();
    }

    private final JsonLogger createChild$$anonfun$2(String childName$2) {
        JsonLogger jsonLogger;
        JsonLogger jsonLogger2 = this;
        synchronized (jsonLogger2) {
            JsonLogger instance = this.mkChildInstance(childName$2);
            instance.levelInt_$eq(this.levelInt());
            this.children = this.children.$colon$colon((Object)instance);
            jsonLogger = instance;
        }
        return jsonLogger;
    }

    private static final scala.collection.mutable.Map $anonfun$2() {
        return (scala.collection.mutable.Map)Map$.MODULE$.empty();
    }
}

