/*
 * Decompiled with CFR 0.152.
 */
package de.spaceteams.jsonlogging;

import de.spaceteams.jsonlogging.ConfigurationService;
import de.spaceteams.jsonlogging.JsonLogger;
import de.spaceteams.jsonlogging.JsonLoggerFactory;
import java.util.ServiceLoader;
import org.slf4j.IMarkerFactory;
import org.slf4j.helpers.BasicMDCAdapter;
import org.slf4j.helpers.BasicMarkerFactory;
import org.slf4j.spi.MDCAdapter;
import org.slf4j.spi.SLF4JServiceProvider;

public abstract class JsonLoggerServiceProvider
implements SLF4JServiceProvider {
    private final String REQUIRED_VERSION;
    private final IMarkerFactory getMarkerFactory;
    private final MDCAdapter getMDCAdapter;

    public JsonLoggerServiceProvider() {
        this.REQUIRED_VERSION = "2.0.99";
        BasicMarkerFactory markerFactory = new BasicMarkerFactory();
        BasicMDCAdapter mdcAdapter = new BasicMDCAdapter();
        this.getMarkerFactory = markerFactory;
        this.getMDCAdapter = mdcAdapter;
    }

    public abstract JsonLoggerFactory<? extends JsonLogger> getLoggerFactory();

    public IMarkerFactory getMarkerFactory() {
        return this.getMarkerFactory;
    }

    public MDCAdapter getMDCAdapter() {
        return this.getMDCAdapter;
    }

    public String getRequestedApiVersion() {
        return this.REQUIRED_VERSION;
    }

    public void initialize() {
        ServiceLoader<ConfigurationService> loader = ServiceLoader.load(ConfigurationService.class);
        loader.forEach(consumer -> consumer.configure(this.getLoggerFactory()));
    }
}

