/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.attribute;

import de.spricom.dessert.classfile.attribute.ElementValuePair;
import de.spricom.dessert.classfile.constpool.ConstantPool;
import de.spricom.dessert.classfile.constpool.FieldType;
import de.spricom.dessert.classfile.dependency.DependencyHolder;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;

public class Annotation
implements DependencyHolder {
    private FieldType type;
    private ElementValuePair[] elementValuePairs;

    public Annotation(DataInputStream is, ConstantPool constantPool) throws IOException {
        this.type = constantPool.getFieldType(is.readUnsignedShort());
        this.elementValuePairs = new ElementValuePair[is.readUnsignedShort()];
        for (int i = 0; i < this.elementValuePairs.length; ++i) {
            this.elementValuePairs[i] = new ElementValuePair(is, constantPool);
        }
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        this.type.addDependentClassNames(classNames);
        for (ElementValuePair pair : this.elementValuePairs) {
            pair.addDependentClassNames(classNames);
        }
    }

    public FieldType getType() {
        return this.type;
    }

    public ElementValuePair[] getElementValuePairs() {
        return this.elementValuePairs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.type.toString());
        for (ElementValuePair pair : this.elementValuePairs) {
            sb.append(" ").append(pair);
        }
        return sb.toString();
    }
}

