/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.attribute;

import de.spricom.dessert.classfile.attribute.CodeAttribute;
import de.spricom.dessert.classfile.attribute.ConstantValueAttribute;
import de.spricom.dessert.classfile.attribute.EnclosingMethodAttribute;
import de.spricom.dessert.classfile.attribute.InnerClassesAttribute;
import de.spricom.dessert.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import de.spricom.dessert.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import de.spricom.dessert.classfile.attribute.SignatureAttribute;
import de.spricom.dessert.classfile.attribute.UnknownAttribute;
import de.spricom.dessert.classfile.constpool.ConstantPool;
import de.spricom.dessert.classfile.dependency.DependencyHolder;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;

public abstract class AttributeInfo
implements DependencyHolder {
    private final String name;
    private AttributeContext context;

    public static AttributeInfo[] readAttributes(DataInputStream is, ConstantPool constantPool, AttributeContext context) throws IOException {
        AttributeInfo[] attributes = new AttributeInfo[is.readUnsignedShort()];
        for (int i = 0; i < attributes.length; ++i) {
            String name = constantPool.getUtf8String(is.readUnsignedShort());
            attributes[i] = "ConstantValue".equals(name) ? new ConstantValueAttribute(name, is, constantPool) : ("Code".equals(name) ? new CodeAttribute(name, is, constantPool) : ("RuntimeVisibleAnnotations".equals(name) ? new RuntimeVisibleAnnotationsAttribute(name, is, constantPool) : ("RuntimeVisibleParameterAnnotations".equals(name) ? new RuntimeVisibleParameterAnnotationsAttribute(name, is, constantPool) : ("Signature".equals(name) ? new SignatureAttribute(name, is, constantPool) : ("EnclosingMethod".equals(name) ? new EnclosingMethodAttribute(name, is, constantPool) : ("InnerClasses".equals(name) ? new InnerClassesAttribute(name, is, constantPool) : new UnknownAttribute(name, is)))))));
            attributes[i].context = context;
        }
        return attributes;
    }

    public AttributeInfo(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected final void checkAttributeLength(DataInputStream is, int expectedLength, String name) throws IOException {
        int len = is.readInt();
        if (len != expectedLength) {
            throw new IOException("Unexpected length of " + len + " for attribute " + name);
        }
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
    }

    public AttributeContext getContext() {
        return this.context;
    }

    public AttributeInfo[] getAttributes() {
        return new AttributeInfo[0];
    }

    public String toString() {
        return this.getName();
    }

    public static enum AttributeContext {
        CLASS,
        FIELD,
        METHOD,
        CODE;

    }
}

