/*
 * Decompiled with CFR 0.152.
 */
package de.spricom.dessert.classfile.attribute;

import de.spricom.dessert.classfile.attribute.Annotation;
import de.spricom.dessert.classfile.attribute.AttributeInfo;
import de.spricom.dessert.classfile.constpool.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;

public class RuntimeVisibleAnnotationsAttribute
extends AttributeInfo {
    private final Annotation[] annotations;

    public RuntimeVisibleAnnotationsAttribute(String name, DataInputStream is, ConstantPool constantPool) throws IOException {
        super(name);
        is.readInt();
        this.annotations = new Annotation[is.readUnsignedShort()];
        for (int i = 0; i < this.annotations.length; ++i) {
            this.annotations[i] = new Annotation(is, constantPool);
        }
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public void addDependentClassNames(Set<String> classNames) {
        for (Annotation annotation : this.annotations) {
            annotation.addDependentClassNames(classNames);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        boolean first = true;
        for (Annotation annotation : this.annotations) {
            if (first) {
                sb.append(": ");
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(annotation);
        }
        return sb.toString();
    }
}

